/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.border.FocusStateMatteBorder;
import com.explodingpixels.macwidgets.BottomBarSize;
import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.painter.FocusStatePainter;
import com.explodingpixels.painter.GradientPainter;
import com.explodingpixels.painter.MacWidgetsPainter;
import com.explodingpixels.widgets.WindowDragger;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class BottomBar {
    protected final TriAreaComponent fBottomBar = new TriAreaComponent(5, false);
    protected JSplitPane fSplitPane;
    protected final SplitterHandleMouseMovementHandler fMouseListener = new SplitterHandleMouseMovementHandler();
    protected static final Color ACTIVE_TOP_COLOR = new Color(0xCCCCCC);
    protected static final Color ACTIVE_BOTTOM_COLOR = new Color(0xA7A7A7);
    protected static final Color INACTIVE_TOP_COLOR = new Color(0xE9E9E9);
    protected static final Color INACTIVE_BOTTOM_COLOR = new Color(0xD8D8D8);
    protected static final Color BORDER_HIGHLIGHT_COLOR = new Color(255, 255, 255, 100);

    public BottomBar(BottomBarSize size) {
        this.createAndInstallBackgroundPainter();
        this.createAndInstallBorder();
        int height = size.getHeight() + 2;
        this.fBottomBar.getComponent().setPreferredSize(new Dimension(-1, height));
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this.fBottomBar.getComponent());
    }

    public void addComponentToLeft(JComponent toolToAdd) {
        this.fBottomBar.addComponentToLeft(toolToAdd);
    }

    public void addComponentToLeft(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToLeft(toolToAdd, spacer_pixels);
    }

    public void addComponentToCenter(JComponent toolToAdd) {
        this.fBottomBar.addComponentToCenter(toolToAdd);
    }

    public void addComponentToCenter(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToCenter(toolToAdd, spacer_pixels);
    }

    public void addComponentToRight(JComponent toolToAdd) {
        this.fBottomBar.addComponentToRight(toolToAdd);
    }

    public void addComponentToRight(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToRight(toolToAdd, spacer_pixels);
    }

    public void installWindowDraggerOnWindow(Window window) {
        new WindowDragger(window, this.getComponent());
    }

    public JComponent getComponent() {
        return this.fBottomBar.getComponent();
    }

    public void forceAreasToHaveTheSameWidth() {
        this.fBottomBar.forceAreasToHaveTheSameWidth();
    }

    public void forceOuterAreasToHaveTheSameWidth() {
        this.fBottomBar.forceOuterAreasToHaveTheSameWidth();
    }

    public void installDraggableWidgetOnSplitPane(JSplitPane splitPane) {
        if (splitPane == null) {
            throw new IllegalArgumentException("JSplitPane cannot be null.");
        }
        this.fSplitPane = splitPane;
        this.getComponent().addMouseListener(this.fMouseListener);
        this.getComponent().addMouseMotionListener(this.fMouseListener);
    }

    private void createAndInstallBackgroundPainter() {
        this.fBottomBar.setBackgroundPainter(BottomBar.createDefaultPainter());
    }

    private void createAndInstallBorder() {
        FocusStateMatteBorder outterBorder = new FocusStateMatteBorder(1, 0, 0, 0, MacColorUtils.getTexturedWindowToolbarBorderFocusedColor(), MacColorUtils.getTexturedWindowToolbarBorderUnfocusedColor(), this.fBottomBar.getComponent());
        MatteBorder innerBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, BottomBar.getBorderHighlightColor());
        CompoundBorder lineBorders = BorderFactory.createCompoundBorder(outterBorder, innerBorder);
        int padding = 5;
        this.fBottomBar.getComponent().setBorder(BorderFactory.createCompoundBorder(lineBorders, BorderFactory.createEmptyBorder(0, padding, 0, padding)));
    }

    private static MacWidgetsPainter<Component> createDefaultPainter() {
        GradientPainter focusedPainter = new GradientPainter(ACTIVE_TOP_COLOR, ACTIVE_BOTTOM_COLOR);
        GradientPainter unfocusedPainter = new GradientPainter(INACTIVE_TOP_COLOR, INACTIVE_BOTTOM_COLOR);
        return new FocusStatePainter(focusedPainter, focusedPainter, unfocusedPainter);
    }

    private static Color getBorderHighlightColor() {
        return BORDER_HIGHLIGHT_COLOR;
    }

    private class SplitterHandleMouseMovementHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int fDelta;

        private SplitterHandleMouseMovementHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(BottomBar.this.getComponent(), e, BottomBar.this.fSplitPane);
            this.fDelta = BottomBar.this.fSplitPane.getDividerLocation() - convertedEvent.getPoint().y;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(BottomBar.this.getComponent(), e, BottomBar.this.fSplitPane);
            int newLocation = convertedEvent.getPoint().y + this.fDelta;
            int boundedNewLocation = Math.max(BottomBar.this.fSplitPane.getMinimumDividerLocation(), Math.min(newLocation, BottomBar.this.fSplitPane.getMaximumDividerLocation()));
            BottomBar.this.fSplitPane.setDividerLocation(boundedNewLocation);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

