/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xmind.gef.ISourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySourceProvider
implements ISourceProvider {
    private List<Object> sources;

    public ArraySourceProvider() {
        this.sources = new ArrayList<Object>();
    }

    public ArraySourceProvider(Object source) {
        this.sources = new ArrayList<Object>();
        this.addSource(source);
    }

    public ArraySourceProvider(Collection<?> sources) {
        this.sources = new ArrayList<Object>(sources.size());
        this.addSources(sources);
    }

    @Override
    public List<Object> getSources() {
        return this.sources;
    }

    @Override
    public Object getSource() {
        return this.sources.isEmpty() ? null : this.sources.get(0);
    }

    @Override
    public boolean hasSource() {
        return !this.sources.isEmpty();
    }

    public void setSources(Collection<?> newSources) {
        this.sources.clear();
        this.addSources(newSources);
    }

    public void setSource(Object source) {
        this.sources.clear();
        this.addSource(source);
    }

    public void addSources(Collection<?> newSources) {
        for (Object source : newSources) {
            this.addSource(source);
        }
    }

    public void addSource(Object source) {
        if (source != null && !this.sources.contains(source)) {
            this.sources.add(source);
        }
    }

    public void removeSource(Object source) {
        this.sources.remove(source);
    }

    public void removeSources(Collection<Object> sources) {
        this.sources.removeAll(sources);
    }

    public void removeAllSources() {
        this.sources.clear();
    }
}

