/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.xmind.ui.internal.styleeditor.StyleEditModel;

public class UndoStylePropertyChangeAction
extends Action
implements PropertyChangeListener {
    private StyleEditModel model = null;

    public void setModel(StyleEditModel model) {
        StyleEditModel oldModel = this.model;
        this.model = model;
        if (oldModel != null) {
            oldModel.removeListener(this);
        }
        if (model != null) {
            model.addListener(this);
        }
        this.update();
    }

    protected void update() {
        if (this.model == null) {
            this.setEnabled(false);
            this.setText(WorkbenchMessages.Workbench_undo);
        } else {
            this.setEnabled(this.model.canUndo());
            IUndoableOperation operation = this.model.getUndoOperation();
            this.setText(operation == null ? WorkbenchMessages.Workbench_undo : NLS.bind((String)"{0} {1}", (Object)WorkbenchMessages.Workbench_undo, (Object)operation.getLabel()));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    public void run() {
        if (this.model == null) {
            return;
        }
        final IUndoContext context = this.model.getUndoContext();
        if (context == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().undo(context, null, null);
            }
        });
    }
}

