/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.resizers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.coobird.thumbnailator.resizers.Resizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResizer
implements Resizer {
    protected final Map<RenderingHints.Key, Object> RENDERING_HINTS = new HashMap<RenderingHints.Key, Object>();
    protected final Map<RenderingHints.Key, Object> UNMODIFIABLE_RENDERING_HINTS;
    protected static final RenderingHints.Key KEY_INTERPOLATION = RenderingHints.KEY_INTERPOLATION;

    protected AbstractResizer(Object interpolationValue, Map<RenderingHints.Key, Object> hints) {
        this.RENDERING_HINTS.put(KEY_INTERPOLATION, interpolationValue);
        if (hints.containsKey(KEY_INTERPOLATION) && !interpolationValue.equals(hints.get(KEY_INTERPOLATION))) {
            throw new IllegalArgumentException("Cannot change the RenderingHints.KEY_INTERPOLATION value.");
        }
        this.RENDERING_HINTS.putAll(hints);
        this.UNMODIFIABLE_RENDERING_HINTS = Collections.unmodifiableMap(this.RENDERING_HINTS);
    }

    @Override
    public void resize(BufferedImage srcImage, BufferedImage destImage) {
        this.performChecks(srcImage, destImage);
        int width = destImage.getWidth();
        int height = destImage.getHeight();
        Graphics2D g = destImage.createGraphics();
        g.setRenderingHints(this.RENDERING_HINTS);
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.dispose();
    }

    protected void performChecks(BufferedImage srcImage, BufferedImage destImage) {
        if (srcImage == null || destImage == null) {
            throw new NullPointerException("The source and/or destination image is null.");
        }
    }

    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return this.UNMODIFIABLE_RENDERING_HINTS;
    }
}

