/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.IBoundary;
import org.xmind.core.IComment;
import org.xmind.core.IControlPoint;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.ILegend;
import org.xmind.core.IManifest;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.INumbering;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetSettings;
import org.xmind.core.ISpan;
import org.xmind.core.ISummary;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.ObjectRefManager;
import org.xmind.core.util.Point;
import org.xmind.core.util.Property;
import org.xmind.core.util.Ranges;
import org.xmind.seawind.internal.core.PathInfo;

public class SheetSerializer {
    private ISheet sheet;
    private IStorage resourceStorage;

    public SheetSerializer(ISheet sheet, IStorage resourceStorage) {
        this.sheet = sheet;
        this.resourceStorage = resourceStorage;
    }

    public JSONObject serialize() throws IOException, InvocationTargetException {
        Point position;
        ObjectRefManager refManager = (ObjectRefManager)this.sheet.getOwnedWorkbook().getAdapter(ObjectRefManager.class);
        Assert.isNotNull((Object)refManager);
        JSONObject sheetObject = new JSONObject();
        sheetObject.put("id", (Object)this.sheet.getId());
        sheetObject.put("rootTopic", (Object)this.toJSON(this.sheet.getRootTopic()));
        JSONArray relationshipArray = new JSONArray();
        for (IRelationship relationship : this.sheet.getRelationships()) {
            relationshipArray.put((Object)this.toJSON(relationship));
        }
        if (relationshipArray.length() > 0) {
            sheetObject.put("relationships", (Object)relationshipArray);
        }
        JSONObject legendObject = new JSONObject();
        ILegend legend = this.sheet.getLegend();
        if (legend.isVisible()) {
            legendObject.put("visibility", (Object)"visible");
        }
        if ((position = legend.getPosition()) != null) {
            legendObject.put("position", (Object)new JSONObject().put("x", position.x).put("y", position.y));
        }
        JSONObject markerMapObject = new JSONObject();
        JSONObject groupMapObject = new JSONObject();
        IMarkerSheet markerSheet = this.sheet.getOwnedWorkbook().getMarkerSheet();
        for (String markerId : refManager.getRefsFor(this.sheet, "marker")) {
            JSONArray markerArray;
            String resourcePath;
            Object group;
            IMarker marker = markerSheet.getMarker(markerId);
            if (marker == null || (group = marker.getParent()) == null || group.getParent() == null) continue;
            JSONObject markerObject = new JSONObject();
            String markerName = marker.getName();
            if (markerName != null) {
                markerObject.put("name", (Object)markerName);
            }
            if ((resourcePath = marker.getResourcePath()) != null && !"".equals(resourcePath)) {
                markerObject.put("resource", (Object)HyperlinkUtils.toAttachmentURL((String)resourcePath));
            }
            markerMapObject.put(markerId, (Object)markerObject);
            String groupId = group.getId();
            JSONObject groupObject = groupMapObject.optJSONObject(groupId);
            if (groupObject == null) {
                groupObject = new JSONObject();
                String groupName = group.getName();
                if (groupName != null) {
                    groupObject.put("name", (Object)groupName);
                }
                markerArray = new JSONArray();
                groupObject.put("markers", (Object)markerArray);
                groupMapObject.put(groupId, (Object)groupObject);
            } else {
                markerArray = groupObject.getJSONArray("markers");
            }
            markerArray.put((Object)markerId);
        }
        for (String markerId : legend.getMarkerIds()) {
            JSONObject markerObject = markerMapObject.optJSONObject(markerId);
            if (markerObject == null) {
                markerObject = new JSONObject();
                markerMapObject.put(markerId, (Object)markerObject);
            }
            markerObject.put("name", (Object)legend.getMarkerDescription(markerId));
        }
        if (markerMapObject.length() > 0) {
            legendObject.put("markers", (Object)markerMapObject);
        }
        if (groupMapObject.length() > 0) {
            legendObject.put("groups", (Object)groupMapObject);
        }
        if (legendObject.length() > 0) {
            sheetObject.put("legend", (Object)legendObject);
        }
        JSONObject settingsObject = new JSONObject();
        ISheetSettings settings = this.sheet.getSettings();
        for (String settingPath : settings.getPaths()) {
            JSONArray settingEntryArray = new JSONArray();
            for (ISettingEntry settingEntry : settings.getEntries(settingPath)) {
                JSONObject settingEntryObject = new JSONObject();
                for (String key : settingEntry.getAttributeKeys()) {
                    settingEntryObject.put(key, (Object)settingEntry.getAttribute(key));
                }
                if (settingEntryObject.length() <= 0) continue;
                settingEntryArray.put((Object)settingEntryObject);
            }
            if (settingEntryArray.length() <= 0) continue;
            settingsObject.put(settingPath, (Object)settingEntryArray);
        }
        if (settingsObject.length() > 0) {
            sheetObject.put("settings", (Object)settingsObject);
        }
        this.serializeStyle(sheetObject, this.sheet.getStyleId());
        this.serializeTheme(sheetObject, this.sheet.getThemeId());
        IManifest manifest = this.sheet.getOwnedWorkbook().getManifest();
        for (String entryPath : refManager.getRefsFor(this.sheet, "file-entry")) {
            this.saveResource(manifest, entryPath);
        }
        return sheetObject;
    }

    private void serializeTheme(JSONObject sheetObject, String themeId) {
        IStyleSheet styleSheet = this.sheet.getOwnedWorkbook().getStyleSheet();
        IStyle theme = styleSheet.findStyle(themeId);
        if (theme == null || !styleSheet.equals(theme.getOwnedStyleSheet())) {
            return;
        }
        JSONObject themeObject = new JSONObject();
        Iterator defaultStyleIds = theme.defaultStyles();
        while (defaultStyleIds.hasNext()) {
            Property p = (Property)defaultStyleIds.next();
            JSONObject styleObject = this.toStyleJSON(p.value);
            if (styleObject == null) continue;
            themeObject.put(p.key, (Object)styleObject);
        }
        if (themeObject.length() > 0) {
            sheetObject.put("theme", (Object)themeObject);
        }
    }

    private void serializeStyle(JSONObject sourceObject, String styleId) {
        JSONObject styleObject = this.toStyleJSON(styleId);
        if (styleObject != null) {
            sourceObject.put("style", (Object)styleObject);
        }
    }

    private JSONObject toStyleJSON(String styleId) {
        IStyleSheet styleSheet = this.sheet.getOwnedWorkbook().getStyleSheet();
        IStyle style = styleSheet.findStyle(styleId);
        if (style == null || !styleSheet.equals(style.getOwnedStyleSheet())) {
            return null;
        }
        JSONObject propertiesObject = new JSONObject();
        Iterator properties = style.properties();
        while (properties.hasNext()) {
            Property p = (Property)properties.next();
            propertiesObject.put(p.key, (Object)p.value);
        }
        if (propertiesObject.length() == 0) {
            return null;
        }
        return new JSONObject().put("type", (Object)style.getType()).put("properties", (Object)propertiesObject);
    }

    private void saveResource(IManifest manifest, String entryPath) throws IOException {
        if (!entryPath.startsWith("resources/")) {
            return;
        }
        IFileEntry entry = manifest.getFileEntry(entryPath);
        if (entry == null || entry.isDirectory()) {
            return;
        }
        PathInfo pathInfo = new PathInfo(entryPath);
        if (this.resourceStorage.getInputSource().hasEntry(pathInfo.hash)) {
            return;
        }
        if (!entry.canRead()) {
            return;
        }
        try (InputStream sourceStream = entry.openInputStream();
             OutputStream targetStream = this.resourceStorage.getOutputTarget().openEntryStream(pathInfo.hash);){
            FileUtils.transfer((InputStream)sourceStream, (OutputStream)targetStream, (boolean)false);
        }
    }

    private JSONObject toJSON(ITopic topic) {
        Set comments;
        JSONObject notesObject;
        JSONObject numberingObject;
        String hyperlink;
        Point position;
        String structureClass;
        int titleWidth;
        JSONObject topicObject = new JSONObject();
        topicObject.put("id", (Object)topic.getId());
        if (topic.hasTitle()) {
            topicObject.put("title", (Object)topic.getTitleText());
        }
        if ((titleWidth = topic.getTitleWidth()) != -1) {
            topicObject.put("width", titleWidth);
        }
        if (topic.isFolded()) {
            topicObject.put("branch", (Object)"folded");
        }
        if ((structureClass = topic.getStructureClass()) != null) {
            topicObject.put("structureClass", (Object)structureClass);
        }
        if ((position = topic.getPosition()) != null) {
            topicObject.put("position", (Object)new JSONObject().put("x", position.x).put("y", position.y));
        }
        if ((hyperlink = topic.getHyperlink()) != null) {
            topicObject.put("href", (Object)hyperlink);
        }
        if ((numberingObject = this.toJSON(topic.getNumbering())) != null && numberingObject.length() > 0) {
            topicObject.put("numbering", (Object)numberingObject);
        }
        if ((notesObject = this.toJSON(topic.getNotes())) != null && notesObject.length() > 0) {
            topicObject.put("notes", (Object)notesObject);
        }
        JSONArray labelArray = new JSONArray();
        for (String label : topic.getLabels()) {
            labelArray.put((Object)label);
        }
        if (labelArray.length() > 0) {
            topicObject.put("labels", (Object)labelArray);
        }
        JSONArray markerRefArray = new JSONArray();
        for (IMarkerRef markerRef : topic.getMarkerRefs()) {
            markerRefArray.put((Object)new JSONObject().put("markerId", (Object)markerRef.getMarkerId()));
        }
        if (markerRefArray.length() > 0) {
            topicObject.put("markers", (Object)markerRefArray);
        }
        this.serializeStyle(topicObject, topic.getStyleId());
        JSONObject imageObject = this.toJSON(topic.getImage());
        if (imageObject != null && imageObject.length() > 0) {
            topicObject.put("image", (Object)imageObject);
        }
        JSONObject childrenObject = new JSONObject();
        topicObject.put("children", (Object)childrenObject);
        for (String type : topic.getChildrenTypes()) {
            JSONArray topicArray = new JSONArray();
            childrenObject.put(type, (Object)topicArray);
            for (ITopic child : topic.getChildren(type)) {
                topicArray.put((Object)this.toJSON(child));
            }
        }
        JSONArray boundaryArray = new JSONArray();
        for (IBoundary boundary : topic.getBoundaries()) {
            String range;
            JSONObject boundaryObject = new JSONObject().put("id", (Object)boundary.getId());
            if (boundary.hasTitle()) {
                boundaryObject.put("title", (Object)boundary.getTitleText());
            }
            if ((range = Ranges.toRange(boundary)) != null) {
                boundaryObject.put("range", (Object)range);
            }
            this.serializeStyle(boundaryObject, boundary.getStyleId());
            boundaryArray.put((Object)boundaryObject);
        }
        if (boundaryArray.length() > 0) {
            topicObject.put("boundaries", (Object)boundaryArray);
        }
        JSONArray summaryArray = new JSONArray();
        for (ISummary summary : topic.getSummaries()) {
            String topicId;
            JSONObject summaryObject = new JSONObject().put("id", (Object)summary.getId());
            String range = Ranges.toRange(summary);
            if (range != null) {
                summaryObject.put("range", (Object)range);
            }
            if ((topicId = summary.getTopicId()) != null) {
                summaryObject.put("topicId", (Object)topicId);
            }
            this.serializeStyle(summaryObject, summary.getStyleId());
            summaryArray.put((Object)summaryObject);
        }
        if (summaryArray.length() > 0) {
            topicObject.put("summaries", (Object)summaryArray);
        }
        JSONArray extensionArray = new JSONArray();
        for (ITopicExtension ext : topic.getExtensions()) {
            JSONObject extObject = new JSONObject().put("provider", (Object)ext.getProviderName());
            this.serializeTopicExtensionElement(extObject, ext.getContent());
            JSONArray resourceRefArray = new JSONArray();
            for (IResourceRef ref : ext.getResourceRefs()) {
                if (!"file-entry".equals(ref.getType())) continue;
                resourceRefArray.put((Object)HyperlinkUtils.toAttachmentURL((String)ref.getResourceId()));
            }
            if (resourceRefArray.length() > 0) {
                extObject.put("resourceRefs", (Object)resourceRefArray);
            }
            extensionArray.put((Object)extObject);
        }
        if (extensionArray.length() > 0) {
            topicObject.put("extensions", (Object)extensionArray);
        }
        if (!(comments = topic.getOwnedWorkbook().getCommentManager().getComments(topic.getId())).isEmpty()) {
            JSONArray commentArray = new JSONArray();
            for (IComment comment : comments) {
                JSONObject commentObject = new JSONObject().put("author", (Object)comment.getAuthor()).put("creationTime", comment.getTime());
                String content = comment.getContent();
                if (content != null) {
                    commentObject.put("content", (Object)content);
                }
                commentArray.put((Object)commentObject);
            }
            topicObject.put("comments", (Object)commentArray);
        }
        return topicObject;
    }

    private JSONObject toJSON(INumbering numbering) {
        String separator;
        boolean prepending;
        String suffix;
        String depth = numbering.getDepth();
        String format = numbering.getNumberFormat();
        if (format == null && depth == null) {
            return null;
        }
        JSONObject numberingObject = new JSONObject();
        if (depth != null) {
            numberingObject.put("numberDepth", (Object)depth);
        }
        if (format == null) {
            return numberingObject;
        }
        numberingObject.put("numberFormat", (Object)format);
        String prefix = numbering.getPrefix();
        if (prefix != null) {
            numberingObject.put("prefix", (Object)prefix);
        }
        if ((suffix = numbering.getSuffix()) != null) {
            numberingObject.put("suffix", (Object)suffix);
        }
        if (!(prepending = numbering.prependsParentNumbers())) {
            numberingObject.put("prependingNumbers", (Object)"none");
        }
        if ((separator = numbering.getSeparator()) != null) {
            numberingObject.put("numberSeparator", (Object)separator);
        }
        return numberingObject;
    }

    private JSONObject toJSON(INotes notes) {
        INotesContent htmlContent;
        String textContent;
        if (notes.isEmpty()) {
            return null;
        }
        JSONObject notesObject = new JSONObject();
        INotesContent plainContent = notes.getContent("plain");
        if (plainContent instanceof IPlainNotesContent && (textContent = ((IPlainNotesContent)plainContent).getTextContent()) != null && !"".equals(textContent)) {
            notesObject.put("plain", (Object)new JSONObject().put("content", (Object)textContent));
        }
        if ((htmlContent = notes.getContent("html")) instanceof IHtmlNotesContent) {
            JSONObject contentObject = new JSONObject();
            JSONArray paragraphArray = new JSONArray();
            for (IParagraph paragraph : ((IHtmlNotesContent)htmlContent).getParagraphs()) {
                JSONObject paragraphObject = new JSONObject();
                this.serializeStyle(paragraphObject, paragraph.getStyleId());
                this.serializeSpans(paragraphObject, paragraph.getSpans());
                if (paragraphObject.length() <= 0) continue;
                paragraphArray.put((Object)paragraphObject);
            }
            if (paragraphArray.length() > 0) {
                contentObject.put("paragraphs", (Object)paragraphArray);
            }
            if (contentObject.length() > 0) {
                notesObject.put("html", (Object)new JSONObject().put("content", (Object)contentObject));
            }
        }
        return notesObject;
    }

    private void serializeSpans(JSONObject sourceObject, List<ISpan> spans) {
        JSONArray spanArray = new JSONArray();
        for (ISpan span : spans) {
            JSONObject spanObject = new JSONObject();
            this.serializeStyle(spanObject, span.getStyleId());
            if (span instanceof ITextSpan) {
                String text = ((ITextSpan)span).getTextContent();
                if (text != null) {
                    spanObject.put("text", (Object)text);
                }
            } else if (span instanceof IImageSpan) {
                String source = ((IImageSpan)span).getSource();
                if (source != null) {
                    spanObject.put("image", (Object)source);
                }
            } else if (span instanceof IHyperlinkSpan) {
                String href = ((IHyperlinkSpan)span).getHref();
                if (href != null) {
                    spanObject.put("href", (Object)href);
                }
                this.serializeSpans(spanObject, ((IHyperlinkSpan)span).getSpans());
            }
            if (spanObject.length() <= 0) continue;
            spanArray.put((Object)spanObject);
        }
        if (spanArray.length() > 0) {
            sourceObject.put("spans", (Object)spanArray);
        }
    }

    private void serializeTopicExtensionElement(JSONObject elementObject, ITopicExtensionElement element) {
        String textContent;
        JSONObject attrMapObject = new JSONObject();
        for (String attrKey : element.getAttributeKeys()) {
            attrMapObject.put(attrKey, (Object)element.getAttribute(attrKey));
        }
        if (attrMapObject.length() > 0) {
            elementObject.put("attrs", (Object)attrMapObject);
        }
        if ((textContent = element.getTextContent()) != null) {
            elementObject.put("content", (Object)textContent);
        } else {
            JSONArray childElementArray = new JSONArray();
            for (ITopicExtensionElement childElement : element.getChildren()) {
                JSONObject childElementObject = new JSONObject().put("name", (Object)childElement.getName());
                this.serializeTopicExtensionElement(childElementObject, childElement);
                childElementArray.put((Object)childElementObject);
            }
            if (childElementArray.length() > 0) {
                elementObject.put("content", (Object)childElementArray);
            }
        }
    }

    private JSONObject toJSON(IImage image) {
        int height;
        int width;
        String alignment;
        JSONObject imageObject = new JSONObject();
        String source = image.getSource();
        if (source != null) {
            imageObject.put("src", (Object)source);
        }
        if ((alignment = image.getAlignment()) != null) {
            imageObject.put("align", (Object)alignment);
        }
        if ((width = image.getWidth()) != -1) {
            imageObject.put("width", width);
        }
        if ((height = image.getHeight()) != -1) {
            imageObject.put("height", height);
        }
        return imageObject;
    }

    private JSONObject toJSON(IRelationship rel) {
        String end2Id;
        String end1Id;
        JSONObject relObject = new JSONObject();
        relObject.put("id", (Object)rel.getId());
        if (rel.hasTitle()) {
            relObject.put("title", (Object)rel.getTitleText());
        }
        if ((end1Id = rel.getEnd1Id()) != null) {
            relObject.put("end1Id", (Object)end1Id);
        }
        if ((end2Id = rel.getEnd2Id()) != null) {
            relObject.put("end2Id", (Object)end2Id);
        }
        JSONObject controlPointMap = new JSONObject();
        this.serializeControlPoint(rel, controlPointMap, 0);
        this.serializeControlPoint(rel, controlPointMap, 1);
        if (controlPointMap.length() > 0) {
            relObject.put("controlPoints", (Object)controlPointMap);
        }
        this.serializeStyle(relObject, rel.getStyleId());
        return relObject;
    }

    private void serializeControlPoint(IRelationship rel, JSONObject controlPointMap, int index) {
        IControlPoint controlPoint = rel.getControlPoint(index);
        Point position = controlPoint.getPosition();
        boolean hasAngle = controlPoint.hasPolarAngle();
        boolean hasAmount = controlPoint.hasPolarAmount();
        if (position == null && !hasAngle && !hasAmount) {
            return;
        }
        JSONObject controlPointObject = new JSONObject();
        if (position != null) {
            controlPointObject.put("x", position.x).put("y", position.y);
        }
        if (hasAngle) {
            controlPointObject.put("angle", controlPoint.getPolarAngle());
        }
        if (hasAmount) {
            controlPointObject.put("amount", controlPoint.getPolarAmount());
        }
        controlPointMap.put(String.valueOf(index), (Object)controlPointObject);
    }
}

