/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.IResourceRef;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.ResourceRef;
import org.xmind.core.plain.Workbook;
import org.xmind.core.plain.WorkbookExtensionElement;

public class WorkbookExtension
implements IWorkbookExtension {
    public static final String WorkbookExtensionResourceRefAdd = "workbookExtensionResourceRefAdd";
    public static final String WorkbookExtensionResourceRefRemove = "workbookExtensionResourceRefRemove";
    public static final String CONTENT_NAME = "content";
    private final Workbook ownedWorkbook;
    private final String providerName;
    private WorkbookExtensionElement content;
    private boolean orphan;
    private List<ResourceRef> resourceRefs;

    public WorkbookExtension(Workbook ownedWorkbook, String providerName) {
        this.ownedWorkbook = ownedWorkbook;
        this.providerName = providerName;
        this.content = new WorkbookExtensionElement(this, CONTENT_NAME);
        this.orphan = true;
        this.resourceRefs = new ArrayList<ResourceRef>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public IWorkbookExtensionElement getContent() {
        return this.content;
    }

    public List<IResourceRef> getResourceRefs() {
        return Collections.unmodifiableList(this.resourceRefs);
    }

    public IResourceRef getResourceRef(String resourceId) {
        if (resourceId != null && !"".equals(resourceId)) {
            for (IResourceRef ref : this.getResourceRefs()) {
                if (!resourceId.equals(ref.getResourceId())) continue;
                return ref;
            }
        }
        return null;
    }

    public void addResourceRef(IResourceRef ref) {
        if (ref == null || !(ref instanceof ResourceRef) || ref.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        ResourceRef r = (ResourceRef)ref;
        if (this.resourceRefs.add(r)) {
            if (!this.isOrphan()) {
                r.onParented();
            }
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this.ownedWorkbook, WorkbookExtensionResourceRefAdd, (Object)r);
        }
    }

    public void removeResourceRef(IResourceRef ref) {
        if (ref == null || !(ref instanceof ResourceRef) || ref.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        ResourceRef r = (ResourceRef)ref;
        if (this.resourceRefs.contains(r)) {
            if (!this.isOrphan()) {
                r.onOrphan();
            }
            this.resourceRefs.remove(r);
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this.ownedWorkbook, WorkbookExtensionResourceRefRemove, (Object)r);
        }
    }

    protected void onParented() {
        this.orphan = false;
        this.content.onParented();
        for (ResourceRef r : this.resourceRefs) {
            r.onParented();
        }
    }

    protected void onOrphan() {
        for (ResourceRef r : this.resourceRefs) {
            r.onOrphan();
        }
        this.content.onOrphan();
        this.orphan = true;
    }
}

