/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.service.BendPointsFeedback;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IRectangleProvider;
import org.xmind.gef.tool.ResizeTool;

public abstract class FeedbackResizeTool
extends ResizeTool {
    private IBendPointsFeedback feedback;
    private boolean newFeedback;
    private IRectangleProvider oldBoundsProvider;
    private IRectangleProvider newBoundsProvider;

    protected void updateArea(Rectangle area, Point cursorPosition, MouseDragEvent me) {
        if (this.feedback != null) {
            this.updateAreaBounds(area, cursorPosition);
            this.feedback.update();
        }
    }

    protected void start() {
        IFeedback feedback = this.getSourceFeedback();
        if (feedback instanceof IBendPointsFeedback) {
            this.feedback = (IBendPointsFeedback)feedback;
            this.newFeedback = false;
        } else {
            this.feedback = this.createBendPointFeedbackPart();
            this.newFeedback = true;
        }
        int orientation = this.feedback.getOrientation(this.getStartingPosition());
        this.setOrientation(orientation);
        if (orientation != 0) {
            this.initFeedback(this.feedback);
        } else {
            this.feedback = null;
        }
    }

    protected abstract IFeedback getSourceFeedback();

    protected void initFeedback(IBendPointsFeedback feedback) {
        IFeedbackService feedbackService;
        if (this.newFeedback && (feedbackService = (IFeedbackService)this.getTargetViewer().getService(IFeedbackService.class)) != null) {
            feedbackService.addFeedback((IFeedback)feedback);
        }
        this.oldBoundsProvider = feedback.getBoundsProvider();
        if (this.oldBoundsProvider != null) {
            this.setInitArea(this.oldBoundsProvider.getRectangle());
        } else {
            this.setInitArea(this.getSourceArea());
        }
        this.newBoundsProvider = new BoundsProvider();
        feedback.setBoundsProvider(this.newBoundsProvider);
        feedback.update();
    }

    protected abstract Rectangle getSourceArea();

    protected IBendPointsFeedback createBendPointFeedbackPart() {
        return new BendPointsFeedback();
    }

    protected void end() {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
        }
    }

    protected void removeFeedback(IBendPointsFeedback feedback) {
        feedback.setBoundsProvider(this.oldBoundsProvider);
        if (this.newFeedback) {
            IFeedbackService feedbackService = (IFeedbackService)this.getTargetViewer().getService(IFeedbackService.class);
            if (feedbackService != null) {
                feedbackService.removeFeedback((IFeedback)feedback);
            }
        } else {
            feedback.update();
        }
        feedback = null;
    }

    private class BoundsProvider
    implements IRectangleProvider {
        private BoundsProvider() {
        }

        public Rectangle getRectangle() {
            return FeedbackResizeTool.this.getResultArea();
        }
    }
}

