/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.MindMapEditorInputFactory;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapEditorInput
implements IEditorInput,
IPersistableElement {
    private URI uri;
    private IWorkbookRef workbookRef;

    public MindMapEditorInput(URI uri) {
        this(uri, MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(uri, null));
        Assert.isNotNull((Object)uri);
    }

    public MindMapEditorInput(IWorkbookRef workbookRef) {
        this(workbookRef.getURI(), workbookRef);
        Assert.isNotNull((Object)workbookRef);
    }

    private MindMapEditorInput(URI uri, IWorkbookRef workbookRef) {
        this.uri = uri;
        this.workbookRef = workbookRef;
    }

    public IWorkbookRef getWorkbookRef() {
        return this.workbookRef;
    }

    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.workbookRef != null) {
            return this.workbookRef.getURI();
        }
        throw new IllegalStateException("URI and workbookRef are both null");
    }

    public void dispose() {
        this.workbookRef = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        IWorkbookRef workbookRef;
        if (URI.class.equals(adapter)) {
            return adapter.cast(this.getURI());
        }
        if (IWorkbookRef.class.equals(adapter)) {
            return adapter.cast(this.getWorkbookRef());
        }
        if (IWorkbook.class.equals(adapter) && (workbookRef = this.getWorkbookRef()) != null) {
            return adapter.cast(workbookRef.getWorkbook());
        }
        return null;
    }

    public boolean exists() {
        IWorkbookRef wr = this.getWorkbookRef();
        if (wr != null) {
            return wr.exists();
        }
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return MindMapUI.getImages().get("icons/xmind_file.16.png");
    }

    public String getName() {
        IWorkbookRef wr = this.getWorkbookRef();
        if (wr != null) {
            String workbookName = wr.getName();
            if (workbookName == null) {
                return MindMapMessages.MindMapEditorInput_Workbook_Untitled_title;
            }
            return workbookName;
        }
        URI uri = this.getURI();
        if (uri != null) {
            String path = uri.getPath();
            if (path != null && path.length() > 0) {
                int sep;
                if (path.charAt(path.length() - 1) == '/') {
                    path = path.substring(0, path.length() - 1);
                }
                if ((sep = path.lastIndexOf(47)) >= 0) {
                    return path.substring(sep + 1);
                }
            }
            return path;
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        IWorkbookRef wr = this.getWorkbookRef();
        if (wr == null) {
            return null;
        }
        return this;
    }

    public String getFactoryId() {
        return "org.xmind.ui.MindMapEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        MindMapEditorInputFactory.saveState(this, memento);
    }

    public String getToolTipText() {
        IWorkbookRef wr = this.getWorkbookRef();
        if (wr != null) {
            return wr.getDescription();
        }
        URI uri = this.getURI();
        if (uri != null) {
            return uri.toString();
        }
        return "";
    }

    public int hashCode() {
        IWorkbookRef wr = this.getWorkbookRef();
        if (wr != null) {
            return wr.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MindMapEditorInput)) {
            return false;
        }
        MindMapEditorInput that = (MindMapEditorInput)obj;
        IWorkbookRef thisWR = this.workbookRef;
        IWorkbookRef thatWR = that.workbookRef;
        URI thisURI = this.uri;
        URI thatURI = that.uri;
        return (thisURI == thatURI || thisURI != null && thisURI.equals(thatURI)) && (thisWR == thatWR || thisWR != null && thisWR.equals(thatWR));
    }

    public String toString() {
        IWorkbookRef wr = this.getWorkbookRef();
        if (wr != null) {
            return wr.toString();
        }
        return super.toString();
    }
}

