/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ToggleModelPartHandler {
    private static final String TAG_EDITOR = "Editor";
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @Execute
    public void run(EPartService partService, @Optional @Named(value="org.xmind.ui.commandParameter.modelPart.partId") String partId, @Optional @Named(value="org.xmind.ui.commandParameter.modelPart.partStackId") String partStackId, @Optional MToolItem toolItemModel, MApplication appli, EModelService modelService) {
        if (partId == null) {
            if (partStackId == null) {
                partStackId = "org.xmind.ui.stack.right";
            }
            if ((partId = (String)appli.getContext().get("org.xmind.ui.modelPart.lastOpened")) == null) {
                partId = "org.xmind.ui.modelPart.properties";
            }
        }
        MPartDescriptor partDescriptor = null;
        for (MPartDescriptor mp : appli.getDescriptors()) {
            if (!partId.equals(mp.getElementId())) continue;
            partDescriptor = mp;
            break;
        }
        if (partDescriptor == null) {
            return;
        }
        List partStacks = modelService.findElements((MUIElement)appli, partStackId, MPartStack.class, null);
        boolean partStackExisted = !partStacks.isEmpty();
        MPartStack partStack = partStackExisted ? (MPartStack)partStacks.get(0) : this.createPartStack(modelService, partStackId);
        MPart p = partService.findPart(partId);
        if (p == null) {
            p = partService.createPart(partId);
            partStack.getChildren().add(p);
            partStack.setSelectedElement((MUIElement)p);
            p.setVisible(false);
        }
        if (!partStackExisted) {
            ((MWindow)appli.getChildren().get(0)).getChildren().add(p);
        }
        if (!p.isVisible()) {
            partStack.setVisible(true);
            p.setVisible(true);
            partService.activate(p, true);
        } else {
            p.setVisible(false);
            partService.hidePart(p);
        }
        appli.getContext().set("org.xmind.ui.modelPart.lastOpened", (Object)partId);
    }

    private MPartStack createPartStack(EModelService modelService, String partStackId) {
        MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        partStack.setElementId(partStackId);
        partStack.setVisible(true);
        return partStack;
    }

    @CanExecute
    public boolean canExecute() {
        List editors = this.modelService.findElements((MUIElement)this.application, null, MPart.class, Arrays.asList(TAG_EDITOR));
        return !editors.isEmpty();
    }
}

