/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.ArrayList;
import org.xmind.core.ISheet;
import org.xmind.gef.command.Command;

public class DuplicateSheetCommand
extends Command {
    private ISheet sheet;
    private ISheet clonedSheet;

    public DuplicateSheetCommand(ISheet sheet) {
        this.sheet = sheet;
    }

    public void redo() {
        if (this.clonedSheet == null) {
            this.cloneSheet();
        }
        this.sheet.getOwnedWorkbook().addSheet(this.clonedSheet, this.sheet.getIndex() + 1);
        super.redo();
    }

    public void undo() {
        this.clonedSheet.getOwnedWorkbook().removeSheet(this.clonedSheet);
        super.undo();
    }

    private void cloneSheet() {
        ArrayList<ISheet> sheetList = new ArrayList<ISheet>();
        sheetList.add(this.sheet);
        this.clonedSheet = (ISheet)this.sheet.getOwnedWorkbook().clone(sheetList).getCloneds().iterator().next();
        this.clonedSheet.setTitleText(String.valueOf(this.clonedSheet.getTitleText()) + " copy");
    }
}

