/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.opml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.imports.opml.OpmlConstants;
import org.xmind.ui.wizards.MindMapImporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpmlImporter
extends MindMapImporter
implements ErrorHandler,
OpmlConstants {
    private ISheet targetSheet;

    public OpmlImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromOpmlCount");
        InputStream in = null;
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this);
                in = new FileInputStream(this.getSourcePath());
                Document doc = builder.parse(in);
                this.checkInterrupted();
                Element rootElement = doc.getDocumentElement();
                this.loadSheet(rootElement);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.postBuilded();
    }

    private void loadSheet(Element rootElement) throws InterruptedException {
        Element headEle;
        this.checkInterrupted();
        IWorkbook targetWorkbook = this.getTargetWorkbook();
        this.targetSheet = targetWorkbook.createSheet();
        Element bodyEle = OpmlImporter.child(rootElement, "body");
        if (bodyEle != null) {
            this.loadContents(bodyEle);
        }
        if ((headEle = OpmlImporter.child(rootElement, "head")) != null) {
            this.loadSheetProperties(headEle);
        }
        this.addTargetSheet(this.targetSheet);
    }

    private void loadContents(Element bodyEle) throws InterruptedException {
        this.checkInterrupted();
        Element rootTopicEle = OpmlImporter.child(bodyEle, "outline");
        if (rootTopicEle != null) {
            ITopic rootTopic = this.targetSheet.getRootTopic();
            this.loadTopicContent(rootTopicEle, rootTopic);
        }
        Iterator<Element> children = OpmlImporter.children(bodyEle, "outline");
        while (children.hasNext()) {
            Element next = children.next();
            if (next == rootTopicEle) continue;
            this.loadFloatingTopic(next, this.targetSheet.getRootTopic());
        }
    }

    private void loadTopicContent(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        topic.setTitleText(OpmlImporter.attr(topicEle, "text"));
        if ("link".equals(OpmlImporter.attr(topicEle, "type"))) {
            this.loadHyperlink(topicEle, topic);
        }
        Iterator<Element> children = OpmlImporter.children(topicEle, "outline");
        while (children.hasNext()) {
            Element next = children.next();
            String type = OpmlImporter.attr(next, "type");
            if ("note".equals(type)) {
                this.loadNotes(next, topic);
                continue;
            }
            this.loadSubTopic(next, topic);
        }
    }

    private void loadHyperlink(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        String link = OpmlImporter.attr(topicEle, "url");
        if (link != null && OpmlImporter.isLinkToWeb(link)) {
            String hyperlink = link;
            if (!hyperlink.startsWith("http://") && !hyperlink.startsWith("https://")) {
                hyperlink = "http://" + hyperlink;
            }
            topic.setHyperlink(link);
        }
    }

    private void loadNotes(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        String text = OpmlImporter.attr(topicEle, "text");
        if (text != null && !text.trim().equals("")) {
            IPlainNotesContent notesContent = (IPlainNotesContent)this.getTargetWorkbook().createNotesContent("plain");
            notesContent.setTextContent(text);
            topic.getNotes().setContent("plain", (INotesContent)notesContent);
        }
    }

    private void loadSubTopic(Element topicEle, ITopic parent) throws InterruptedException {
        this.checkInterrupted();
        ITopic subTopic = this.getTargetWorkbook().createTopic();
        parent.add(subTopic, "attached");
        this.loadTopicContent(topicEle, subTopic);
    }

    private void loadFloatingTopic(Element floatingTopicEle, ITopic parent) throws InterruptedException {
        this.checkInterrupted();
        ITopic subTopic = this.getTargetWorkbook().createTopic();
        parent.add(subTopic, "detached");
        this.loadTopicContent(floatingTopicEle, subTopic);
    }

    private void loadSheetProperties(Element headEle) throws InterruptedException {
        this.checkInterrupted();
        Element titleEle = OpmlImporter.child(headEle, "title");
        if (titleEle != null) {
            this.targetSheet.setTitleText(titleEle.getTextContent());
        } else {
            this.targetSheet.setTitleText(this.getSuggestedSheetTitle());
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static Element child(Element parentEle, String childTag) {
        return OpmlImporter.children(parentEle, childTag).next();
    }

    private static Iterator<Element> children(Element parentEle, String childTag) {
        return new Iterator<Element>(childTag, parentEle){
            String tag;
            Iterator<Element> it;
            Element next;
            {
                this.tag = DOMUtils.getLocalName((String)string);
                this.it = DOMUtils.childElementIter((Node)element);
                this.next = this.findNext();
            }

            @Override
            public void remove() {
            }

            private Element findNext() {
                while (this.it.hasNext()) {
                    Element ele = this.it.next();
                    if (!DOMUtils.getLocalName((String)ele.getTagName()).equalsIgnoreCase(this.tag)) continue;
                    return ele;
                }
                return null;
            }

            @Override
            public Element next() {
                Element result = this.next;
                this.next = this.findNext();
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    private static String attr(Element ele, String attName) {
        if (ele == null || attName == null) {
            return null;
        }
        if (ele.hasAttribute(attName)) {
            return ele.getAttribute(attName);
        }
        attName = DOMUtils.getLocalName((String)attName);
        NamedNodeMap atts = ele.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node att = atts.item(i);
            if (attName.equalsIgnoreCase(DOMUtils.getLocalName((String)att.getNodeName()))) {
                return att.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private static boolean isLinkToWeb(String urlOrBookmark) {
        return urlOrBookmark.contains("www.") || urlOrBookmark.contains(".com") || urlOrBookmark.contains(".cn") || urlOrBookmark.contains(".org") || urlOrBookmark.contains(".cc") || urlOrBookmark.contains(".net");
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }
}

