/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.Calendar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.datepicker.DatePicker;
import org.xmind.ui.datepicker.DateSelection;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;

public class DateInfoPickerViewer
extends Viewer {
    private Composite composite;
    private DatePicker datePicker;
    private DateInfo selection;
    private IAction removeAction;
    private Color validColor;
    private Color invalidColor;
    private boolean firingSelectionChange = false;
    private boolean refreshingDate = false;

    public DateInfoPickerViewer(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setBackground(parent.getBackground());
        this.createContents(this.composite);
        this.refresh();
    }

    private void createContents(Composite parent) {
        this.createDatePicker(parent);
        this.createToolBar(parent);
    }

    private void createDatePicker(Composite parent) {
        this.datePicker = new DatePicker(parent, 12);
        this.datePicker.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.datePicker.setBackground(parent.getBackground());
        this.datePicker.setLabelProvider((ILabelProvider)new DateLabelProvider());
        this.datePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DateInfoPickerViewer.this.refreshingDate) {
                    return;
                }
                DateInfoPickerViewer.this.changeDate(((DateSelection)event.getSelection()).getDate());
            }
        });
        this.datePicker.getControl().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 127 || event.keyCode == 8) {
                    DateInfoPickerViewer.this.changeDate(null);
                }
            }
        });
    }

    private void createToolBar(Composite parent) {
        this.removeAction = new RemoveAction();
        this.createToolBar(parent, this.removeAction);
    }

    private ToolBarManager createToolBar(Composite parent, IAction ... actions) {
        ToolBarManager manager = new ToolBarManager(0x800000);
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            manager.add(action);
            ++n2;
        }
        manager.createControl(parent);
        manager.getControl().setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        manager.getControl().setBackground(parent.getBackground());
        return manager;
    }

    public Control getControl() {
        return this.composite;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return this.selection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.selection);
    }

    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public void refresh() {
        boolean hasDate = this.selection != null;
        this.composite.setRedraw(false);
        this.refreshDatePicker(hasDate);
        this.composite.layout();
        this.composite.setRedraw(true);
    }

    private void refreshDatePicker(boolean hasDate) {
        this.refreshingDate = true;
        this.datePicker.setSelection((ISelection)new DateSelection(hasDate ? this.selection.date : null));
        this.datePicker.getPlaceholder().setTextForeground(hasDate ? this.validColor : this.invalidColor);
        this.refreshingDate = false;
    }

    public void setInput(Object input) {
    }

    public void setDate(DateInfo date) {
        this.selection = date;
        this.setSelection((ISelection)(this.selection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.selection)));
        this.datePicker.setSelection((ISelection)new DateSelection(this.selection != null ? this.selection.date : null));
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection == null || selection.isEmpty()) {
            this.changeSelection(null);
        } else if (selection instanceof IStructuredSelection) {
            this.changeSelection((DateInfo)((IStructuredSelection)selection).getFirstElement());
        }
    }

    private void changeSelection(DateInfo selection) {
        this.selection = selection;
        if (this.firingSelectionChange) {
            return;
        }
        this.firingSelectionChange = true;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        this.firingSelectionChange = false;
    }

    private void changeDate(Calendar date) {
        DateInfo dateInfo;
        if (date == null) {
            return;
        }
        boolean allDay = date.get(11) == 0 && date.get(12) == 0;
        DateInfo dateInfo2 = dateInfo = date == null ? null : new DateInfo(date, allDay);
        if (dateInfo != null && this.selection != null) {
            dateInfo.setTime(this.selection.date);
        }
        this.changeSelection(dateInfo);
    }

    public void setValidColor(Color color) {
        this.validColor = color;
    }

    public void setInvalidColor(Color color) {
        this.invalidColor = color;
    }

    public void setEnabled(boolean enabled) {
        this.datePicker.getPlaceholder().setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
    }

    public void openDatePicker() {
        this.datePicker.open();
    }

    private static class DateLabelProvider
    extends LabelProvider {
        private DateLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null || !(element instanceof Calendar)) {
                return TaskMessages.SelectTime_text;
            }
            return TaskInfoUtils.formatDate((Calendar)((Calendar)element));
        }
    }

    private class RemoveAction
    extends Action {
        public RemoveAction() {
            super(TaskMessages.RemoveDateInfoAction_text, TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/remove.png"));
            this.setToolTipText(TaskMessages.RemoveDateInfoAction_toolTip);
        }

        public void run() {
            DateInfoPickerViewer.this.changeSelection(null);
        }
    }
}

