/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.core.ISheet;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.TopicContextService;
import org.xmind.ui.util.MindMapUtils;

public class BrainstormTopicContextService
extends TopicContextService
implements ISelectionProvider {
    private IGraphicalEditor sourceEditor;

    public BrainstormTopicContextService(IViewer viewer, IGraphicalEditor sourceEditor) {
        super(viewer);
        this.sourceEditor = sourceEditor;
    }

    public Object getAdapter(Class adapter) {
        if (this.sourceEditor != null && adapter == ISelectionProvider.class) {
            return this;
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        if (this.sourceEditor != null) {
            return this.getViewer().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
        if (this.sourceEditor != null) {
            ISheet pageInput = this.findSheet(selection);
            IGraphicalEditorPage targetPage = this.findPage(pageInput);
            targetPage.getViewer().setSelection(selection);
            if (targetPage != null && targetPage != this.sourceEditor.getActivePageInstance()) {
                this.sourceEditor.setActivePage(targetPage.getIndex());
            }
            this.getViewer().setSelection(selection, true);
        }
    }

    private IGraphicalEditorPage findPage(Object input) {
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.sourceEditor.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            Object pageInput = page.getInput();
            if (pageInput == input || input != null && input.equals(pageInput)) {
                return page;
            }
            ++n2;
        }
        return null;
    }

    private ISheet findSheet(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ISheet sheet = MindMapUtils.findSheet((Object)o);
                if (sheet != null) {
                    return sheet;
                }
                ++n2;
            }
        }
        return null;
    }
}

