/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MonitoredInputStream
extends InputStream {
    private InputStream realStream;
    private IProgressMonitor monitor;

    public MonitoredInputStream(InputStream realStream, IProgressMonitor monitor) {
        this.realStream = realStream;
        this.monitor = monitor;
    }

    private void closeRealStream() {
        try {
            this.realStream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public int read() throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        return this.realStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.realStream.available();
    }

    @Override
    public void close() throws IOException {
        this.realStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.realStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.realStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        return this.realStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        return this.realStream.read(b);
    }

    @Override
    public void reset() throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        this.realStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        return this.realStream.skip(n);
    }
}

