/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.cathy.internal.WorkbenchMessages;

public class AbstractCheckFilesProcess {
    private final IWorkbench workbench;
    private List<IEditorInput> editorsToOpen;

    public AbstractCheckFilesProcess(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected void addEditorToOpen(IEditorInput input) {
        if (this.editorsToOpen == null) {
            this.editorsToOpen = new ArrayList<IEditorInput>();
        }
        this.editorsToOpen.add(input);
    }

    protected void openEditors(boolean activate) {
        if (this.editorsToOpen != null && !this.editorsToOpen.isEmpty()) {
            this.openEditors(this.editorsToOpen, activate);
        }
    }

    protected void openEditors(List<IEditorInput> editorInputs, boolean activate) {
        for (IEditorInput input : editorInputs) {
            IEditorPart editor = this.openEditor(input, activate);
            if (editor == null) continue;
            activate = false;
        }
    }

    protected IEditorPart openEditor(final IEditorInput input, final boolean activate) {
        if (input == null) {
            return null;
        }
        Display display = this.workbench.getDisplay();
        if (display == null) {
            return null;
        }
        final IEditorPart[] result = new IEditorPart[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = AbstractCheckFilesProcess.this.getPrimaryWindow();
                if (window == null) {
                    return;
                }
                final IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)WorkbenchMessages.CheckOpenFilesJob_FailsToOpen_message, (Object)input.getName())){

                        public void run() throws Exception {
                            result[0] = page.openEditor(input, "org.xmind.ui.MindMapEditor", activate);
                        }
                    });
                }
            }
        });
        return result[0];
    }

    private IWorkbenchWindow getPrimaryWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window == null && (windows = this.workbench.getWorkbenchWindows()) != null && windows.length > 0) {
            window = windows[0];
        }
        return window;
    }
}

