/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ICommandHandler;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.binary.BinaryStore;
import org.xmind.core.command.binary.IBinaryEntry;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.sharing.ISharedMap;

public class FileContentCommandHandler
implements ICommandHandler {
    public IStatus execute(IProgressMonitor monitor, ICommand command, String[] matches) {
        if (command.getArgument("contact-id") == null) {
            return new Status(2, "org.xmind.core.sharing", 400, "Missing contact ID.", null);
        }
        if (matches.length < 1) {
            return new Status(2, "org.xmind.core.sharing", 400, "Missing map ID.", null);
        }
        String resourceID = matches[0];
        final ISharedMap map = LocalNetworkSharing.getDefault().getSharingService().getLocalLibrary().findMapByID(resourceID);
        if (map == null) {
            return new Status(8, "org.xmind.core.sharing", 404, "Shared map is not found.", null);
        }
        final InputStream stream = map.getResourceAsStream(monitor);
        if (stream == null) {
            return new Status(8, "org.xmind.core.sharing", 404, "Shared map is missing.", null);
        }
        BinaryStore files = new BinaryStore();
        files.addEntry("content", new IBinaryEntry(){

            public InputStream openInputStream() throws IOException {
                return stream;
            }

            public void dispose() {
            }

            public String toString() {
                return "MapContent@" + map.getResourceName();
            }
        });
        monitor.done();
        return new ReturnValue("org.xmind.core.sharing", (IBinaryStore)files);
    }
}

