/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;

public abstract class AbstractHandle
implements Handle,
FigureListener {
    private final Figure owner;
    protected DrawingView view;
    private String toolTipText;
    protected EventListenerList listenerList = new EventListenerList();
    private Rectangle bounds;

    public AbstractHandle(Figure owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        this.owner = owner;
        owner.addFigureListener(this);
    }

    protected int getHandlesize() {
        return this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_SIZE);
    }

    @Override
    public void addHandleListener(HandleListener l) {
        this.listenerList.add(HandleListener.class, l);
    }

    @Override
    public void removeHandleListener(HandleListener l) {
        this.listenerList.remove(HandleListener.class, l);
    }

    @Override
    public Figure getOwner() {
        return this.owner;
    }

    @Override
    public void setView(DrawingView view) {
        this.view = view;
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.view.getEditor();
    }

    protected void fireAreaInvalidated(Rectangle invalidatedArea) {
        HandleEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HandleListener.class) continue;
            if (event == null) {
                event = new HandleEvent(this, invalidatedArea);
            }
            ((HandleListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.view.getDrawing().fireUndoableEditHappened(edit);
    }

    protected void fireHandleRequestRemove(Rectangle invalidatedArea) {
        HandleEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HandleListener.class) continue;
            if (event == null) {
                event = new HandleEvent(this, invalidatedArea);
            }
            ((HandleListener)listeners[i + 1]).handleRequestRemove(event);
        }
    }

    protected void fireHandleRequestSecondaryHandles() {
        HandleEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HandleListener.class) continue;
            if (event == null) {
                event = new HandleEvent(this, null);
            }
            ((HandleListener)listeners[i + 1]).handleRequestSecondaryHandles(event);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_STROKE_COLOR));
    }

    protected void drawCircle(Graphics2D g, Color fill, Color stroke) {
        Rectangle r = this.getBounds();
        if (fill != null) {
            g.setColor(fill);
            g.fillOval(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        }
        if (stroke != null) {
            g.setStroke(new BasicStroke());
            g.setColor(stroke);
            g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
            if (this.getView().getActiveHandle() == this) {
                g.fillOval(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
            }
        }
    }

    protected void drawRectangle(Graphics2D g, Color fill, Color stroke) {
        Rectangle r;
        if (fill != null) {
            r = this.getBounds();
            g.setColor(fill);
            ++r.x;
            ++r.y;
            r.width -= 2;
            r.height -= 2;
            g.fill(r);
        }
        g.setStroke(new BasicStroke());
        if (stroke != null) {
            r = this.getBounds();
            --r.width;
            --r.height;
            g.setColor(stroke);
            g.draw(r);
            if (this.getView().getActiveHandle() == this) {
                r.x += 2;
                r.y += 2;
                r.width -= 3;
                r.height -= 3;
                g.fill(r);
            }
        }
    }

    protected void drawDiamond(Graphics2D g, Color fill, Color stroke) {
        GeneralPath p;
        Rectangle r;
        if (stroke != null) {
            r = this.getBounds();
            r.grow(1, 1);
            p = new GeneralPath();
            p.moveTo((float)r.x + (float)r.width / 2.0f, r.y);
            p.lineTo(r.x + r.width, (float)r.y + (float)r.height / 2.0f);
            p.lineTo((float)r.x + (float)r.width / 2.0f, r.y + r.height);
            p.lineTo(r.x, (float)r.y + (float)r.height / 2.0f);
            p.closePath();
            g.setColor(stroke);
            g.fill(p);
        }
        if (fill != null) {
            r = this.getBounds();
            p = new GeneralPath();
            p.moveTo((float)r.x + (float)r.width / 2.0f, r.y);
            p.lineTo(r.x + r.width, (float)r.y + (float)r.height / 2.0f);
            p.lineTo((float)r.x + (float)r.width / 2.0f, r.y + r.height);
            p.lineTo(r.x, (float)r.y + (float)r.height / 2.0f);
            p.closePath();
            g.setColor(fill);
            g.fill(p);
        }
        if (stroke != null && this.getView().getActiveHandle() == this) {
            r = this.getBounds();
            r.grow(-1, -1);
            p = new GeneralPath();
            p.moveTo((float)r.x + (float)r.width / 2.0f, r.y);
            p.lineTo(r.x + r.width, (float)r.y + (float)r.height / 2.0f);
            p.lineTo((float)r.x + (float)r.width / 2.0f, r.y + r.height);
            p.lineTo(r.x, (float)r.y + (float)r.height / 2.0f);
            p.closePath();
            g.setColor(stroke);
            g.fill(p);
        }
    }

    @Override
    public boolean contains(Point p) {
        return this.getBounds().contains(p);
    }

    @Override
    public void invalidate() {
        this.bounds = null;
    }

    @Override
    public void dispose() {
        this.owner.removeFigureListener(this);
    }

    @Override
    public void areaInvalidated(FigureEvent evt) {
        this.updateBounds();
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent evt) {
        this.updateBounds();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return this.getClass().isAssignableFrom(handle.getClass());
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public final Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.basicGetBounds();
        }
        return (Rectangle)this.bounds.clone();
    }

    @Override
    public Rectangle getDrawingArea() {
        Rectangle r = this.getBounds();
        r.grow(2, 2);
        return r;
    }

    protected abstract Rectangle basicGetBounds();

    protected void updateBounds() {
        Rectangle newBounds = this.basicGetBounds();
        if (this.bounds == null || !newBounds.equals(this.bounds)) {
            if (this.bounds != null) {
                this.fireAreaInvalidated(this.getDrawingArea());
            }
            this.bounds = newBounds;
            this.fireAreaInvalidated(this.getDrawingArea());
        }
    }

    @Override
    public void trackDoubleClick(Point p, int modifiersEx) {
    }

    @Override
    public void attributeChanged(FigureEvent e) {
    }

    @Override
    public void viewTransformChanged() {
        this.invalidate();
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        return Collections.emptyList();
    }

    @Override
    public String getToolTipText(Point p) {
        return this.toolTipText;
    }

    public void setToolTipText(String newValue) {
        this.toolTipText = newValue;
    }

    @Override
    public void figureHandlesChanged(FigureEvent e) {
    }
}

