/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.util.Map;
import javafx.animation.PauseTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.util.Duration;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.api.OrderManager;

public class PendingOrder {
    private final String orderID;
    private final SimpleObjectProperty symbolObj;
    private final SimpleStringProperty name;
    private final SimpleStringProperty type;
    private final SimpleStringProperty side;
    private final SimpleStringProperty orderStatus;
    private final SimpleDoubleProperty orderQty;
    private final SimpleDoubleProperty cumQty;
    private final SimpleDoubleProperty orderCashAmt;
    private final SimpleDoubleProperty marketPrice;
    private final SimpleDoubleProperty orderPrice;
    public final Diff diff = new Diff();
    private PauseTransition cumQtyAgingTime = null;
    private PauseTransition orderStatusAgingTime = null;
    private PauseTransition marketPriceAgingTime = null;

    public PendingOrder(Map<String, Object> ord) {
        this.orderID = ord.get("orderID").toString();
        this.name = new SimpleStringProperty(ord.get("name").toString());
        OrderManager.OrderType ordType = (OrderManager.OrderType)((Object)ord.get("orderType"));
        Double ordPrice = null;
        switch (ordType) {
            case LIMIT: {
                ordPrice = (Double)ord.get("limitPrice");
                break;
            }
            case STOP: {
                ordPrice = (Double)ord.get("stopPrice");
                break;
            }
            case MARKET: {
                ordPrice = 0.0;
                break;
            }
        }
        this.type = new SimpleStringProperty(ordType.toString());
        OrderManager.OrderSide ordSide = (OrderManager.OrderSide)((Object)ord.get("side"));
        this.side = new SimpleStringProperty(ordSide.toString());
        this.orderQty = new SimpleDoubleProperty(((Double)ord.get("orderQty")).doubleValue());
        this.cumQty = new SimpleDoubleProperty(((Double)ord.get("cumQty")).doubleValue());
        this.orderCashAmt = new SimpleDoubleProperty(((Double)ord.get("orderCashAmt")).doubleValue());
        OrderManager.OrdStatus ordStatus = (OrderManager.OrdStatus)((Object)ord.get("orderStatus"));
        this.orderStatus = new SimpleStringProperty(ordStatus.toString());
        this.marketPrice = new SimpleDoubleProperty(((Double)ord.get("marketPrice")).doubleValue());
        this.orderPrice = new SimpleDoubleProperty(ordPrice.doubleValue());
        String symbolStr = ord.get("symbol").toString();
        String urlStr = ord.get("urlImage").toString();
        this.symbolObj = new SimpleObjectProperty();
        this.symbolObj.set((Object)new OpenPosition.SymbolUrl(symbolStr, urlStr));
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setSymbolObj(OpenPosition.SymbolUrl sym) {
        this.symbolObj.set((Object)sym);
    }

    public Object getSymbolObj() {
        return this.symbolObj.get();
    }

    public SimpleObjectProperty symbolObjProperty() {
        return this.symbolObj;
    }

    public final String getSymbol() {
        OpenPosition.SymbolUrl symbolUrl = (OpenPosition.SymbolUrl)this.symbolObj.get();
        return symbolUrl.getSymbol();
    }

    public final void setUrlImage(String v) {
        OpenPosition.SymbolUrl symbolUrl = new OpenPosition.SymbolUrl(this.getSymbol(), v);
        this.symbolObj.set((Object)symbolUrl);
    }

    public final String getUrlImage() {
        OpenPosition.SymbolUrl symbolUrl = (OpenPosition.SymbolUrl)this.symbolObj.get();
        return symbolUrl.getUrl();
    }

    public final String getName() {
        return this.name.get();
    }

    public final void setName(String v) {
        this.name.set(v);
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public final String getType() {
        return this.type.get();
    }

    public final void setType(String v) {
        this.type.set(v);
    }

    public SimpleStringProperty typeProperty() {
        return this.type;
    }

    public final String getOrderStatus() {
        return this.orderStatus.get();
    }

    public final void setOrderStatus(String v) {
        this.orderStatus.set(v);
    }

    public SimpleStringProperty orderStatusProperty() {
        return this.orderStatus;
    }

    public final String getSide() {
        return this.side.get();
    }

    public final void setSide(String v) {
        this.side.set(v);
    }

    public SimpleStringProperty sideProperty() {
        return this.side;
    }

    public final Double getOrderQty() {
        return this.orderQty.get();
    }

    public final void setOrderQty(Double v) {
        this.orderQty.set(v.doubleValue());
    }

    public SimpleDoubleProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final Double getCumQty() {
        return this.cumQty.get();
    }

    public final void setCumQty(Double v) {
        this.cumQty.set(v.doubleValue());
    }

    public SimpleDoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final Double getOrderCashAmt() {
        return this.orderCashAmt.get();
    }

    public final void setOrderCashAmt(Double v) {
        this.orderCashAmt.set(v.doubleValue());
    }

    public SimpleDoubleProperty orderCashAmtProperty() {
        return this.orderCashAmt;
    }

    public final Double getMarketPrice() {
        return this.marketPrice.get();
    }

    public final void setMarketPrice(Double v) {
        this.marketPrice.set(v.doubleValue());
    }

    public SimpleDoubleProperty marketPriceProperty() {
        return this.marketPrice;
    }

    public final Double getOrderPrice() {
        return this.orderPrice.get();
    }

    public final void setOrderPrice(Double v) {
        this.orderPrice.set(v.doubleValue());
    }

    public SimpleDoubleProperty orderPriceProperty() {
        return this.orderPrice;
    }

    private void setDiff(Double oldVal, Double newVal, IntegerProperty diffPty, PauseTransition agingTime) {
        int diffVal = Double.compare(newVal, oldVal);
        diffPty.set(diffVal);
        if (agingTime != null) {
            agingTime.playFromStart();
            return;
        }
        agingTime = new PauseTransition(Duration.seconds((double)5.0));
        agingTime.setOnFinished(event -> diffPty.set(0));
        agingTime.play();
    }

    public void compareAndUpdate(PendingOrder newOrd) {
        if (!this.getOrderID().equals(newOrd.getOrderID())) {
            return;
        }
        this.setOrderQty(newOrd.getOrderQty());
        Double newCumQty = newOrd.getCumQty();
        this.setDiff(this.getCumQty(), newCumQty, this.diff.cumQtyPty, this.cumQtyAgingTime);
        this.setCumQty(newCumQty);
        this.setOrderCashAmt(newOrd.getOrderCashAmt());
        this.setOrderPrice(newOrd.getOrderPrice());
        String newOrdStatus = newOrd.getOrderStatus();
        if (!newOrdStatus.equals(this.getOrderStatus())) {
            this.diff.orderStatusPty.set(true);
            if (this.orderStatusAgingTime == null) {
                this.orderStatusAgingTime = new PauseTransition(Duration.seconds((double)5.0));
                this.orderStatusAgingTime.setOnFinished(event -> this.diff.orderStatusPty.set(false));
                this.orderStatusAgingTime.play();
            } else {
                this.orderStatusAgingTime.playFromStart();
            }
        }
        this.setOrderStatus(newOrdStatus);
    }

    public void updatePrice(Double price) {
        if (Double.compare(this.getMarketPrice(), 0.0) != 0) {
            this.setDiff(this.getMarketPrice(), price, this.diff.marketPricePty, this.marketPriceAgingTime);
        }
        this.setMarketPrice(price);
    }

    public static class Diff {
        public IntegerProperty cumQtyPty = new SimpleIntegerProperty(0);
        public IntegerProperty marketPricePty = new SimpleIntegerProperty(0);
        public BooleanProperty orderStatusPty = new SimpleBooleanProperty(false);
    }
}

