/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.engine.AjaxDWUsernameAvailabilityMonitor;

public class UsernameField {
    public final TextField txtField = new TextField();
    public final StackPane stackNote = new StackPane();
    public final Label noteLabel = new Label(DriveWealthBundle.getString("Username_for_login"));
    public final Label statusLabel = new Label();
    public final VBox piBox = new VBox();
    public final ProgressIndicator pi = new ProgressIndicator();
    public BooleanProperty validProperty = new SimpleBooleanProperty();
    private final AjaxDWUsernameAvailabilityMonitor ajaxDWUsernameAvailabilityMonitor = new AjaxDWUsernameAvailabilityMonitor();

    public UsernameField() {
        this.pi.setPrefHeight(20.0);
        this.pi.setMaxHeight(20.0);
        this.piBox.setMaxWidth(20.0);
        this.piBox.setMaxHeight(20.0);
        this.piBox.getChildren().add((Object)this.pi);
        this.noteLabel.getStyleClass().add((Object)"note-small");
        this.stackNote.setAlignment(Pos.CENTER_LEFT);
        this.stackNote.getChildren().addAll((Object[])new Node[]{this.noteLabel, this.piBox, this.statusLabel});
        this.showNote();
        this.ajaxDWUsernameAvailabilityMonitor.attach(this.getDWUsernameAvailabilityMonitorObserver());
        this.txtField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldVal, String newVal) {
                if (newVal != null && !newVal.isEmpty()) {
                    UsernameField.this.ajaxDWUsernameAvailabilityMonitor.clearAndPut(newVal);
                    UsernameField.this.showBusy();
                }
            }
        });
    }

    public final void showNote() {
        this.noteLabel.setVisible(true);
        this.statusLabel.setVisible(false);
        this.piBox.setVisible(false);
        this.validProperty.set(true);
    }

    public void showBusy() {
        this.piBox.setVisible(true);
        this.noteLabel.setVisible(false);
        this.statusLabel.setVisible(false);
        this.validProperty.set(true);
    }

    public void showAvailability(String username, Boolean avail) {
        String status = avail != false ? MessageFormat.format(DriveWealthBundle.getString("Username_available"), username) : MessageFormat.format(DriveWealthBundle.getString("Username_not_available"), username);
        this.showStatus(status, avail == false);
        this.validProperty.set(avail.booleanValue());
    }

    public void showStatus(String status, Boolean isError) {
        Platform.runLater(() -> {
            this.piBox.setVisible(false);
            this.noteLabel.setVisible(false);
            this.statusLabel.setText(status);
            this.statusLabel.getStyleClass().clear();
            String style = isError != false ? "red-txt" : "green-txt";
            this.statusLabel.getStyleClass().addAll((Object[])new String[]{"note-small", style});
            this.statusLabel.setVisible(true);
        });
    }

    private Observer<AjaxDWUsernameAvailabilityMonitor, Pair<String, Boolean>> getDWUsernameAvailabilityMonitorObserver() {
        return new Observer<AjaxDWUsernameAvailabilityMonitor, Pair<String, Boolean>>(){

            @Override
            public void update(AjaxDWUsernameAvailabilityMonitor subject, Pair<String, Boolean> arg) {
                String query = (String)arg.first;
                Boolean avail = (Boolean)arg.second;
                String string = UsernameField.this.txtField.getText().trim();
                if (string.isEmpty() || avail == null) {
                    UsernameField.this.showNote();
                    return;
                }
                if (!string.equals(query)) {
                    return;
                }
                UsernameField.this.showAvailability(query, avail);
            }
        };
    }

    public void stop() {
        this.ajaxDWUsernameAvailabilityMonitor.stop();
    }
}

