/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.google.api.client.auth.oauth2.Credential;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.yccheok.jstock.alert.GoogleMail;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.DispType;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.GoogleCodeDatabaseRunnable;
import org.yccheok.jstock.engine.IEXStockInfoDatabaseRunnable;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Market;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.PriceSource;
import org.yccheok.jstock.engine.RealTimeIndexMonitor;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryMonitor;
import org.yccheok.jstock.engine.StockHistorySerializer;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Atom;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.file.ThreadSafeFileLock;
import org.yccheok.jstock.file.UserDataDirectory;
import org.yccheok.jstock.file.UserDataFile;
import org.yccheok.jstock.gui.AboutJDialog;
import org.yccheok.jstock.gui.AlertStateManager;
import org.yccheok.jstock.gui.AppLock;
import org.yccheok.jstock.gui.AutoCompleteJComboBox;
import org.yccheok.jstock.gui.AutoUpdateNewsJDialog;
import org.yccheok.jstock.gui.BackwardCompatible;
import org.yccheok.jstock.gui.Continent;
import org.yccheok.jstock.gui.CountryJDialog;
import org.yccheok.jstock.gui.GA;
import org.yccheok.jstock.gui.GUIOptions;
import org.yccheok.jstock.gui.IndicatorPanel;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.IndicatorScannerJPanel;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.LoadFromCloudJDialog;
import org.yccheok.jstock.gui.MarketJPanel;
import org.yccheok.jstock.gui.MyJXStatusBar;
import org.yccheok.jstock.gui.OptionsJDialog;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.gui.SaveToCloudJDialog;
import org.yccheok.jstock.gui.StockAlert;
import org.yccheok.jstock.gui.StockDatabaseJDialog;
import org.yccheok.jstock.gui.StockJDialog;
import org.yccheok.jstock.gui.StockTableCellRenderer;
import org.yccheok.jstock.gui.StockTableModel;
import org.yccheok.jstock.gui.TableColumnSelectionPopupListener;
import org.yccheok.jstock.gui.UIOptions;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.ChartJDialog;
import org.yccheok.jstock.gui.charting.ChartJDialogOptions;
import org.yccheok.jstock.gui.charting.DynamicChart;
import org.yccheok.jstock.gui.news.StockNewsJFrame;
import org.yccheok.jstock.gui.portfolio.Calc;
import org.yccheok.jstock.gui.portfolio.PortfolioJDialog;
import org.yccheok.jstock.gui.table.NonNegativeDoubleEditor;
import org.yccheok.jstock.gui.trading.TradingJPanel;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.gui.watchlist.WatchlistJDialog;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.ProxyDetector;
import org.yccheok.jstock.network.Utils;
import org.yccheok.jstock.portfolio.PortfolioInfo;
import org.yccheok.jstock.watchlist.WatchlistInfo;

public class JStock
extends JFrame {
    private TrayIcon trayIcon;
    private static final Log log;
    private final MyJXStatusBar statusBar = new MyJXStatusBar();
    private boolean isStatusBarBusy = false;
    private final Set<Code> stockCodeHistoryGUI = new HashSet<Code>();
    private volatile StockInfoDatabase stockInfoDatabase = null;
    private volatile StockNameDatabase stockNameDatabase = null;
    private RealTimeStockMonitor realTimeStockMonitor = null;
    private RealTimeIndexMonitor realTimeIndexMonitor = null;
    private StockHistoryMonitor stockHistoryMonitor = null;
    private DatabaseTask databaseTask = null;
    private final Object databaseTaskMonitor = new Object();
    private LatestNewsTask latestNewsTask = null;
    private JStockOptions jStockOptions;
    private UIOptions uiOptions;
    private ChartJDialogOptions chartJDialogOptions;
    private IndicatorPanel indicatorPanel;
    private IndicatorScannerJPanel indicatorScannerJPanel;
    private PortfolioManagementJPanel portfolioManagementJPanel;
    private TradingJPanel tradingJPanel;
    private final AlertStateManager alertStateManager = new AlertStateManager();
    private final ExecutorService emailAlertPool = Executors.newFixedThreadPool(1);
    private final ExecutorService systemTrayAlertPool = Executors.newFixedThreadPool(1);
    private volatile ExecutorService stockInfoDatabaseMetaPool = Executors.newFixedThreadPool(1);
    private volatile ExecutorService singleThreadExecutor = Executors.newFixedThreadPool(1);
    private final Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> realTimeStockMonitorObserver = this.getRealTimeStockMonitorObserver();
    private final Observer<RealTimeIndexMonitor, List<Market>> realTimeIndexMonitorObserver = this.getRealTimeIndexMonitorObserver();
    private final Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> stockHistoryMonitorObserver = this.getStockHistoryMonitorObserver();
    private final Observer<Indicator, Boolean> alertStateManagerObserver = this.getAlertStateManagerObserver();
    private final ImageIcon smileIcon = this.getImageIcon("/images/16x16/smile.png");
    private final ImageIcon smileGrayIcon = this.getImageIcon("/images/16x16/smile-gray.png");
    private final Executor zombiePool = Utils.getZoombiePool();
    private MarketJPanel marketJPanel;
    private final Map<Code, DynamicChart> dynamicCharts = new ConcurrentHashMap<Code, DynamicChart>();
    private static final int MAX_DYNAMIC_CHART_SIZE = 10;
    private static final DynamicChart EMPTY_DYNAMIC_CHART;
    private final MouseAdapter dynamicChartMouseAdapter = this.getDynamicChartMouseAdapter();
    private static final int HISTORY_MONITOR_MAX_THREAD = 4;
    private static final Indicator FALL_BELOW_INDICATOR;
    private static final Indicator RISE_ABOVE_INDICATOR;
    private volatile boolean needToSaveUserDefinedDatabase = false;
    private volatile boolean isFormWindowClosedCalled = false;
    private long timestamp = 0L;
    private boolean refreshPriceInProgress = false;
    private JMenuItem alwaysOnTopMenuItem = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu10;
    private JMenu jMenu11;
    private JMenu jMenu12;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenu jMenu7;
    private JMenu jMenu8;
    private JMenu jMenu9;
    private JMenuBar jMenuBar2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem18;
    private JMenuItem jMenuItem19;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JRadioButtonMenuItem jRadioButtonMenuItem1;
    private JRadioButtonMenuItem jRadioButtonMenuItem2;
    private JRadioButtonMenuItem jRadioButtonMenuItem3;
    private JRadioButtonMenuItem jRadioButtonMenuItem4;
    private JRadioButtonMenuItem jRadioButtonMenuItem5;
    private JRadioButtonMenuItem jRadioButtonMenuItem6;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;

    private JStock() {
    }

    private void init() {
        this.initComponents();
        this.createLookAndFeelMenuItems();
        this.rebuildCountryMenuItems(true);
        this.createStockIndicatorEditor();
        this.createIndicatorScannerJPanel();
        this.createPortfolioManagementJPanel();
        this.createIconsAndToolTipTextForJTabbedPane();
        this.createSystemTrayIcon();
        this.initPreloadDatabase(false);
        this.initUIOptions();
        this.initExtraDatas();
        this.initStatusBar();
        this.initMarketJPanel();
        this.initTableHeaderToolTips();
        this.initMyJXStatusBarExchangeRateLabelMouseAdapter();
        this.initMyJXStatusBarCountryLabelMouseAdapter();
        this.initMyJXStatusBarImageLabelMouseAdapter();
        this.initStockInfoDatabaseMeta();
        this.initGoogleCodeDatabaseRunnable();
        this.initIEXStockInfoDatabaseRunnable();
        this.initDatabase(true);
        this.initAjaxProvider();
        this.initRealTimeIndexMonitor();
        this.initLatestNewsTask();
        this.initExchangeRateMonitor();
        this.initRealTimeStockMonitor();
        this.initWatchlist();
        this.initAlertStateManager();
        this.initDynamicCharts();
        this.initDynamicChartVisibility();
        this.initAlwaysOnTop();
        this.initStockHistoryMonitor();
        this.initOthersStockHistoryMonitor();
        this.initGUIOptions();
        this.initChartJDialogOptions();
        this.initLanguageMenuItemsSelection();
        this.initJXLayerOnJComboBox();
        this.initKeyBindings();
        int lastSelectedPageIndex = this.getJStockOptions().getLastSelectedPageIndex();
        if (this.jTabbedPane1.getTabCount() > lastSelectedPageIndex) {
            this.jTabbedPane1.setSelectedIndex(lastSelectedPageIndex);
        }
        this.handleJTabbedPaneStateChanged(this.jTabbedPane1);
        JStockOptions.BoundsEx boundsEx = this.jStockOptions.getBoundsEx();
        if (boundsEx == null) {
            this.setExtendedState(6);
        } else if ((boundsEx.extendedState & 6) == 6) {
            this.setExtendedState(6);
        } else {
            this.setBounds(boundsEx.bounds);
        }
        this.installShutdownHook();
        BackwardCompatible.removeGoogleCodeDatabaseIfNecessary();
    }

    private void requestFocusOnJComboBox() {
        this.jComboBox1.getEditor().getEditorComponent().requestFocus();
    }

    private void initKeyBindings() {
        KeyStroke watchlistNavigationKeyStroke = KeyStroke.getKeyStroke(87, 2);
        KeyStroke portfolioNavigationKeyStroke = KeyStroke.getKeyStroke(80, 2);
        this.getRootPane().getInputMap(2).put(watchlistNavigationKeyStroke, "watchlistNavigation");
        this.getRootPane().getInputMap(2).put(portfolioNavigationKeyStroke, "portfolioNavigation");
        this.getRootPane().getActionMap().put("watchlistNavigation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStock.this.watchlistNavigation();
            }
        });
        this.getRootPane().getActionMap().put("portfolioNavigation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStock.this.portfolioNavigation();
            }
        });
    }

    private void watchlistNavigation() {
        int index;
        if (this.getSelectedComponent() != this.jPanel8) {
            this.jTabbedPane1.setSelectedIndex(0);
            return;
        }
        List<String> watchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        int size = watchlistNames.size();
        if (size <= 1) {
            return;
        }
        String currentWatchlistName = this.getJStockOptions().getWatchlistName();
        for (index = 0; index < size; ++index) {
            if (!watchlistNames.get(index).equals(currentWatchlistName)) continue;
            if (++index < size) break;
            index = 0;
            break;
        }
        this.selectActiveWatchlist(watchlistNames.get(index));
    }

    private void portfolioNavigation() {
        int index;
        if (this.getSelectedComponent() != this.portfolioManagementJPanel) {
            this.jTabbedPane1.setSelectedIndex(3);
            return;
        }
        List<String> portfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        int size = portfolioNames.size();
        if (size <= 1) {
            return;
        }
        String currentPortfolioName = this.getJStockOptions().getPortfolioName();
        for (index = 0; index < size; ++index) {
            if (!portfolioNames.get(index).equals(currentPortfolioName)) continue;
            if (++index < size) break;
            index = 0;
            break;
        }
        this.selectActivePortfolio(portfolioNames.get(index));
    }

    private void installShutdownHook() {
        if (Utils.isMacOSX()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (JStock.this.isFormWindowClosedCalled) {
                        AppLock.unlock();
                        return;
                    }
                    JStock.this.save();
                    if (JStock.this.needToSaveUserDefinedDatabase) {
                        JStock.this.saveUserDefinedDatabaseAsCSV(JStock.this.jStockOptions.getCountry(), JStock.this.stockInfoDatabase);
                    }
                    AppLock.unlock();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(runner, "Window Prefs Hook"));
        } else {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    AppLock.unlock();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(runner, "Window Prefs Hook"));
        }
    }

    private void initLanguageMenuItemsSelection() {
        Locale defaultLocale = Locale.getDefault();
        if (Utils.isTraditionalChinese(defaultLocale)) {
            this.jRadioButtonMenuItem4.setSelected(true);
        } else if (Utils.isSimplifiedChinese(defaultLocale)) {
            this.jRadioButtonMenuItem2.setSelected(true);
        } else if (defaultLocale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
            this.jRadioButtonMenuItem3.setSelected(true);
        } else if (defaultLocale.getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            this.jRadioButtonMenuItem5.setSelected(true);
        } else if (defaultLocale.getLanguage().equals(Locale.FRENCH.getLanguage())) {
            this.jRadioButtonMenuItem6.setSelected(true);
        } else {
            this.jRadioButtonMenuItem1.setSelected(true);
        }
    }

    public static JStock instance() {
        return MainFrameHolder.INSTANCE;
    }

    private void initJXLayerOnJComboBox() {
        this.jPanel1.add((Component)Utils.getBusyJXLayer((AutoCompleteJComboBox)this.jComboBox1));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jComboBox1 = new AutoCompleteJComboBox();
        this.jPanel6 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItem11 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem15 = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jMenu10 = new JMenu();
        this.jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem4 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem6 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem3 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem5 = new JRadioButtonMenuItem();
        this.jMenu7 = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.jMenu9 = new JMenu();
        this.jMenu8 = new JMenu();
        this.jMenu1 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem16 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jMenuItem18 = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItem13 = new JMenuItem();
        this.jMenuItem14 = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItem5 = new JMenuItem();
        this.jMenu11 = new JMenu();
        this.jMenuItem17 = new JMenuItem();
        this.jMenu12 = new JMenu();
        this.jMenuItem19 = new JMenuItem();
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(150, 24));
        ((AutoCompleteJComboBox)this.jComboBox1).attachStockInfoObserver(this.getStockInfoObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachDispObserver(this.getDispObserver());
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("MainFrame_Application_Title"));
        this.setIconImage(this.getMyIconImage());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JStock.this.formMouseClicked(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                JStock.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                JStock.this.formWindowClosing(evt);
            }

            @Override
            public void windowDeiconified(WindowEvent evt) {
                JStock.this.formWindowDeiconified(evt);
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                JStock.this.formWindowIconified(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel6.setLayout(new BorderLayout(5, 5));
        this.jPanel6.add((Component)((Object)this.statusBar), "South");
        this.getContentPane().add((Component)this.jPanel6, "South");
        this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JStock.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel8.setLayout(new BorderLayout(5, 5));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setFont(this.jTable1.getFont().deriveFont(this.jTable1.getFont().getStyle() | 1, this.jTable1.getFont().getSize() + 1));
        this.jTable1.setModel(new StockTableModel());
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setDefaultRenderer(Number.class, new StockTableCellRenderer(4));
        this.jTable1.setDefaultRenderer(Double.class, new StockTableCellRenderer(4));
        this.jTable1.setDefaultRenderer(Object.class, new StockTableCellRenderer(2));
        this.jTable1.setDefaultEditor(Double.class, new NonNegativeDoubleEditor());
        this.jTable1.getModel().addTableModelListener(this.getTableModelListener());
        this.jTable1.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(1));
        this.jTable1.addMouseListener(new TableMouseAdapter());
        this.jTable1.addKeyListener(new TableKeyEventListener());
        if (this.jStockOptions.useLargeFont()) {
            this.jTable1.setRowHeight((int)((double)this.jTable1.getRowHeight() * 1.2));
        }
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JStock.this.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel8.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText(bundle.getString("MainFrame_Stock"));
        this.jPanel1.add(this.jLabel1);
        this.jPanel8.add((Component)this.jPanel1, "North");
        this.jPanel10.setPreferredSize(new Dimension(328, 170));
        this.jPanel10.setLayout(new FlowLayout(0, 10, 5));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setPreferredSize(new Dimension(170, 160));
        this.jPanel3.setBorder((Border)new DropShadowBorder(true));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel10.add(this.jPanel3);
        EMPTY_DYNAMIC_CHART.getChartPanel().addMouseListener((MouseListener)this.dynamicChartMouseAdapter);
        this.jPanel3.add((Component)EMPTY_DYNAMIC_CHART.getChartPanel(), "Center");
        this.jPanel8.add((Component)this.jPanel10, "South");
        this.jTabbedPane1.addTab(bundle.getString("MainFrame_Title"), this.jPanel8);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel2.setLayout(new GridLayout(2, 1));
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jMenu3.setText(bundle.getString("MainFrame_File"));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/project_open.png")));
        this.jMenuItem2.setText(bundle.getString("MainFrame_Open..."));
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenuItem9.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filesave.png")));
        this.jMenuItem9.setText(bundle.getString("MainFrame_SaveAs..."));
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem9);
        this.jMenu3.add(this.jSeparator7);
        this.jMenuItem11.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/download_from_cloud.png")));
        this.jMenuItem11.setText(bundle.getString("MainFrame_OpenFromCloud..."));
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem11);
        this.jMenuItem10.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/upload_to_cloud.png")));
        this.jMenuItem10.setText(bundle.getString("MainFrame_SaveToCloud..."));
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem10);
        this.jMenu3.add(this.jSeparator8);
        this.jMenuItem1.setText(bundle.getString("MainFrame_Exit"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem1);
        this.jMenuBar2.add(this.jMenu3);
        this.jMenu5.setText(bundle.getString("MainFrame_Edit"));
        this.jMenuItem4.setText(bundle.getString("MainFrame_AddStocks..."));
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem4);
        this.jMenuItem7.setText(bundle.getString("MainFrame_ClearAllStocks"));
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem7);
        this.jMenu5.add(this.jSeparator4);
        this.jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.jMenuItem15.setText(bundle.getString("MainFrame_RefreshStockPrices"));
        this.jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem15ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem15);
        this.jMenuBar2.add(this.jMenu5);
        this.jMenu6.setText(bundle.getString("MainFrame_Country"));
        this.jMenu6.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                JStock.this.jMenu6MenuSelected(evt);
            }
        });
        this.jMenuBar2.add(this.jMenu6);
        this.jMenu10.setText(bundle.getString("MainFrame_Language"));
        this.buttonGroup3.add(this.jRadioButtonMenuItem1);
        this.jRadioButtonMenuItem1.setSelected(true);
        this.jRadioButtonMenuItem1.setText(Locale.ENGLISH.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jRadioButtonMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem1);
        this.buttonGroup3.add(this.jRadioButtonMenuItem2);
        this.jRadioButtonMenuItem2.setText(Locale.SIMPLIFIED_CHINESE.getDisplayName(Locale.getDefault()));
        this.jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jRadioButtonMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem2);
        this.buttonGroup3.add(this.jRadioButtonMenuItem4);
        this.jRadioButtonMenuItem4.setText(Locale.TRADITIONAL_CHINESE.getDisplayName(Locale.getDefault()));
        this.jRadioButtonMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jRadioButtonMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem4);
        this.buttonGroup3.add(this.jRadioButtonMenuItem6);
        this.jRadioButtonMenuItem6.setText(Locale.FRENCH.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jRadioButtonMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem6);
        this.buttonGroup3.add(this.jRadioButtonMenuItem3);
        this.jRadioButtonMenuItem3.setText(Locale.GERMAN.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jRadioButtonMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem3);
        this.buttonGroup3.add(this.jRadioButtonMenuItem5);
        this.jRadioButtonMenuItem5.setText(Locale.ITALIAN.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jRadioButtonMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem5);
        this.jMenuBar2.add(this.jMenu10);
        this.jMenu7.setText(bundle.getString("MainFrame_Database"));
        this.jMenuItem8.setText(bundle.getString("MainFrame_StockDatabase..."));
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu7.add(this.jMenuItem8);
        this.jMenuBar2.add(this.jMenu7);
        this.jMenu9.setText(bundle.getString("MainFrame_Watchlist"));
        this.jMenu9.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                JStock.this.jMenu9MenuSelected(evt);
            }
        });
        this.jMenuBar2.add(this.jMenu9);
        this.jMenu8.setText(bundle.getString("MainFrame_Portfolio"));
        this.jMenu8.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                JStock.this.jMenu8MenuSelected(evt);
            }
        });
        this.jMenuBar2.add(this.jMenu8);
        this.jMenu1.setText(bundle.getString("MainFrame_Options"));
        this.jMenuItem6.setText(bundle.getString("MainFrame_Options..."));
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuBar2.add(this.jMenu1);
        this.jMenu4.setText(bundle.getString("MainFrame_LooknFeel"));
        this.jMenuBar2.add(this.jMenu4);
        this.jMenu2.setText(bundle.getString("MainFrame_Help"));
        this.jMenuItem3.setText(bundle.getString("MainFrame_OnlineHelp"));
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenuItem16.setText(bundle.getString("MainFrame_KeyboardShortcuts"));
        this.jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem16ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem16);
        this.jMenuItem12.setText(bundle.getString("MainFrame_Calculator"));
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem12ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem12);
        this.jMenuItem18.setText(bundle.getString("MainFrame_Export"));
        this.jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem18ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem18);
        this.jMenu2.add(this.jSeparator6);
        this.jMenuItem13.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/smile2.png")));
        this.jMenuItem13.setText(bundle.getString("MainFrame_DonateToJStock"));
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem13ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem13);
        this.jMenuItem14.setText(bundle.getString("MainFrame_ContributeToJStock"));
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem14ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem14);
        this.jMenu2.add(this.jSeparator5);
        this.jMenuItem5.setText(bundle.getString("MainFrame_About..."));
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuBar2.add(this.jMenu2);
        this.jMenu11.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/android-small.png")));
        this.jMenu11.setText(bundle.getString("MainFrame_Android"));
        this.jMenu11.setFont(this.jMenu11.getFont().deriveFont(this.jMenu11.getFont().getStyle() | 1));
        this.jMenuItem17.setText(bundle.getString("MainFrame_DownloadJStockAndroid"));
        this.jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem17ActionPerformed(evt);
            }
        });
        this.jMenu11.add(this.jMenuItem17);
        this.jMenuBar2.add(this.jMenu11);
        this.jMenu12.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/wenote.png")));
        this.jMenu12.setText(bundle.getString("MainFrame_WeNote"));
        this.jMenu12.setFont(this.jMenu12.getFont().deriveFont(this.jMenu12.getFont().getStyle() | 1));
        this.jMenuItem19.setText(bundle.getString("MainFrame_DownloadWeNote"));
        this.jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.jMenuItem19ActionPerformed(evt);
            }
        });
        this.jMenu12.add(this.jMenuItem19);
        this.jMenuBar2.add(this.jMenu12);
        this.setJMenuBar(this.jMenuBar2);
        this.setSize(new Dimension(952, 478));
        this.setLocationRelativeTo(null);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        if (this.getStockInfoDatabase() == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_we_havent_connected_to_stock_server"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_we_havent_connected_to_stock_server"), 1);
            return;
        }
        StockJDialog stockJDialog = new StockJDialog((Frame)this, true);
        stockJDialog.setLocationRelativeTo(this);
        stockJDialog.setVisible(true);
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.clearAllStocks();
    }

    private boolean openAsCSVFile(File file) {
        Statements statements = Statements.newInstanceFromCSVFile(file);
        return this.openAsStatements(statements, file);
    }

    public boolean openAsStatements(Statements statements, File file) {
        assert (statements != null);
        GUIBundleWrapper guiBundleWrapper = statements.getGUIBundleWrapper();
        if (statements.getType() == Statement.Type.RealtimeInfo) {
            int size = statements.size();
            for (int i = 0; i < size; ++i) {
                Statement statement = statements.get(i);
                String codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                String symbolStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                Double fallBelowDouble = statement.getValueAsDouble(guiBundleWrapper.getString("MainFrame_FallBelow"));
                Double riseAboveDouble = statement.getValueAsDouble(guiBundleWrapper.getString("MainFrame_RiseAbove"));
                if (codeStr.length() <= 0 || symbolStr.length() <= 0) continue;
                Stock stock = org.yccheok.jstock.engine.Utils.getEmptyStock(Code.newInstance(codeStr), Symbol.newInstance(symbolStr));
                StockAlert stockAlert = new StockAlert().setFallBelow(fallBelowDouble).setRiseAbove(riseAboveDouble);
                this.addStockToTable(stock, stockAlert);
                this.realTimeStockMonitor.addStockCode(Code.newInstance(codeStr));
            }
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
        } else if (statements.getType() == Statement.Type.StockIndicatorScanner) {
            int size = statements.size();
            for (int i = 0; i < size; ++i) {
                Statement statement = statements.get(i);
                String codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                String symbolStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                if (codeStr.length() <= 0 || symbolStr.length() <= 0) continue;
                Stock stock = org.yccheok.jstock.engine.Utils.getEmptyStock(Code.newInstance(codeStr), Symbol.newInstance(symbolStr));
                this.addStockToTable(stock);
                this.realTimeStockMonitor.addStockCode(Code.newInstance(codeStr));
            }
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
        } else {
            if (statements.getType() == Statement.Type.PortfolioManagementBuy || statements.getType() == Statement.Type.PortfolioManagementSell || statements.getType() == Statement.Type.PortfolioManagementDeposit || statements.getType() == Statement.Type.PortfolioManagementDividend) {
                return this.portfolioManagementJPanel.openAsStatements(statements, file);
            }
            return false;
        }
        return true;
    }

    private boolean openAsExcelFile(File file) {
        List<Statements> statementsList = Statements.newInstanceFromExcelFile(file);
        boolean status = statementsList.size() > 0;
        for (Statements statements : statementsList) {
            status &= this.openAsStatements(statements, file);
        }
        return status;
    }

    public RealTimeStockMonitor getRealTimeStockMonitor() {
        return this.realTimeStockMonitor;
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        File file = Utils.promptOpenCSVAndExcelJFileChooser();
        if (file == null) {
            return;
        }
        boolean status = true;
        if (Utils.getFileExtension(file).equals("xls")) {
            if (this.getSelectedComponent() == this.jPanel8) {
                status = this.openAsExcelFile(file);
            } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
                status = this.portfolioManagementJPanel.openAsExcelFile(file);
            } else assert (false);
        } else if (Utils.getFileExtension(file).equals("csv")) {
            if (this.getSelectedComponent() == this.jPanel8) {
                status = this.openAsCSVFile(file);
            } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
                status = this.portfolioManagementJPanel.openAsCSVFile(file);
            } else assert (false);
        } else assert (false);
        if (!status) {
            String output = MessageFormat.format(MessagesBundle.getString("error_message_bad_file_format_template"), file.getName());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("error_title_bad_file_format"), 0);
        }
    }

    private void handleJTabbedPaneStateChanged(JTabbedPane pane) {
        if (pane.getSelectedComponent() == this.jPanel8) {
            this.jMenuItem2.setEnabled(true);
            this.jMenuItem9.setEnabled(true);
            this.jMenuItem4.setEnabled(true);
            this.jMenuItem7.setEnabled(true);
            this.jMenuItem15.setEnabled(true);
            this.requestFocusOnJComboBox();
        } else if (pane.getSelectedComponent() == this.indicatorPanel) {
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem9.setEnabled(false);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(false);
        } else if (pane.getSelectedComponent() == this.indicatorScannerJPanel) {
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem9.setEnabled(true);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(true);
        } else if (pane.getSelectedComponent() == this.portfolioManagementJPanel) {
            this.jMenuItem2.setEnabled(true);
            this.jMenuItem9.setEnabled(true);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(true);
        } else if (pane.getSelectedComponent() == this.tradingJPanel) {
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem9.setEnabled(false);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(true);
        }
        if (!this.isStatusBarBusy) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        this.handleJTabbedPaneStateChanged(pane);
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        OptionsJDialog optionsJDialog = new OptionsJDialog((Frame)this, true);
        optionsJDialog.setLocationRelativeTo(this);
        optionsJDialog.set(this.jStockOptions);
        optionsJDialog.setVisible(true);
    }

    public JStockOptions getJStockOptions() {
        return this.jStockOptions;
    }

    public UIOptions getUIOptions() {
        return this.uiOptions;
    }

    public ChartJDialogOptions getChartJDialogOptions() {
        return this.chartJDialogOptions;
    }

    public void save() {
        this.getJStockOptions().setLastSelectedPageIndex(this.jTabbedPane1.getSelectedIndex());
        JStockOptions.BoundsEx boundsEx = new JStockOptions.BoundsEx(this.getBounds(), this.getExtendedState());
        this.getJStockOptions().setBoundsEx(boundsEx);
        this.jStockOptions.setApplicationVersionID(Utils.getApplicationVersionID());
        this.saveJStockOptions();
        this.saveUIOptions();
        this.saveGUIOptions();
        this.saveChartJDialogOptions();
        this.saveWatchlist();
        this.indicatorPanel.saveAlertIndicatorProjectManager();
        this.indicatorPanel.saveModuleIndicatorProjectManager();
        this.portfolioManagementJPanel.savePortfolio();
    }

    private void dettachAllAndStopAutoCompleteJComboBox() {
        ((AutoCompleteJComboBox)this.jComboBox1).dettachAll();
        ((AutoCompleteJComboBox)this.jComboBox1).stop();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.isFormWindowClosedCalled = true;
        try {
            TrayIcon _trayIcon;
            ExecutorService _stockInfoDatabaseMetaPool = this.stockInfoDatabaseMetaPool;
            this.stockInfoDatabaseMetaPool = null;
            if (_stockInfoDatabaseMetaPool != null) {
                _stockInfoDatabaseMetaPool.shutdownNow();
            }
            ExecutorService _singleThreadExecutor = this.singleThreadExecutor;
            this.singleThreadExecutor = null;
            if (_singleThreadExecutor != null) {
                _singleThreadExecutor.shutdownNow();
            }
            this.save();
            if (this.needToSaveUserDefinedDatabase) {
                this.saveUserDefinedDatabaseAsCSV(this.jStockOptions.getCountry(), this.stockInfoDatabase);
            }
            if ((_trayIcon = this.trayIcon) != null) {
                SystemTray.getSystemTray().remove(_trayIcon);
                this.trayIcon = null;
            }
            this.dettachAllAndStopAutoCompleteJComboBox();
            this.indicatorPanel.dettachAllAndStopAutoCompleteJComboBox();
            log.info((Object)"latestNewsTask stop...");
            if (this.latestNewsTask != null) {
                this.latestNewsTask.cancel(true);
            }
            _stockInfoDatabaseMetaPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            log.info((Object)"Widnow is closed.");
        }
        catch (Exception exp) {
            log.error((Object)"Unexpected error while trying to quit application", (Throwable)exp);
        }
        Platform.exit();
        System.exit(0);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        new AboutJDialog((Frame)this, true).setVisible(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void formWindowIconified(WindowEvent evt) {
        if (Utils.isWindows()) {
            this.setVisible(false);
        }
    }

    private void formWindowDeiconified(WindowEvent evt) {
    }

    private void formMouseClicked(MouseEvent evt) {
        this.jTable1.getSelectionModel().clearSelection();
        this.indicatorScannerJPanel.clearTableSelection();
        this.portfolioManagementJPanel.clearTableSelection();
        this.updateDynamicChart(null);
    }

    private void updateDynamicChart(Stock stock) {
        DynamicChart dynamicChart;
        assert (EventQueue.isDispatchThread());
        DynamicChart dynamicChart2 = dynamicChart = stock != null ? this.dynamicCharts.get(stock.code) : EMPTY_DYNAMIC_CHART;
        if (dynamicChart == null) {
            dynamicChart = EMPTY_DYNAMIC_CHART;
        }
        if (Arrays.asList(this.jPanel3.getComponents()).contains(dynamicChart.getChartPanel())) {
            return;
        }
        this.jPanel3.removeAll();
        this.jPanel3.add((Component)dynamicChart.getChartPanel(), "Center");
        this.jPanel3.validate();
        dynamicChart.getChartPanel().repaint();
        dynamicChart.getChartPanel().removeMouseListener((MouseListener)this.dynamicChartMouseAdapter);
        dynamicChart.getChartPanel().addMouseListener((MouseListener)this.dynamicChartMouseAdapter);
    }

    private void jTable1KeyPressed(KeyEvent evt) {
        if (127 == evt.getKeyCode()) {
            this.deteleSelectedTableRow();
            return;
        }
        if (10 == evt.getKeyCode()) {
            this.displayHistoryCharts();
            return;
        }
        if (evt.isActionKey()) {
            int[] rows = this.jTable1.getSelectedRows();
            if (rows.length == 1) {
                int row = rows[0];
                StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
                int modelIndex = this.jTable1.convertRowIndexToModel(row);
                Stock stock = tableModel.getStock(modelIndex);
                this.updateDynamicChart(stock);
            } else {
                this.updateDynamicChart(null);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.indicatorPanel.promptToSaveSignificantEdits()) {
            this.dispose();
        }
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        StockInfoDatabase stock_info_database = this.stockInfoDatabase;
        if (stock_info_database == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_there_are_no_database_ready_yet"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_there_are_no_database_ready_yet"), 1);
            return;
        }
        StockDatabaseJDialog stockDatabaseJDialog = new StockDatabaseJDialog((Frame)this, stock_info_database, true);
        stockDatabaseJDialog.setSize(540, 540);
        stockDatabaseJDialog.setLocationRelativeTo(this);
        stockDatabaseJDialog.setVisible(true);
        if (stockDatabaseJDialog.getResult() != null) {
            assert (stockDatabaseJDialog.getResult() == this.stockInfoDatabase);
            this.stockInfoDatabase = stockDatabaseJDialog.getResult();
            ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(this.stockInfoDatabase);
            this.indicatorPanel.setStockInfoDatabase(this.stockInfoDatabase);
            log.info((Object)"saveStockCodeAndSymbolDatabase...");
            this.saveDatabase();
        }
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        String suggestedFileName = "";
        if (this.getSelectedComponent() == this.jPanel8) {
            suggestedFileName = GUIBundle.getString("MainFrame_Title");
        } else if (this.getSelectedComponent() == this.indicatorScannerJPanel) {
            suggestedFileName = GUIBundle.getString("IndicatorScannerJPanel_Title");
        } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
            suggestedFileName = GUIBundle.getString("PortfolioManagementJPanel_Title");
        } else assert (false);
        boolean status = true;
        File file = null;
        if (this.getSelectedComponent() == this.jPanel8 || this.getSelectedComponent() == this.indicatorScannerJPanel) {
            file = Utils.promptSaveCSVAndExcelJFileChooser(suggestedFileName);
            if (file != null) {
                if (Utils.getFileExtension(file).equals("csv")) {
                    if (this.getSelectedComponent() == this.jPanel8) {
                        status = this.saveAsCSVFile(file, false);
                    } else if (this.getSelectedComponent() == this.indicatorScannerJPanel) {
                        status = this.indicatorScannerJPanel.saveAsCSVFile(file);
                    } else assert (false);
                } else if (Utils.getFileExtension(file).equals("xls")) {
                    if (this.getSelectedComponent() == this.jPanel8) {
                        status = this.saveAsExcelFile(file);
                    } else if (this.getSelectedComponent() == this.indicatorScannerJPanel) {
                        status = this.indicatorScannerJPanel.saveAsExcelFile(file);
                    } else assert (false);
                }
            }
        } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
            Utils.FileEx fileEx = Utils.promptSavePortfolioCSVAndExcelJFileChooser(suggestedFileName);
            if (fileEx != null) {
                file = fileEx.file;
                if (Utils.getFileExtension(fileEx.file).equals("csv")) {
                    status = this.portfolioManagementJPanel.saveAsCSVFile(fileEx, false);
                } else if (Utils.getFileExtension(fileEx.file).equals("xls")) {
                    status = this.portfolioManagementJPanel.saveAsExcelFile(fileEx.file, false);
                }
            }
        } else assert (false);
        if (!status) {
            assert (file != null);
            String output = MessageFormat.format(MessagesBundle.getString("error_message_nothing_to_be_saved_template"), file.getName());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("error_title_nothing_to_be_saved"), 0);
        }
    }

    private void jMenu8MenuSelected(MenuEvent evt) {
        this.jMenu8.removeAll();
        List<String> portfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        final String currentPortfolioName = this.getJStockOptions().getPortfolioName();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String portfolioName : portfolioNames) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu8.add(new JRadioButtonMenuItem(portfolioName));
            buttonGroup.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ((JRadioButtonMenuItem)e.getSource()).getText();
                    if (!s.equals(currentPortfolioName)) {
                        JStock.this.selectActivePortfolio(s);
                    }
                }
            });
            mi.setSelected(portfolioName.equals(currentPortfolioName));
        }
        this.jMenu8.addSeparator();
        JMenuItem mi = new JMenuItem(GUIBundle.getString("MainFrame_MultiplePortolio..."), this.getImageIcon("/images/16x16/calc.png"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStock.this.multiplePortfolios();
            }
        });
        this.jMenu8.add(mi);
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        this.loadFromCloud();
    }

    public void saveToCloud() {
        this.jMenu3.setEnabled(false);
        SwingWorker<Pair<Pair<Credential, String>, Boolean>, Void> swingWorker = new SwingWorker<Pair<Pair<Credential, String>, Boolean>, Void>(){

            @Override
            protected Pair<Pair<Credential, String>, Boolean> doInBackground() throws Exception {
                Pair<Pair<Credential, String>, Boolean> pair = org.yccheok.jstock.google.Utils.authorizeDrive();
                return pair;
            }

            @Override
            public void done() {
                JStock.this.jMenu3.setEnabled(true);
                Pair pair = null;
                try {
                    pair = (Pair)this.get();
                }
                catch (InterruptedException ex) {
                    JOptionPane.showMessageDialog(JStock.this, ex.getMessage(), GUIBundle.getString("SaveToCloudJDialog_Title"), 0);
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    org.yccheok.jstock.google.Utils.logoutDrive();
                    JOptionPane.showMessageDialog(JStock.this, ex.getMessage(), GUIBundle.getString("SaveToCloudJDialog_Title"), 0);
                    log.error(null, (Throwable)ex);
                }
                if (pair == null) {
                    return;
                }
                SaveToCloudJDialog saveToCloudJDialog = new SaveToCloudJDialog((Frame)JStock.this, true, (Pair)pair.first, (Boolean)pair.second);
                saveToCloudJDialog.setVisible(true);
            }
        };
        swingWorker.execute();
    }

    public void loadFromCloud() {
        this.jMenu3.setEnabled(false);
        SwingWorker<Pair<Pair<Credential, String>, Boolean>, Void> swingWorker = new SwingWorker<Pair<Pair<Credential, String>, Boolean>, Void>(){

            @Override
            protected Pair<Pair<Credential, String>, Boolean> doInBackground() throws Exception {
                Pair<Pair<Credential, String>, Boolean> pair = org.yccheok.jstock.google.Utils.authorizeDrive();
                if (pair == null) {
                    return null;
                }
                return pair;
            }

            @Override
            public void done() {
                JStock.this.jMenu3.setEnabled(true);
                Pair pair = null;
                try {
                    pair = (Pair)this.get();
                }
                catch (InterruptedException ex) {
                    JOptionPane.showMessageDialog(JStock.this, ex.getMessage(), GUIBundle.getString("LoadFromCloudJDialog_Title"), 0);
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    org.yccheok.jstock.google.Utils.logoutDrive();
                    JOptionPane.showMessageDialog(JStock.this, ex.getMessage(), GUIBundle.getString("LoadFromCloudJDialog_Title"), 0);
                    log.error(null, (Throwable)ex);
                }
                if (pair == null) {
                    return;
                }
                LoadFromCloudJDialog loadFromCloudJDialog = new LoadFromCloudJDialog((Frame)JStock.this, true, (Pair)pair.first, (Boolean)pair.second);
                loadFromCloudJDialog.setVisible(true);
            }
        };
        swingWorker.execute();
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        this.saveToCloud();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.HELP_HTML));
    }

    private void jMenu9MenuSelected(MenuEvent evt) {
        this.jMenu9.removeAll();
        List<String> watchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        final String currentWatchlistName = this.getJStockOptions().getWatchlistName();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String watchlistName : watchlistNames) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu9.add(new JRadioButtonMenuItem(watchlistName));
            buttonGroup.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ((JRadioButtonMenuItem)e.getSource()).getText();
                    if (!s.equals(currentWatchlistName)) {
                        JStock.this.selectActiveWatchlist(s);
                    }
                }
            });
            mi.setSelected(watchlistName.equals(currentWatchlistName));
        }
        this.jMenu9.addSeparator();
        JMenuItem mi = new JMenuItem(GUIBundle.getString("MainFrame_MultipleWatchlist..."), this.getImageIcon("/images/16x16/stock_timezone.png"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStock.this.multipleWatchlists();
            }
        });
        this.jMenu9.add(mi);
    }

    private void jMenuItem12ActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec("calc");
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            Calc calc = new Calc((Frame)this, false);
            calc.setVisible(true);
        }
    }

    private void jRadioButtonMenuItem1ActionPerformed(ActionEvent evt) {
        if (!Utils.hasSpecifiedLanguageFile(this.jStockOptions.getLocale())) {
            return;
        }
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.ENGLISH.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jRadioButtonMenuItem2ActionPerformed(ActionEvent evt) {
        if (!Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                String country = Locale.TRADITIONAL_CHINESE.getCountry().equals(Locale.getDefault().getCountry()) ? Locale.SIMPLIFIED_CHINESE.getCountry() : Locale.getDefault().getCountry();
                Locale locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), country, Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jRadioButtonMenuItem3ActionPerformed(ActionEvent evt) {
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.GERMAN.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.GERMAN.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jRadioButtonMenuItem4ActionPerformed(ActionEvent evt) {
        if (!Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.TRADITIONAL_CHINESE.getLanguage(), Locale.TRADITIONAL_CHINESE.getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jMenuItem13ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.DONATE_HTML));
    }

    private void jMenuItem14ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.CONTRIBUTE_HTML));
    }

    private void jRadioButtonMenuItem5ActionPerformed(ActionEvent evt) {
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.ITALIAN.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jMenuItem15ActionPerformed(ActionEvent evt) {
        this.refreshAllRealTimeStockMonitors();
        this.refreshRealTimeIndexMonitor();
        this.refreshExchangeRateMonitor();
        TradingView.getInstance().refreshPortfolio();
        if (!this.getStocks().isEmpty()) {
            this.setStatusBar(true, GUIBundle.getString("MainFrame_RefreshStockPrices..."));
            this.refreshPriceInProgress = true;
        }
    }

    private void jMenuItem16ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.HELP_KEYBOARD_SHORTCUTS_HTML));
    }

    private void jMenuItem17ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.ANDROID_HTML));
    }

    private void jRadioButtonMenuItem6ActionPerformed(ActionEvent evt) {
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.FRENCH.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.FRENCH.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            }
        }
    }

    private void jMenu6MenuSelected(MenuEvent evt) {
        this.initRecentCountryMenuItems();
    }

    private void jMenuItem18ActionPerformed(ActionEvent evt) {
        File file = Utils.promptSaveZippedJFileChooser("jstock.zip");
        if (file == null) {
            return;
        }
        if ((file = SaveToCloudJDialog.getJStockZipFile(file.getAbsolutePath())) != null) {
            JOptionPane.showMessageDialog(null, MessagesBundle.getString("info_message_export_successfully"));
        }
    }

    private void jMenuItem19ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.WENOTE_HTML));
    }

    public void selectActiveWatchlist(String watchlist) {
        assert (SwingUtilities.isEventDispatchThread());
        this.saveWatchlist();
        this._saveGUIOptions();
        this.getJStockOptions().setWatchlistName(watchlist);
        this.initWatchlist();
        this.jTabbedPane1.setSelectedIndex(0);
        this.setStatusBar(false, this.getBestStatusBarMessage());
    }

    public void selectActivePortfolio(String portfolio) {
        assert (SwingUtilities.isEventDispatchThread());
        this.portfolioManagementJPanel.savePortfolio();
        this.portfolioManagementJPanel.saveGUIOptions();
        this.getJStockOptions().setPortfolioName(portfolio);
        this.portfolioManagementJPanel.initPortfolio();
        this.jTabbedPane1.setSelectedIndex(3);
        this.portfolioManagementJPanel.updateTitledBorder();
        this.setStatusBar(false, this.getBestStatusBarMessage());
    }

    private void multipleWatchlists() {
        WatchlistJDialog watchlistJDialog = new WatchlistJDialog((Frame)this, true);
        watchlistJDialog.setLocationRelativeTo(this);
        watchlistJDialog.setVisible(true);
    }

    private void multiplePortfolios() {
        PortfolioJDialog portfolioJDialog = new PortfolioJDialog((Frame)this, true);
        portfolioJDialog.setLocationRelativeTo(this);
        portfolioJDialog.setVisible(true);
    }

    private static boolean saveAsCSVFile(CSVWatchlist csvWatchlist, File file, boolean languageIndependent) {
        Statements statements = Statements.newInstanceFromTableModel(csvWatchlist.tableModel, languageIndependent);
        assert (statements != null);
        return statements.saveAsCSVFile(file);
    }

    private boolean saveAsCSVFile(File file, boolean languageIndependent) {
        TableModel tableModel = this.jTable1.getModel();
        CSVWatchlist csvWatchlist = CSVWatchlist.newInstance(tableModel);
        return JStock.saveAsCSVFile(csvWatchlist, file, languageIndependent);
    }

    private boolean saveAsExcelFile(File file) {
        TableModel tableModel = this.jTable1.getModel();
        Statements statements = Statements.newInstanceFromTableModel(tableModel, false);
        assert (statements != null);
        return statements.saveAsExcelFile(file, GUIBundle.getString("MainFrame_Title"));
    }

    private static JStockOptions getJStockOptionsViaXML() {
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.OptionsXml.get());
        JStockOptions jStockOptions = Utils.fromXML(JStockOptions.class, f);
        if (jStockOptions == null) {
            jStockOptions = new JStockOptions();
        }
        return jStockOptions;
    }

    public static void main(String[] args) {
        int choice;
        String lookNFeel;
        String className;
        final JStockOptions jStockOptions = JStock.getJStockOptionsViaXML();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        if (Utils.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.brushMetalLook", "true");
        }
        boolean uiManagerLookAndFeelSuccess = false;
        try {
            String lookNFeel2 = jStockOptions.getLooknFeel();
            if (null != lookNFeel2) {
                UIManager.setLookAndFeel(lookNFeel2);
                uiManagerLookAndFeelSuccess = true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exp) {
            log.error(null, (Throwable)exp);
        }
        if (!uiManagerLookAndFeelSuccess && null != (className = Utils.setDefaultLookAndFeel()) && (lookNFeel = jStockOptions.getLooknFeel()) != null) {
            jStockOptions.setLooknFeel(className);
        }
        Locale.setDefault(jStockOptions.getLocale());
        if (!AppLock.lock() && (choice = JOptionPane.showOptionDialog(null, MessagesBundle.getString("warning_message_running_2_jstock"), MessagesBundle.getString("warning_title_running_2_jstock"), 0, 2, null, new String[]{MessagesBundle.getString("yes_button_running_2_jstock"), MessagesBundle.getString("no_button_running_2_jstock")}, MessagesBundle.getString("no_button_running_2_jstock"))) != 0) {
            System.exit(0);
            return;
        }
        Platform.setImplicitExit((boolean)false);
        ProxyDetector.getInstance();
        if (jStockOptions.useLargeFont()) {
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (value == null || !(value instanceof FontUIResource)) continue;
                FontUIResource fr = (FontUIResource)value;
                UIManager.put(key, new FontUIResource(fr.deriveFont(fr.getSize2D() * 1.2f)));
            }
        }
        GA.trackAsynchronously("main");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JStock mainFrame = JStock.instance();
                mainFrame.initJStockOptions(jStockOptions);
                mainFrame.init();
                mainFrame.setVisible(true);
                mainFrame.updateDividerLocation();
                mainFrame.requestFocusOnJComboBox();
            }
        });
    }

    private void updateDividerLocation() {
        this.portfolioManagementJPanel.updateDividerLocation();
    }

    private void clearAllStocks() {
        if (this.stockCodeHistoryGUI != null) {
            this.stockCodeHistoryGUI.clear();
        }
        if (this.realTimeStockMonitor != null) {
            this.realTimeStockMonitor.clearStockCodes();
        }
        if (this.stockHistoryMonitor != null) {
            this.stockHistoryMonitor.clearStockCodes();
        }
        final StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        this.initAlertStateManager();
        if (EventQueue.isDispatchThread()) {
            tableModel.clearAllStocks();
            this.updateDynamicChart(null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tableModel.clearAllStocks();
                    JStock.this.updateDynamicChart(null);
                }
            });
        }
        if (this.stockCodeHistoryGUI != null && this.stockCodeHistoryGUI.isEmpty() && this.stockInfoDatabase != null) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
        }
    }

    private void deteleSelectedTableRow() {
        assert (EventQueue.isDispatchThread());
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        int[] rows = this.jTable1.getSelectedRows();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            if (row < 0) continue;
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            Stock stock = tableModel.getStock(modelIndex);
            this.stockCodeHistoryGUI.remove(stock.code);
            this.realTimeStockMonitor.removeStockCode(stock.code);
            this.stockHistoryMonitor.removeStockCode(stock.code);
            tableModel.removeRow(modelIndex);
            this.alertStateManager.clearState(stock);
        }
        this.updateDynamicChart(null);
        if (this.stockCodeHistoryGUI.isEmpty() && this.stockInfoDatabase != null) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
        }
    }

    public void setStatusBarExchangeRate(final Double exchangeRate) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusBar.setExchangeRate(exchangeRate);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JStock.this.statusBar.setExchangeRate(exchangeRate);
                }
            });
        }
    }

    public void setStatusBarExchangeRateVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusBar.setExchangeRateVisible(visible);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JStock.this.statusBar.setExchangeRateVisible(visible);
                }
            });
        }
    }

    public void setStatusBarExchangeRateToolTipText(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusBar.setExchangeRateToolTipText(text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JStock.this.statusBar.setExchangeRateToolTipText(text);
                }
            });
        }
    }

    public void setStatusBar(final boolean progressBar, final String mainMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.isStatusBarBusy = progressBar;
            this.statusBar.setProgressBar(progressBar);
            this.statusBar.setMainMessage(mainMessage);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JStock.this.isStatusBarBusy = progressBar;
                    JStock.this.statusBar.setProgressBar(progressBar);
                    JStock.this.statusBar.setMainMessage(mainMessage);
                }
            });
        }
    }

    private void _setAlwaysOnTop(boolean alwaysOnTop) {
        this.setAlwaysOnTop(alwaysOnTop);
        this.jStockOptions.setAlwaysOnTop(alwaysOnTop);
        this.alwaysOnTopMenuItem.setSelected(alwaysOnTop);
    }

    private void setLookAndFeel(String lafClassName) {
        boolean uiManagerLookAndFeelSuccess = false;
        String realLafClassName = null;
        try {
            if (lafClassName == null) {
                String className = Utils.setDefaultLookAndFeel();
                if (className != null) {
                    SwingUtilities.updateComponentTreeUI(this);
                    realLafClassName = className;
                    uiManagerLookAndFeelSuccess = true;
                }
            } else {
                UIManager.setLookAndFeel(lafClassName);
                SwingUtilities.updateComponentTreeUI(this);
                realLafClassName = lafClassName;
                uiManagerLookAndFeelSuccess = true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exp) {
            log.error(null, (Throwable)exp);
        }
        if (uiManagerLookAndFeelSuccess) {
            this.jStockOptions.setLooknFeel(lafClassName);
            Enumeration<AbstractButton> e = this.buttonGroup1.getElements();
            while (e.hasMoreElements()) {
                AbstractButton button = e.nextElement();
                JRadioButtonMenuItem m = (JRadioButtonMenuItem)button;
                ChangeLookAndFeelAction a = (ChangeLookAndFeelAction)m.getActionListeners()[0];
                if (!a.getLafClassName().equals(realLafClassName)) continue;
                m.setSelected(true);
                break;
            }
            ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(this.stockInfoDatabase);
            this.indicatorPanel.setStockInfoDatabase(this.stockInfoDatabase);
        }
    }

    public PortfolioManagementJPanel getPortfolioManagementJPanel() {
        return this.portfolioManagementJPanel;
    }

    private void createPortfolioManagementJPanel() {
        this.portfolioManagementJPanel = new PortfolioManagementJPanel();
        this.jTabbedPane1.addTab(GUIBundle.getString("PortfolioManagementJPanel_Title"), this.portfolioManagementJPanel);
    }

    public TradingJPanel getTradingJPanel() {
        return this.tradingJPanel;
    }

    private void createStockIndicatorEditor() {
        this.indicatorPanel = new IndicatorPanel();
        this.jTabbedPane1.addTab(GUIBundle.getString("IndicatorPanel_Title"), this.indicatorPanel);
    }

    private void createIndicatorScannerJPanel() {
        this.indicatorScannerJPanel = new IndicatorScannerJPanel();
        this.jTabbedPane1.addTab(GUIBundle.getString("IndicatorScannerJPanel_Title"), this.indicatorScannerJPanel);
        this.jTabbedPane1.addChangeListener(this.indicatorScannerJPanel);
    }

    private void createIconsAndToolTipTextForJTabbedPane() {
        this.jTabbedPane1.setIconAt(0, this.getImageIcon("/images/16x16/stock_timezone.png"));
        this.jTabbedPane1.setIconAt(1, this.getImageIcon("/images/16x16/color_line.png"));
        this.jTabbedPane1.setIconAt(2, this.getImageIcon("/images/16x16/find.png"));
        this.jTabbedPane1.setIconAt(3, this.getImageIcon("/images/16x16/calc.png"));
        this.jTabbedPane1.setToolTipTextAt(0, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_WatchYourFavoriteStockMovement"));
        this.jTabbedPane1.setToolTipTextAt(1, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_CustomizeYourOwnStockIndicatorForAlertPurpose"));
        this.jTabbedPane1.setToolTipTextAt(2, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_ScanThroughTheEntireStockMarketSoThatYouWillBeInformedWhatToSellOrBuy"));
        this.jTabbedPane1.setToolTipTextAt(3, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_ManageYourRealTimePortfolioWhichEnableYouToTrackBuyAndSellRecords"));
    }

    private void initRecentCountryMenuItems() {
        Enumeration<AbstractButton> e = this.buttonGroup4.getElements();
        boolean hasSeperator = false;
        while (e.hasMoreElements()) {
            this.jMenu6.remove(e.nextElement());
            hasSeperator = true;
        }
        if (hasSeperator) {
            this.jMenu6.remove(0);
        }
        this.buttonGroup4 = new ButtonGroup();
        int index = 0;
        HashSet<Country> countries = new HashSet<Country>(Utils.getSupportedStockMarketCountries());
        for (final Country country : this.jStockOptions.getRecentCountries()) {
            if (!countries.contains((Object)country)) continue;
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu6.add((Component)new JRadioButtonMenuItem(country.humanString, country.icon), index++);
            this.buttonGroup4.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JStock.this.changeCountry(country);
                }
            });
            if (this.jStockOptions.getCountry() != country) continue;
            mi.setSelected(true);
        }
        if (index > 0) {
            this.jMenu6.add((Component)new JPopupMenu.Separator(), index++);
        }
    }

    public void rebuildCountryMenuItems(boolean useCache) {
        List<Country> countries = Utils.getSupportedStockMarketCountries(useCache);
        this.jMenu6.removeAll();
        Enumeration<AbstractButton> e = this.buttonGroup2.getElements();
        while (e.hasMoreElements()) {
            this.buttonGroup2.remove(e.nextElement());
        }
        EnumMap<Continent, JMenu> menus = new EnumMap<Continent, JMenu>(Continent.class);
        for (Continent continent : Continent.values()) {
            JMenu jMenu = new JMenu(continent.name());
            this.jMenu6.add(jMenu);
            menus.put(continent, jMenu);
        }
        for (final Country country : countries) {
            JMenu jMenu = (JMenu)menus.get((Object)Continent.toContinent(country));
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)jMenu.add(new JRadioButtonMenuItem(country.humanString, country.icon));
            this.buttonGroup2.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JStock.this.changeCountry(country);
                }
            });
            if (this.jStockOptions.getCountry() != country) continue;
            mi.setSelected(true);
        }
    }

    public void createLookAndFeelMenuItems() {
        LookAndFeel currentlaf = UIManager.getLookAndFeel();
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafInfo.length; ++i) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu4.add(new JRadioButtonMenuItem(lafInfo[i].getName()));
            this.buttonGroup1.add(mi);
            mi.addActionListener(new ChangeLookAndFeelAction(this, lafInfo[i].getClassName()));
            if (currentlaf == null || !lafInfo[i].getClassName().equals(currentlaf.getClass().getName())) continue;
            mi.setSelected(true);
        }
        this.jMenu4.addSeparator();
        this.alwaysOnTopMenuItem = this.jMenu4.add(new JCheckBoxMenuItem(GUIBundle.getString("MainFrame_AlwaysOnTop")));
        this.alwaysOnTopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractButton aButton = (AbstractButton)e.getSource();
                boolean selected = aButton.getModel().isSelected();
                JStock.this._setAlwaysOnTop(selected);
            }
        });
    }

    private TableModelListener getTableModelListener() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                int mColIndex = e.getColumn();
                switch (e.getType()) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
        };
    }

    private Image getMyIconImage() {
        return new ImageIcon(this.getClass().getResource("/images/128x128/chart.png")).getImage();
    }

    private void createSystemTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = new ImageIcon(this.getClass().getResource("/images/128x128/chart.png")).getImage();
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        JStock.this.setVisible(true);
                        JStock.this.setState(0);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            };
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JStock.this.setVisible(false);
                    JStock.this.dispose();
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Exit"));
            defaultItem.addActionListener(exitListener);
            popup.add(defaultItem);
            this.trayIcon = new TrayIcon(image, GUIBundle.getString("MainFrame_Application_Title"), popup);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(actionListener);
            this.trayIcon.addMouseListener(mouseListener);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                this.trayIcon = null;
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_message_trayicon_could_not_be_added"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_title_trayicon_could_not_be_added"), 2);
            }
        } else {
            this.trayIcon = null;
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_message_system_tray_is_not_supported"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_title_system_tray_is_not_supported"), 2);
        }
    }

    private void initTableHeaderToolTips() {
        JTableHeader header = this.jTable1.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.jTable1.getColumn(GUIBundle.getString("MainFrame_FallBelow")), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_AlertUserWhenLastPriceFallBelowOrEqualToSpecifiedValue"));
        tips.setToolTip(this.jTable1.getColumn(GUIBundle.getString("MainFrame_RiseAbove")), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_AlertUserWhenLastPriceFallAboveOrEqualToSpecifiedValue"));
        header.addMouseMotionListener(tips);
    }

    public void commitBeforeLoadFromCloud() {
        this.save();
    }

    public void commitBeforeSaveToCloud() {
        StockInfoDatabase stock_info_database;
        Country country = this.jStockOptions.getCountry();
        if (!Utils.isFileOrDirectoryExist(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.xml") && (stock_info_database = this.stockInfoDatabase) != null) {
            this.saveUserDefinedDatabaseAsCSV(country, stock_info_database);
        }
        this.save();
        this.solveCaseSensitiveFoldersIssue();
        this.saveWatchlistAndPortfolioInfos();
        this.saveBrokingFirmsAsJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveBrokingFirmsAsJson() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "android")) {
            return false;
        }
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        String string = gson.toJson(this.getJStockOptions().getBrokingFirms());
        File brokingFirmsFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "brokingfirms.json");
        ThreadSafeFileLock.Lock lock = ThreadSafeFileLock.getLock(brokingFirmsFile);
        if (lock == null) {
            return false;
        }
        ThreadSafeFileLock.lockWrite(lock);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(brokingFirmsFile), "UTF-8"));){
            writer.write(string);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        return true;
    }

    private void solveCaseSensitiveFoldersIssue() {
        String newDirectory;
        String originalDirectory;
        String newName;
        String originalName;
        int i;
        int ei;
        HashSet<String> lowerCaseNames;
        ArrayList<ArrayList<String>> duplicatedNames;
        Country currentCountry = this.jStockOptions.getCountry();
        String currentWatchlist = this.jStockOptions.getWatchlistName();
        String currentPortfolio = this.jStockOptions.getPortfolioName();
        for (Country country : Country.values()) {
            List<String> watchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames(country);
            HashMap<String, ArrayList<String>> watchlistNamesMap = new HashMap<String, ArrayList<String>>();
            duplicatedNames = new ArrayList<ArrayList<String>>();
            lowerCaseNames = new HashSet<String>();
            for (String string : watchlistNames) {
                String lowerCaseWatchlistName = string.toLowerCase();
                lowerCaseNames.add(lowerCaseWatchlistName);
                ArrayList<String> names = (ArrayList<String>)watchlistNamesMap.get(lowerCaseWatchlistName);
                if (names == null) {
                    names = new ArrayList<String>();
                    watchlistNamesMap.put(lowerCaseWatchlistName, names);
                }
                names.add(string);
                if (names.size() <= 1) continue;
                duplicatedNames.add(names);
            }
            for (List list : duplicatedNames) {
                int counter = 0;
                boolean originalNameUsed = false;
                ei = list.size();
                for (i = 0; i < ei; ++i) {
                    originalName = (String)list.get(i);
                    if (currentCountry == country && currentWatchlist.equals(originalName)) {
                        originalNameUsed = true;
                        continue;
                    }
                    newName = originalName;
                    if (originalNameUsed || i < ei - 1) {
                        newName = originalName + counter++;
                        while (lowerCaseNames.contains(newName.toLowerCase())) {
                            newName = originalName + counter++;
                        }
                        lowerCaseNames.add(newName.toLowerCase());
                    } else {
                        originalNameUsed = true;
                    }
                    originalDirectory = org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(country, originalName);
                    newDirectory = org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(country, newName);
                    if (originalDirectory.equalsIgnoreCase(newDirectory)) continue;
                    new File(originalDirectory).renameTo(new File(newDirectory));
                }
            }
        }
        for (Country country : Country.values()) {
            List<String> portfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames(country);
            HashMap<String, ArrayList<String>> portfolioNamesMap = new HashMap<String, ArrayList<String>>();
            duplicatedNames = new ArrayList();
            lowerCaseNames = new HashSet();
            for (String string : portfolioNames) {
                String lowerCasePortfolioName = string.toLowerCase();
                lowerCaseNames.add(lowerCasePortfolioName);
                ArrayList<String> names = (ArrayList<String>)portfolioNamesMap.get(lowerCasePortfolioName);
                if (names == null) {
                    names = new ArrayList<String>();
                    portfolioNamesMap.put(lowerCasePortfolioName, names);
                }
                names.add(string);
                if (names.size() <= 1) continue;
                duplicatedNames.add(names);
            }
            for (List list : duplicatedNames) {
                int counter = 0;
                boolean originalNameUsed = false;
                ei = list.size();
                for (i = 0; i < ei; ++i) {
                    originalName = (String)list.get(i);
                    if (currentCountry == country && currentPortfolio.equals(originalName)) {
                        originalNameUsed = true;
                        continue;
                    }
                    newName = originalName;
                    if (originalNameUsed || i < ei - 1) {
                        newName = originalName + counter++;
                        while (lowerCaseNames.contains(newName.toLowerCase())) {
                            newName = originalName + counter++;
                        }
                        lowerCaseNames.add(newName.toLowerCase());
                    } else {
                        originalNameUsed = true;
                    }
                    originalDirectory = org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory(country, originalName);
                    newDirectory = org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory(country, newName);
                    if (originalDirectory.equalsIgnoreCase(newDirectory)) continue;
                    new File(originalDirectory).renameTo(new File(newDirectory));
                }
            }
        }
    }

    private boolean saveWatchlistAndPortfolioInfos() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "android")) {
            return false;
        }
        List<WatchlistInfo> watchlistInfos = org.yccheok.jstock.watchlist.Utils.getWatchlistInfos();
        List<PortfolioInfo> portfolioInfos = org.yccheok.jstock.portfolio.Utils.getPortfolioInfos();
        File watchlistInfosFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "watchlistinfos.csv");
        File portfolioInfosFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "portfolioinfos.csv");
        boolean result0 = Statements.newInstanceFromWatchlistInfos(watchlistInfos).saveAsCSVFile(watchlistInfosFile);
        boolean result1 = Statements.newInstanceFromPortfolioInfos(portfolioInfos).saveAsCSVFile(portfolioInfosFile);
        return result0 && result1;
    }

    private Country getBestCountryAfterDownloadFromCloud() {
        Component selectedComponent;
        File portfolioInfosFile;
        Statements portfolioInfos;
        Country country = this.jStockOptions.getCountry();
        Country watchlistCountry = null;
        Country portfolioCountry = null;
        int watchlistMaxSize = 0;
        int portfolioMaxSize = 0;
        File watchlistInfosFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "watchlistinfos.csv");
        Statements watchlistInfos = Statements.newInstanceFromCSVFile(watchlistInfosFile);
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        if (watchlistInfos.getType() == Statement.Type.WatchlistInfos) {
            int ei = watchlistInfos.size();
            for (int i = 0; i < ei; ++i) {
                int watchlistSize;
                Country c;
                Statement statement = watchlistInfos.get(i);
                String countryString = statement.getValueAsString(guiBundleWrapper.getString("WatchlistInfo_Country"));
                try {
                    c = Country.valueOf(countryString);
                }
                catch (IllegalArgumentException ex) {
                    log.error(null, (Throwable)ex);
                    continue;
                }
                assert (c != null);
                if (c == country) {
                    return c;
                }
                Double _watchlistSize = statement.getValueAsDouble(guiBundleWrapper.getString("WatchlistInfo_Size"));
                if (_watchlistSize == null || (watchlistSize = (int)_watchlistSize.doubleValue()) <= watchlistMaxSize) continue;
                watchlistMaxSize = watchlistSize;
                watchlistCountry = c;
            }
        }
        if ((portfolioInfos = Statements.newInstanceFromCSVFile(portfolioInfosFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "portfolioinfos.csv"))).getType() == Statement.Type.PortfolioInfos) {
            int ei = portfolioInfos.size();
            for (int i = 0; i < ei; ++i) {
                int portfolioSize;
                Country c;
                Statement statement = portfolioInfos.get(i);
                String countryString = statement.getValueAsString(guiBundleWrapper.getString("PortfolioInfo_Country"));
                try {
                    c = Country.valueOf(countryString);
                }
                catch (IllegalArgumentException ex) {
                    log.error(null, (Throwable)ex);
                    continue;
                }
                assert (c != null);
                if (c == country) {
                    return c;
                }
                Double _portfolioSize = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioInfo_Size"));
                if (_portfolioSize == null || (portfolioSize = (int)_portfolioSize.doubleValue()) <= portfolioMaxSize) continue;
                portfolioMaxSize = portfolioSize;
                portfolioCountry = c;
            }
        }
        if ((selectedComponent = this.jTabbedPane1.getSelectedComponent()) == this.jPanel8) {
            if (watchlistCountry != null) {
                return watchlistCountry;
            }
        } else if (selectedComponent == this.portfolioManagementJPanel) {
            if (portfolioCountry != null) {
                return portfolioCountry;
            }
        } else if (watchlistMaxSize > portfolioMaxSize) {
            if (watchlistCountry != null) {
                return watchlistCountry;
            }
        } else if (portfolioCountry != null) {
            return portfolioCountry;
        }
        return country;
    }

    public void reloadAfterDownloadFromCloud(JStockOptions newJStockOptions) {
        String oldLookNFeel = this.jStockOptions.getLooknFeel();
        assert (newJStockOptions != null);
        this.jStockOptions.insensitiveCopy(newJStockOptions);
        String newLookNFeel = this.jStockOptions.getLooknFeel();
        if (oldLookNFeel != null) {
            if (!oldLookNFeel.equals(newLookNFeel)) {
                this.setLookAndFeel(newLookNFeel);
            }
        } else if (null != newLookNFeel) {
            this.setLookAndFeel(newLookNFeel);
        }
        Utils.updateFactoriesPriceSource();
        this.jStockOptions.setCountry(this.getBestCountryAfterDownloadFromCloud());
        this.rebuildCountryMenuItems(false);
        this.statusBar.setCountryIcon(this.jStockOptions.getCountry().icon, this.jStockOptions.getCountry().humanString);
        this.portfolioManagementJPanel.initPortfolio();
        this.indicatorScannerJPanel.stop();
        this.indicatorScannerJPanel.clear();
        this.initDatabase(true);
        this.initAjaxProvider();
        this.initRealTimeIndexMonitor();
        this.initMarketJPanel();
        this.initStockHistoryMonitor();
        this.initOthersStockHistoryMonitor();
        this.initExchangeRateMonitor();
        this.initRealTimeStockMonitor();
        this.initWatchlist();
        this.initAlertStateManager();
        this.initDynamicCharts();
        this.initDynamicChartVisibility();
        this.initAlwaysOnTop();
        Enumeration<AbstractButton> e = this.buttonGroup2.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            JRadioButtonMenuItem m = (JRadioButtonMenuItem)button;
            if (!m.getText().equals(this.jStockOptions.getCountry().humanString)) continue;
            m.setSelected(true);
            break;
        }
        if (null != this.indicatorPanel) {
            this.indicatorPanel.initIndicatorProjectManager();
            this.indicatorPanel.initModuleProjectManager();
        }
        this.initGUIOptions();
        this.indicatorScannerJPanel.initGUIOptions();
    }

    private void changeCountry(Country country) {
        if (country == null) {
            return;
        }
        if (this.jStockOptions.getCountry() == country) {
            return;
        }
        org.yccheok.jstock.engine.Utils.clearGoogleCodeDatabaseCache();
        org.yccheok.jstock.engine.Utils.clearAllIEXStockInfoDatabaseCaches();
        Country oldCountry = this.jStockOptions.getCountry();
        if (this.needToSaveUserDefinedDatabase) {
            this.saveUserDefinedDatabaseAsCSV(oldCountry, this.stockInfoDatabase);
        }
        this.saveGUIOptions();
        this.saveWatchlist();
        this.portfolioManagementJPanel.savePortfolio();
        this.jStockOptions.setCountry(country);
        this.jStockOptions.addRecentCountry(country);
        this.statusBar.setCountryIcon(country.icon, country.humanString);
        this.portfolioManagementJPanel.initPortfolio();
        this.indicatorScannerJPanel.stop();
        this.indicatorScannerJPanel.clear();
        this.initGoogleCodeDatabaseRunnable();
        this.initDatabase(true);
        this.initAjaxProvider();
        this.initRealTimeIndexMonitor();
        this.initMarketJPanel();
        this.initStockHistoryMonitor();
        this.initOthersStockHistoryMonitor();
        this.initExchangeRateMonitor();
        this.initRealTimeStockMonitor();
        this.initWatchlist();
        this.initAlertStateManager();
        this.initDynamicCharts();
        Enumeration<AbstractButton> e = this.buttonGroup2.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            JRadioButtonMenuItem m = (JRadioButtonMenuItem)button;
            if (country == Country.UnitedState && m.getText().equals(country.toString() + "s")) {
                m.setSelected(true);
                break;
            }
            if (!m.getText().equals(country.toString())) continue;
            m.setSelected(true);
            break;
        }
    }

    private MouseAdapter getMyJXStatusBarExchangeRateLabelMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OptionsJDialog optionsJDialog = new OptionsJDialog((Frame)JStock.this, true);
                    optionsJDialog.setLocationRelativeTo(JStock.this);
                    optionsJDialog.set(JStock.this.jStockOptions);
                    optionsJDialog.select(GUIBundle.getString("OptionsJPanel_Wealth"));
                    optionsJDialog.setVisible(true);
                }
            }
        };
    }

    private MouseAdapter getMyJXStatusBarCountryLabelMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CountryJDialog countryJDialog = new CountryJDialog((Frame)JStock.this, true);
                    countryJDialog.setLocationRelativeTo(JStock.this);
                    countryJDialog.setCountry(JStock.this.jStockOptions.getCountry());
                    countryJDialog.setVisible(true);
                    Country country = countryJDialog.getCountry();
                    JStock.this.changeCountry(country);
                }
            }
        };
    }

    private MouseAdapter getMyJXStatusBarImageLabelMouseAdapter() {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DatabaseTask task = JStock.this.databaseTask;
                    if (task != null) {
                        if (task.isDone()) {
                            boolean success = false;
                            if (!task.isCancelled()) {
                                try {
                                    success = (Boolean)task.get();
                                }
                                catch (InterruptedException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                                catch (ExecutionException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                                catch (CancellationException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                            }
                            if (!success) {
                                JStock.this.initDatabase(true);
                            } else {
                                int result = JOptionPane.showConfirmDialog(JStock.this, MessagesBundle.getString("question_message_perform_server_reconnecting"), MessagesBundle.getString("question_title_perform_server_reconnecting"), 0, 3);
                                if (result == 0) {
                                    JStock.this.initDatabase(false);
                                }
                            }
                        } else {
                            int result = JOptionPane.showConfirmDialog(JStock.this, MessagesBundle.getString("question_message_cancel_server_reconnecting"), MessagesBundle.getString("question_title_cancel_server_reconnecting"), 0, 3);
                            if (result == 0) {
                                Object object = JStock.this.databaseTaskMonitor;
                                synchronized (object) {
                                    JStock.this.databaseTask.cancel(true);
                                    JStock.this.databaseTask = null;
                                }
                                JStock.this.setStatusBar(false, GUIBundle.getString("MainFrame_NetworkError"));
                                JStock.this.statusBar.setImageIcon(JStock.this.getImageIcon("/images/16x16/network-error.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_DoubleClickedToTryAgain"));
                            }
                        }
                    } else {
                        JStock.this.initDatabase(true);
                    }
                }
            }
        };
    }

    public StockInfoDatabase getStockInfoDatabase() {
        return this.stockInfoDatabase;
    }

    public StockNameDatabase getStockNameDatabase() {
        return this.stockNameDatabase;
    }

    public List<Stock> getStocks() {
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        return tableModel.getStocks();
    }

    public void addStockToTable(final Stock stock, final StockAlert alert) {
        final JTable _jTable1 = this.jTable1;
        if (EventQueue.isDispatchThread()) {
            StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
            tableModel.addStock(stock, alert);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
                    tableModel.addStock(stock, alert);
                }
            });
        }
    }

    public void addStockToTable(final Stock stock) {
        final JTable _jTable1 = this.jTable1;
        if (EventQueue.isDispatchThread()) {
            StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
            tableModel.addStock(stock);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
                    tableModel.addStock(stock);
                }
            });
        }
    }

    private boolean isStockBeingSelected(Stock stock) {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length == 1) {
            int row = rows[0];
            StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
            int modelIndex = this.jTable1.convertRowIndexToModel(row);
            if (stock.code.equals(tableModel.getStock((int)modelIndex).code)) {
                return true;
            }
        }
        return false;
    }

    private Stock getSelectedStock() {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length == 1) {
            int row = rows[0];
            StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
            int modelIndex = this.jTable1.convertRowIndexToModel(row);
            return tableModel.getStock(modelIndex);
        }
        return null;
    }

    private void updateStockToTable(Stock stock) {
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        tableModel.updateStock(stock);
    }

    private void update(final Indicator indicator, Boolean result) {
        Runnable r;
        boolean flag = result;
        if (!flag) {
            return;
        }
        StockTableModel stockTableModel = (StockTableModel)this.jTable1.getModel();
        final Stock stock = indicator.getStock();
        final Double price = ((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow") ? stockTableModel.getFallBelow(stock) : stockTableModel.getRiseAbove(stock);
        final double lastPrice = stock.getLastPrice();
        if (lastPrice <= 0.0) {
            return;
        }
        if (this.jStockOptions.isPopupMessage()) {
            r = new Runnable(){

                @Override
                public void run() {
                    String template;
                    String message = "";
                    if (((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow")) {
                        template = GUIBundle.getString("MainFrame_FallBelow_template");
                        message = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    } else {
                        template = GUIBundle.getString("MainFrame_RiseAbove_template");
                        message = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    }
                    if (JStock.this.jStockOptions.isPopupMessage()) {
                        JStock.this.displayPopupMessage(stock.symbol.toString(), message);
                        if (JStock.this.jStockOptions.isSoundEnabled()) {
                            Utils.playAlertSound();
                        }
                        try {
                            Thread.sleep(JStock.this.jStockOptions.getAlertSpeed() * 1000);
                        }
                        catch (InterruptedException exp) {
                            log.error(null, (Throwable)exp);
                        }
                    }
                }
            };
            try {
                this.systemTrayAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (!this.jStockOptions.isPopupMessage() && this.jStockOptions.isSoundEnabled()) {
            r = new Runnable(){

                @Override
                public void run() {
                    if (JStock.this.jStockOptions.isSoundEnabled()) {
                        Utils.playAlertSound();
                        try {
                            Thread.sleep(JStock.this.jStockOptions.getAlertSpeed() * 1000);
                        }
                        catch (InterruptedException exp) {
                            log.error(null, (Throwable)exp);
                        }
                    }
                }
            };
            try {
                this.systemTrayAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (this.jStockOptions.isSendEmail()) {
            r = new Runnable(){

                @Override
                public void run() {
                    String template;
                    String title = "";
                    if (((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow")) {
                        template = GUIBundle.getString("MainFrame_FallBelow_template");
                        title = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    } else {
                        template = GUIBundle.getString("MainFrame_RiseAbove_template");
                        title = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    }
                    String message = title + "\n(JStock)";
                    String ccEmail = Utils.decrypt(JStock.this.jStockOptions.getCCEmail());
                    try {
                        GoogleMail.Send(ccEmail, title, message);
                    }
                    catch (Exception ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
            };
            try {
                this.emailAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
    }

    private void highlightStock(int modelRow) {
        if (modelRow < 0) {
            return;
        }
        int row = this.jTable1.convertRowIndexToView(modelRow);
        this.jTable1.getSelectionModel().setSelectionInterval(row, row);
        JTableUtilities.scrollToVisible(this.jTable1, row, 0);
    }

    private Observer<AutoCompleteJComboBox, DispType> getDispObserver() {
        return new Observer<AutoCompleteJComboBox, DispType>(){

            @Override
            public void update(AutoCompleteJComboBox subject, DispType dispType) {
                assert (dispType != null);
                Code code = Code.newInstance(dispType.getDispCode());
                Symbol symbol = Symbol.newInstance(dispType.getDispName());
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                JStock.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
            }
        };
    }

    private Observer<AutoCompleteJComboBox, StockInfo> getStockInfoObserver() {
        return new Observer<AutoCompleteJComboBox, StockInfo>(){

            @Override
            public void update(AutoCompleteJComboBox subject, StockInfo stockInfo) {
                assert (stockInfo != null);
                JStock.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
            }
        };
    }

    private void addStockInfoFromAutoCompleteJComboBox(StockInfo stockInfo) {
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        Stock emptyStock = org.yccheok.jstock.engine.Utils.getEmptyStock(stockInfo);
        this.addStockToTable(emptyStock);
        int row = tableModel.findRow(emptyStock);
        this.realTimeStockMonitor.addStockCode(stockInfo.code);
        this.realTimeStockMonitor.startNewThreadsIfNecessary();
        this.realTimeStockMonitor.refresh();
        this.highlightStock(row);
    }

    private Observer<Indicator, Boolean> getAlertStateManagerObserver() {
        return new Observer<Indicator, Boolean>(){

            @Override
            public void update(Indicator subject, Boolean arg) {
                JStock.this.update(subject, arg);
            }
        };
    }

    private Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result>(){

            @Override
            public void update(RealTimeStockMonitor monitor, RealTimeStockMonitor.Result result) {
                JStock.this.update(monitor, result);
            }
        };
    }

    private Observer<RealTimeIndexMonitor, List<Market>> getRealTimeIndexMonitorObserver() {
        return new Observer<RealTimeIndexMonitor, List<Market>>(){

            @Override
            public void update(RealTimeIndexMonitor monitor, List<Market> markets) {
                JStock.this.update(markets);
            }
        };
    }

    private Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> getStockHistoryMonitorObserver() {
        return new Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable>(){

            @Override
            public void update(StockHistoryMonitor monitor, StockHistoryMonitor.StockHistoryRunnable runnable) {
                JStock.this.update(monitor, runnable);
            }
        };
    }

    public void displayHistoryChart(StockInfo stockInfo) {
        StockHistoryServer stockHistoryServer = this.stockHistoryMonitor.getStockHistoryServer(stockInfo.code);
        if (stockHistoryServer == null) {
            if (this.stockCodeHistoryGUI.add(stockInfo.code) && this.stockHistoryMonitor.addStockCode(stockInfo.code)) {
                String template = GUIBundle.getString("MainFrame_LookingForHistory_template");
                String message = MessageFormat.format(template, stockInfo.symbol, this.stockCodeHistoryGUI.size());
                this.setStatusBar(true, message);
            }
        } else {
            ChartJDialog chartJDialog = new ChartJDialog(this, stockInfo.symbol + " (" + stockInfo.code + ")", false, stockHistoryServer);
            chartJDialog.setVisible(true);
        }
    }

    public void displayHistoryCharts() {
        int[] rows = this.jTable1.getSelectedRows();
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        for (int row : rows) {
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            Stock stock = tableModel.getStock(modelIndex);
            this.displayHistoryChart(StockInfo.newInstance(stock));
        }
    }

    public void displayStockNews(StockInfo stockInfo) {
        assert (SwingUtilities.isEventDispatchThread());
        String title = stockInfo.symbol + " (" + stockInfo.code + ")";
        StockNewsJFrame stockNewsJFrame = new StockNewsJFrame(this, stockInfo, title);
    }

    private void displayStocksNews() {
        int[] rows = this.jTable1.getSelectedRows();
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        for (int row : rows) {
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            Stock stock = tableModel.getStock(modelIndex);
            this.displayStockNews(StockInfo.newInstance(stock));
        }
    }

    private JPopupMenu getMyJTablePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        final TableModel tableModel = this.jTable1.getModel();
        JMenuItem menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.displayHistoryCharts();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_News..."), this.getImageIcon("/images/16x16/news.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.displayStocksNews();
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        if (this.jTable1.getSelectedRowCount() == 1) {
            menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Buy..."), this.getImageIcon("/images/16x16/calc.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = JStock.this.jTable1.getSelectedRow();
                    int modelIndex = JStock.this.jTable1.getRowSorter().convertRowIndexToModel(row);
                    Stock stock = ((StockTableModel)tableModel).getStock(modelIndex);
                    JStock.this.portfolioManagementJPanel.showNewBuyTransactionJDialog(StockInfo.newInstance(stock), stock.getLastPrice(), false);
                }
            });
            popup.add(menuItem);
            int row = this.jTable1.getSelectedRow();
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            Stock stock = ((StockTableModel)tableModel).getStock(modelIndex);
            popup.addSeparator();
        }
        menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JStock.this.deteleSelectedTableRow();
            }
        });
        popup.add(menuItem);
        return popup;
    }

    private static boolean saveStockNameDatabaseAsCSV(Country country, StockNameDatabase stockNameDatabase) {
        File stockNameDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.csv");
        Statements statements = Statements.newInstanceFromStockNameDatabase(stockNameDatabase);
        boolean result = statements.saveAsCSVFile(stockNameDatabaseCSVFile);
        return result;
    }

    private static boolean saveStockInfoDatabaseAsCSV(Country country, StockInfoDatabase stockInfoDatabase) {
        Utils.createCompleteDirectoryHierarchyIfDoesNotExist(org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFileDirectory(country));
        File stockInfoDatabaseCSVFile = org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFile(country);
        Statements statements = Statements.newInstanceFromStockInfoDatabase(stockInfoDatabase);
        boolean result = statements.saveAsCSVFile(stockInfoDatabaseCSVFile);
        return result;
    }

    private boolean saveUserDefinedDatabaseAsCSV(Country country, StockInfoDatabase stockInfoDatabase) {
        List<Pair<Code, Symbol>> pairs = JStock.getUserDefinedPair(stockInfoDatabase);
        File userDefinedDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
        if (pairs.isEmpty() && userDefinedDatabaseCSVFile.delete()) {
            return true;
        }
        Statements statements = Statements.newInstanceFromUserDefinedDatabase(pairs);
        boolean result = statements.saveAsCSVFile(userDefinedDatabaseCSVFile);
        this.needToSaveUserDefinedDatabase = false;
        return result;
    }

    private List<Pair<Code, Symbol>> loadUserDefinedDatabaseFromCSV(Country country) {
        File userDefinedDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
        Statements statements = Statements.newInstanceFromCSVFile(userDefinedDatabaseCSVFile);
        if (statements.getType() != Statement.Type.UserDefinedDatabase) {
            return new ArrayList<Pair<Code, Symbol>>();
        }
        ArrayList<Pair<Code, Symbol>> pairs = new ArrayList<Pair<Code, Symbol>>();
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            Atom atom0 = statement.getAtom(0);
            Atom atom1 = statement.getAtom(1);
            Code code = Code.newInstance(atom0.getValue().toString());
            Symbol symbol = Symbol.newInstance(atom1.getValue().toString());
            pairs.add(new Pair<Code, Symbol>(code, symbol));
        }
        return pairs;
    }

    private StockNameDatabase loadStockNameDatabaseFromCSV(Country country) {
        File stockNameDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.csv");
        Statements statements = Statements.newInstanceFromCSVFile(stockNameDatabaseCSVFile);
        if (statements.getType() != Statement.Type.StockNameDatabase) {
            return null;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            Atom atom0 = statement.getAtom(0);
            Atom atom1 = statement.getAtom(1);
            Code code = Code.newInstance(atom0.getValue().toString());
            String name = atom1.getValue().toString();
            Stock stock = Stock.builder(code, Symbol.newInstance(code.toString())).name(name).build();
            stocks.add(stock);
        }
        return new StockNameDatabase(stocks);
    }

    private StockInfoDatabase loadStockInfoDatabaseFromCSV(Country country) {
        File stockInfoDatabaseCSVFile = org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFile(country);
        Statements statements = Statements.newInstanceFromCSVFile(stockInfoDatabaseCSVFile);
        if (statements.getType() != Statement.Type.StockInfoDatabase) {
            return null;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            Atom atom0 = statement.getAtom(0);
            Atom atom1 = statement.getAtom(1);
            Atom atom2 = statement.getAtom(2);
            Atom atom3 = statement.getAtom(3);
            Code code = Code.newInstance(atom0.getValue().toString());
            Symbol symbol = Symbol.newInstance(atom1.getValue().toString());
            Industry industry = Industry.Unknown;
            Board board = Board.Unknown;
            try {
                industry = Industry.valueOf(atom2.getValue().toString());
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
            }
            try {
                board = Board.valueOf(atom3.getValue().toString());
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
            }
            Stock stock = Stock.builder(code, symbol).board(board).industry(industry).build();
            stocks.add(stock);
        }
        return new StockInfoDatabase(stocks);
    }

    private void initMyJXStatusBarExchangeRateLabelMouseAdapter() {
        MouseAdapter mouseAdapter = this.getMyJXStatusBarExchangeRateLabelMouseAdapter();
        this.statusBar.addExchangeRateLabelMouseListener(mouseAdapter);
    }

    private void initMyJXStatusBarCountryLabelMouseAdapter() {
        MouseAdapter mouseAdapter = this.getMyJXStatusBarCountryLabelMouseAdapter();
        this.statusBar.addCountryLabelMouseListener(mouseAdapter);
    }

    private void initMyJXStatusBarImageLabelMouseAdapter() {
        MouseAdapter mouseAdapter = this.getMyJXStatusBarImageLabelMouseAdapter();
        this.statusBar.addImageLabelMouseListener(mouseAdapter);
    }

    public void initExchangeRateMonitor() {
        this.portfolioManagementJPanel.initExchangeRateMonitor();
    }

    private void initRealTimeIndexMonitor() {
        final RealTimeIndexMonitor oldRealTimeIndexMonitor = this.realTimeIndexMonitor;
        if (oldRealTimeIndexMonitor != null) {
            this.zombiePool.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeIndexMonitor + "..."));
                    oldRealTimeIndexMonitor.clearIndices();
                    oldRealTimeIndexMonitor.dettachAll();
                    oldRealTimeIndexMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeIndexMonitor + " peacefully."));
                }
            });
        }
        this.realTimeIndexMonitor = new RealTimeIndexMonitor(4, 20, this.jStockOptions.getScanningSpeed());
        this.realTimeIndexMonitor.attach(this.realTimeIndexMonitorObserver);
        for (Index index : org.yccheok.jstock.engine.Utils.getStockIndices(this.jStockOptions.getCountry())) {
            this.realTimeIndexMonitor.addIndex(index);
        }
        this.realTimeIndexMonitor.startNewThreadsIfNecessary();
    }

    private void initRealTimeStockMonitor() {
        final RealTimeStockMonitor oldRealTimeStockMonitor = this.realTimeStockMonitor;
        if (oldRealTimeStockMonitor != null) {
            this.zombiePool.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeStockMonitor + "..."));
                    oldRealTimeStockMonitor.clearStockCodes();
                    oldRealTimeStockMonitor.dettachAll();
                    oldRealTimeStockMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeStockMonitor + " peacefully."));
                }
            });
        }
        this.realTimeStockMonitor = new RealTimeStockMonitor(4, 20, this.jStockOptions.getScanningSpeed());
        this.realTimeStockMonitor.attach(this.realTimeStockMonitorObserver);
        this.indicatorScannerJPanel.initRealTimeStockMonitor();
        this.portfolioManagementJPanel.initRealTimeStockMonitor();
    }

    private void initUIOptions() {
        File file = new File(UserDataDirectory.Config.get() + UserDataFile.UIOptionsJson.get());
        this.uiOptions = Utils.fromJson(file, UIOptions.class);
        if (this.uiOptions == null) {
            this.uiOptions = new UIOptions();
        }
    }

    private void initGUIOptions() {
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.MainFrameXml.get());
        GUIOptions guiOptions = Utils.fromXML(GUIOptions.class, f);
        if (guiOptions == null) {
            JTableUtilities.removeTableColumn(this.jTable1, GUIBundle.getString("MainFrame_Open"));
            return;
        }
        if (guiOptions.getJTableOptionsSize() <= 0) {
            JTableUtilities.removeTableColumn(this.jTable1, GUIBundle.getString("MainFrame_Open"));
            return;
        }
        JTableUtilities.setJTableOptions(this.jTable1, guiOptions.getJTableOptions(0));
    }

    private void saveUIOptions() {
        File file = new File(UserDataDirectory.Config.get() + UserDataFile.UIOptionsJson.get());
        Utils.saveJson(file, this.uiOptions);
    }

    private void saveGUIOptions() {
        this._saveGUIOptions();
        this.indicatorScannerJPanel.saveGUIOptions();
        this.portfolioManagementJPanel.saveGUIOptions();
    }

    private boolean _saveGUIOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(UserDataDirectory.Config.get())) {
            return false;
        }
        GUIOptions.JTableOptions jTableOptions = new GUIOptions.JTableOptions();
        int count = this.jTable1.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = this.jTable1.getColumnName(i);
            TableColumn column = this.jTable1.getColumnModel().getColumn(i);
            jTableOptions.addColumnOption(GUIOptions.JTableOptions.ColumnOption.newInstance(name, column.getWidth()));
        }
        GUIOptions guiOptions = new GUIOptions();
        guiOptions.addJTableOptions(jTableOptions);
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.MainFrameXml.get());
        return Utils.toXML((Object)guiOptions, f);
    }

    private void initChartJDialogOptions() {
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.ChartJDialogOptionsXml.get());
        ChartJDialogOptions tmp = Utils.fromXML(ChartJDialogOptions.class, f);
        if (tmp == null) {
            this.chartJDialogOptions = new ChartJDialogOptions();
        } else {
            this.chartJDialogOptions = tmp;
            log.info((Object)("chartJDialogOptions loaded from " + f.toString() + " successfully."));
        }
    }

    public void initJStockOptions(JStockOptions jStockOptions) {
        this.jStockOptions = jStockOptions;
        if (this.jStockOptions.getScanningSpeed() == 0) {
            this.jStockOptions.setScanningSpeed(60000);
        }
        String proxyHost = this.jStockOptions.getProxyServer();
        int proxyPort = this.jStockOptions.getProxyPort();
        if (proxyHost.length() > 0 && org.yccheok.jstock.engine.Utils.isValidPortNumber(proxyPort)) {
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", "" + proxyPort);
        } else {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
        }
        Utils.updateFactoriesPriceSource();
    }

    public void updatePriceSource(Country country, PriceSource priceSource) {
        Factories.INSTANCE.updatePriceSource(country, priceSource);
        this.rebuildRealTimeStockMonitor();
        this.rebuildRealTimeIndexMonitor();
        this.indicatorScannerJPanel.rebuildRealTimeStockMonitor();
        this.portfolioManagementJPanel.rebuildRealTimeStockMonitor();
        this.refreshAllRealTimeStockMonitors();
        this.refreshRealTimeIndexMonitor();
        this.refreshExchangeRateMonitor();
    }

    private void rebuildRealTimeStockMonitor() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.rebuild();
        }
    }

    private void rebuildRealTimeIndexMonitor() {
        RealTimeIndexMonitor _realTimeIndexMonitor = this.realTimeIndexMonitor;
        if (_realTimeIndexMonitor != null) {
            _realTimeIndexMonitor.rebuild();
        }
    }

    private void initWatchlist() {
        this.timestamp = 0L;
        this.initCSVWatchlist();
    }

    private boolean initCSVWatchlist() {
        List<String> availableWatchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        if (availableWatchlistNames.size() <= 0) {
            org.yccheok.jstock.watchlist.Utils.createEmptyWatchlist(org.yccheok.jstock.watchlist.Utils.getDefaultWatchlistName());
            availableWatchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        }
        assert (!availableWatchlistNames.isEmpty());
        if (!availableWatchlistNames.contains(this.jStockOptions.getWatchlistName())) {
            this.jStockOptions.setWatchlistName(availableWatchlistNames.get(0));
        }
        this.clearAllStocks();
        File realTimeStockFile = org.yccheok.jstock.watchlist.Utils.getWatchlistFile(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory());
        return this.openAsCSVFile(realTimeStockFile);
    }

    public static boolean saveCSVWatchlist(String directory, CSVWatchlist csvWatchlist) {
        assert (directory.endsWith(File.separator));
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        return JStock.saveAsCSVFile(csvWatchlist, org.yccheok.jstock.watchlist.Utils.getWatchlistFile(directory), true);
    }

    private boolean saveCSVWathclist() {
        String directory = org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory();
        TableModel tableModel = this.jTable1.getModel();
        CSVWatchlist csvWatchlist = CSVWatchlist.newInstance(tableModel);
        return JStock.saveCSVWatchlist(directory, csvWatchlist);
    }

    private boolean saveWatchlist() {
        return this.saveCSVWathclist();
    }

    private boolean saveDatabase() {
        Country country = this.jStockOptions.getCountry();
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database")) {
            return false;
        }
        StockInfoDatabase stock_info_database = this.stockInfoDatabase;
        StockNameDatabase name_database = this.stockNameDatabase;
        boolean b0 = true;
        if (name_database != null) {
            Statements statements = Statements.newInstanceFromStockNameDatabase(name_database);
            File stockNameDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.csv");
            b0 = statements.saveAsCSVFile(stockNameDatabaseCSVFile);
        }
        if (stock_info_database == null) {
            return false;
        }
        if (stock_info_database.isEmpty()) {
            log.info((Object)"Database was corrupted.");
            return false;
        }
        boolean b1 = this.saveUserDefinedDatabaseAsCSV(country, stock_info_database);
        boolean b2 = true;
        File f = org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFile(country);
        if (!f.exists()) {
            b2 = JStock.saveStockInfoDatabaseAsCSV(country, stock_info_database);
        }
        return b0 && b1 && b2;
    }

    private static List<Pair<Code, Symbol>> getUserDefinedPair(StockInfoDatabase stockInfoDatabase) {
        ArrayList<Pair<Code, Symbol>> pairs = new ArrayList<Pair<Code, Symbol>>();
        List<StockInfo> stockInfos = stockInfoDatabase.getUserDefinedStockInfos();
        for (StockInfo stockInfo : stockInfos) {
            pairs.add(new Pair<Code, Symbol>(stockInfo.code, stockInfo.symbol));
        }
        return pairs;
    }

    private boolean saveChartJDialogOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(UserDataDirectory.Config.get())) {
            return false;
        }
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.ChartJDialogOptionsXml.get());
        return Utils.toXML((Object)this.chartJDialogOptions, f);
    }

    private boolean saveJStockOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(UserDataDirectory.Config.get())) {
            return false;
        }
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.OptionsXml.get());
        return Utils.toXML((Object)this.jStockOptions, f);
    }

    private void removeOldHistoryData(Country country) {
        Utils.deleteAllOldFiles(new File(Utils.getHistoryDirectory(country)), 1);
    }

    private void initAlertStateManager() {
        this.alertStateManager.clearState();
        this.alertStateManager.attach(this.alertStateManagerObserver);
    }

    private void initOthersStockHistoryMonitor() {
        this.indicatorPanel.initStockHistoryMonitor();
        this.indicatorScannerJPanel.initStockHistoryMonitor();
    }

    private void initStockHistoryMonitor() {
        final StockHistoryMonitor oldStockHistoryMonitor = this.stockHistoryMonitor;
        if (oldStockHistoryMonitor != null) {
            this.zombiePool.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldStockHistoryMonitor + "..."));
                    oldStockHistoryMonitor.clearStockCodes();
                    oldStockHistoryMonitor.dettachAll();
                    oldStockHistoryMonitor.stop();
                    log.info((Object)("Shut down " + oldStockHistoryMonitor + " peacefully."));
                }
            });
        }
        this.stockHistoryMonitor = new StockHistoryMonitor(4);
        this.stockHistoryMonitor.attach(this.stockHistoryMonitorObserver);
        Country country = this.jStockOptions.getCountry();
        this.removeOldHistoryData(country);
        StockHistorySerializer stockHistorySerializer = new StockHistorySerializer(Utils.getHistoryDirectory());
        this.stockHistoryMonitor.setStockHistorySerializer(stockHistorySerializer);
        this.stockHistoryMonitor.setDuration(Duration.getTodayDurationByYears(this.jStockOptions.getHistoryDuration()));
    }

    public void initLatestNewsTask() {
        if (this.jStockOptions.isAutoUpdateNewsEnabled()) {
            if (this.latestNewsTask == null) {
                this.latestNewsTask = new LatestNewsTask();
                this.latestNewsTask.execute();
            }
        } else {
            final LatestNewsTask oldLatestNewsTask = this.latestNewsTask;
            if (oldLatestNewsTask != null) {
                this.zombiePool.execute(new Runnable(){

                    @Override
                    public void run() {
                        log.info((Object)("Prepare to shut down " + oldLatestNewsTask + "..."));
                        oldLatestNewsTask.cancel(true);
                        log.info((Object)("Shut down " + oldLatestNewsTask + " peacefully."));
                    }
                });
                this.latestNewsTask = null;
            }
        }
    }

    private void initAjaxProvider() {
        Country country = this.jStockOptions.getCountry();
        AutoCompleteJComboBox autoCompleteJComboBox = (AutoCompleteJComboBox)this.jComboBox1;
        if (country == Country.India) {
            autoCompleteJComboBox.setGreedyEnabled(true, Arrays.asList("N", "B"));
        } else {
            autoCompleteJComboBox.setGreedyEnabled(false, Collections.emptyList());
        }
        this.indicatorPanel.initAjaxProvider();
    }

    private void initGoogleCodeDatabaseRunnable() {
        Country country = this.jStockOptions.getCountry();
        if (org.yccheok.jstock.engine.Utils.isGoogleCodeDatabaseRequired(country)) {
            this.singleThreadExecutor.submit(new GoogleCodeDatabaseRunnable(country));
        }
    }

    private void initIEXStockInfoDatabaseRunnable() {
        if (IEXStockInfoDatabaseRunnable.needToBuild()) {
            this.singleThreadExecutor.submit(new IEXStockInfoDatabaseRunnable());
        }
    }

    private void initStockInfoDatabaseMeta() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Country country;
                Map<Country, Long> localStockInfoDatabaseMeta = Utils.loadStockInfoDatabaseMeta(Utils.getStockInfoDatabaseMetaFile());
                String location = org.yccheok.jstock.network.Utils.getURL(Utils.Type.STOCK_INFO_DATABASE_META);
                String json = Utils.downloadAsString(location);
                Map<Country, Long> latestStockInfoDatabaseMeta = Utils.loadStockInfoDatabaseMeta(json);
                EnumMap<Country, Long> successStockInfoDatabaseMeta = new EnumMap<Country, Long>(Country.class);
                boolean needToInitDatabase = false;
                for (Map.Entry<Country, Long> entry : latestStockInfoDatabaseMeta.entrySet()) {
                    String stocksCSVZipFileLocation;
                    File zipFile;
                    Long local;
                    if (Thread.currentThread().isInterrupted() || JStock.this.stockInfoDatabaseMetaPool == null) break;
                    country = entry.getKey();
                    Long latest = entry.getValue();
                    if (latest.equals(local = localStockInfoDatabaseMeta.get((Object)country)) || (zipFile = Utils.downloadAsTempFile(stocksCSVZipFileLocation = org.yccheok.jstock.engine.Utils.getStocksCSVZipFileLocation(country))) == null) continue;
                    File tempZipDirectory = null;
                    try {
                        File file;
                        List<Stock> stocks;
                        tempZipDirectory = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
                        if (!Utils.extractZipFile(zipFile, tempZipDirectory.getAbsolutePath(), true) || (stocks = org.yccheok.jstock.engine.Utils.getStocksFromCSVFile(file = new File(tempZipDirectory, "stocks.csv"))).isEmpty()) continue;
                        Pair<StockInfoDatabase, StockNameDatabase> stockDatabase = org.yccheok.jstock.engine.Utils.toStockDatabase(stocks, country);
                        boolean success = JStock.saveStockInfoDatabaseAsCSV(country, (StockInfoDatabase)stockDatabase.first);
                        if (stockDatabase.second != null) {
                            JStock.saveStockNameDatabaseAsCSV(country, (StockNameDatabase)stockDatabase.second);
                        }
                        if (!success) continue;
                        successStockInfoDatabaseMeta.put(country, latest);
                        if (country != JStock.this.jStockOptions.getCountry()) continue;
                        needToInitDatabase = true;
                    }
                    catch (IOException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    finally {
                        if (tempZipDirectory == null) continue;
                        Utils.deleteDir(tempZipDirectory, true);
                    }
                }
                if (successStockInfoDatabaseMeta.isEmpty()) {
                    return;
                }
                for (Map.Entry<Country, Long> entry : localStockInfoDatabaseMeta.entrySet()) {
                    country = entry.getKey();
                    Long old = entry.getValue();
                    if (successStockInfoDatabaseMeta.containsKey((Object)country)) continue;
                    successStockInfoDatabaseMeta.put(country, old);
                }
                Utils.saveStockInfoDatabaseMeta(Utils.getStockInfoDatabaseMetaFile(), successStockInfoDatabaseMeta);
                if (needToInitDatabase) {
                    JStock.this.initDatabase(true);
                }
            }
        };
        this.stockInfoDatabaseMetaPool.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase(boolean readFromDisk) {
        this.setStatusBar(true, GUIBundle.getString("MainFrame_ConnectingToStockServerToRetrieveStockInformation..."));
        this.statusBar.setImageIcon(this.getImageIcon("/images/16x16/network-connecting.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Connecting..."));
        Object object = this.databaseTaskMonitor;
        synchronized (object) {
            if (this.databaseTask != null) {
                this.databaseTask.cancel(true);
                this.stockInfoDatabase = null;
                this.stockNameDatabase = null;
                ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(null);
                this.indicatorPanel.setStockInfoDatabase(null);
            }
            this.databaseTask = new DatabaseTask(readFromDisk);
            this.databaseTask.execute();
        }
        System.gc();
    }

    private void update(RealTimeStockMonitor monitor, RealTimeStockMonitor.Result result) {
        final List<Stock> stocks = result.stocks;
        boolean isSymbolImmutable = org.yccheok.jstock.engine.Utils.isSymbolImmutable();
        int size = stocks.size();
        for (int i = 0; i < size; ++i) {
            Stock stock;
            Stock new_stock = stock = stocks.get(i);
            if (!isSymbolImmutable && !new_stock.symbol.toString().isEmpty()) continue;
            StockInfoDatabase stock_info_database = this.stockInfoDatabase;
            if (stock_info_database != null) {
                Symbol symbol = stock_info_database.codeToSymbol(stock.code);
                if (symbol != null) {
                    new_stock = new_stock.deriveStock(symbol);
                } else {
                    log.error((Object)("Wrong stock code " + stock.code + " given by stock server."));
                }
            } else {
                StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
                int row = tableModel.findRow(stock);
                if (row >= 0) {
                    Symbol symbol = tableModel.getStock((int)row).symbol;
                    new_stock = new_stock.deriveStock(symbol);
                }
            }
            if (stock == new_stock) continue;
            stocks.set(i, new_stock);
        }
        if (!stocks.isEmpty()) {
            this.timestamp = System.currentTimeMillis();
            ((StockTableModel)this.jTable1.getModel()).setTimestamp(this.timestamp);
        }
        JStock.instance().updateStatusBarWithLastUpdateDateMessageIfPossible();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Stock stock : stocks) {
                    JStock.this.updateStockToTable(stock);
                    if (!JStock.this.isStockBeingSelected(stock)) continue;
                    JStock.this.updateDynamicChart(stock);
                }
            }
        });
        for (Stock stock : stocks) {
            Code code = stock.code;
            DynamicChart dynamicChart = this.dynamicCharts.get(code);
            if (dynamicChart == null) {
                if (this.dynamicCharts.size() <= 10) {
                    dynamicChart = new DynamicChart();
                    this.dynamicCharts.put(code, dynamicChart);
                } else if (this.isStockBeingSelected(stock)) {
                    Set<Code> codes = this.dynamicCharts.keySet();
                    for (Code c : codes) {
                        this.dynamicCharts.remove(c);
                        if (this.dynamicCharts.size() > 10) continue;
                        break;
                    }
                    dynamicChart = new DynamicChart();
                    this.dynamicCharts.put(code, dynamicChart);
                }
            }
            if (dynamicChart == null) continue;
            if (this.isStockBeingSelected(stock)) {
                dynamicChart.addPriceObservation(stock.getTimestamp(), stock.getLastPrice());
                final Stock s = stock;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JStock.this.updateDynamicChart(s);
                    }
                });
                continue;
            }
            dynamicChart.addPriceObservation(stock.getTimestamp(), stock.getLastPrice());
        }
        if (!(this.jStockOptions.isPopupMessage() || this.jStockOptions.isSoundEnabled() || this.jStockOptions.isSendEmail())) {
            return;
        }
        StockTableModel stockTableModel = (StockTableModel)this.jTable1.getModel();
        for (Stock stock : stocks) {
            Double fallBelow = stockTableModel.getFallBelow(stock);
            if (fallBelow != null) {
                Indicator indicator = Utils.getLastPriceFallBelowIndicator(fallBelow);
                indicator.setStock(stock);
                this.alertStateManager.alert(indicator);
            } else {
                this.alertStateManager.clearState(FALL_BELOW_INDICATOR, stock);
            }
            Double riseAbove = stockTableModel.getRiseAbove(stock);
            if (riseAbove != null) {
                Indicator indicator = Utils.getLastPriceRiseAboveIndicator(riseAbove);
                indicator.setStock(stock);
                this.alertStateManager.alert(indicator);
                continue;
            }
            this.alertStateManager.clearState(RISE_ABOVE_INDICATOR, stock);
        }
    }

    public void updateStatusBarWithLastUpdateDateMessageIfPossible() {
        if (this.refreshPriceInProgress) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
            this.refreshPriceInProgress = false;
            return;
        }
        if (this.isStatusBarBusy) {
            return;
        }
        Component selected = this.getSelectedComponent();
        if (selected != this.jPanel8 && selected != this.portfolioManagementJPanel && selected != this.tradingJPanel) {
            return;
        }
        this.setStatusBar(false, this.getBestStatusBarMessage());
    }

    public String getBestStatusBarMessage() {
        long _timestamp;
        String currentName;
        Component selected = this.getSelectedComponent();
        if (selected == this.jPanel8) {
            currentName = this.getJStockOptions().getWatchlistName();
            _timestamp = this.timestamp;
        } else if (selected == this.portfolioManagementJPanel) {
            currentName = this.getJStockOptions().getPortfolioName();
            _timestamp = this.portfolioManagementJPanel.getTimestamp();
        } else if (selected == this.tradingJPanel) {
            currentName = DriveWealthBundle.getString("Drivewealth_data_by_BATS");
            _timestamp = TradingView.getInstance().getTimestamp();
        } else {
            return GUIBundle.getString("MainFrame_Connected");
        }
        if (_timestamp == 0L) {
            return MessageFormat.format(GUIBundle.getString("MainFrame_Connected_template"), currentName);
        }
        Date date = new Date(_timestamp);
        String time = Utils.isToday(_timestamp) ? Utils.getTodayLastUpdateTimeFormat().format(date) : Utils.getOtherDayLastUpdateTimeFormat().format(date);
        return MessageFormat.format(GUIBundle.getString("MainFrame_LastUpdate_template"), currentName, time);
    }

    private void update(final List<Market> markets) {
        assert (!markets.isEmpty());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JStock.this.marketJPanel.update(markets);
            }
        });
    }

    public void update(StockHistoryMonitor monitor, final StockHistoryMonitor.StockHistoryRunnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String template;
                Code code = runnable.getCode();
                Symbol symbol = null;
                StockInfoDatabase stock_info_database = JStock.this.stockInfoDatabase;
                if (stock_info_database != null) {
                    symbol = stock_info_database.codeToSymbol(code);
                }
                boolean shouldShowGUI = JStock.this.stockCodeHistoryGUI.remove(code);
                if (JStock.this.stockCodeHistoryGUI.isEmpty()) {
                    if (runnable.getStockHistoryServer() != null) {
                        template = GUIBundle.getString("MainFrame_HistorySuccess_template");
                        String message = MessageFormat.format(template, symbol != null ? symbol : code);
                        JStock.this.setStatusBar(false, message);
                    } else {
                        template = GUIBundle.getString("MainFrame_HistoryFailed_template");
                        String message = MessageFormat.format(template, symbol != null ? symbol : code);
                        JStock.this.setStatusBar(false, message);
                    }
                } else if (runnable.getStockHistoryServer() != null) {
                    template = GUIBundle.getString("MainFrame_HistorySuccessStillWaitingForHistoryTotal_template");
                    String message = MessageFormat.format(template, symbol != null ? symbol : code, JStock.this.stockCodeHistoryGUI.size());
                    JStock.this.setStatusBar(true, message);
                } else {
                    template = GUIBundle.getString("MainFrame_HistoryFailedStillWaitingForHistoryTotal_template");
                    String message = MessageFormat.format(template, symbol != null ? symbol : code, JStock.this.stockCodeHistoryGUI.size());
                    JStock.this.setStatusBar(true, message);
                }
                if (runnable.getStockHistoryServer() != null && shouldShowGUI) {
                    ChartJDialog chartJDialog = new ChartJDialog(JStock.this, (symbol != null ? symbol : code) + " (" + code + ")", false, runnable.getStockHistoryServer());
                    chartJDialog.setVisible(true);
                }
            }
        });
    }

    private ImageIcon getImageIcon(String imageIcon) {
        return new ImageIcon(this.getClass().getResource(imageIcon));
    }

    public void displayPopupMessage(final String caption, final String message) {
        if (this.trayIcon == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.trayIcon.displayMessage(caption, message, TrayIcon.MessageType.INFO);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JStock.this.trayIcon.displayMessage(caption, message, TrayIcon.MessageType.INFO);
                }
            });
        }
    }

    public IndicatorProjectManager getAlertIndicatorProjectManager() {
        return this.indicatorPanel.getAlertIndicatorProjectManager();
    }

    public void updateScanningSpeed(int speed) {
        this.realTimeStockMonitor.setDelay(speed);
        this.realTimeIndexMonitor.setDelay(speed);
        this.indicatorScannerJPanel.updateScanningSpeed(speed);
    }

    public void updateHistoryDuration(Duration historyDuration) {
        Country[] countries;
        Duration oldDuration = this.stockHistoryMonitor.getDuration();
        if (oldDuration.isContains(historyDuration)) {
            this.stockHistoryMonitor.setDuration(historyDuration);
            return;
        }
        log.info((Object)("We are going to remove all history files, due to new duration " + historyDuration + " is not within old duration " + oldDuration));
        for (Country country : countries = Country.values()) {
            Utils.deleteDir(Utils.getHistoryDirectory(country), false);
        }
        this.initStockHistoryMonitor();
    }

    public void repaintTable() {
        Component c = this.getSelectedComponent();
        if (c instanceof IndicatorScannerJPanel) {
            this.indicatorScannerJPanel.repaintTable();
        } else if (!(c instanceof IndicatorPanel)) {
            this.jTable1.repaint();
        }
    }

    private void initMarketJPanel() {
        if (this.marketJPanel != null) {
            this.jPanel2.remove(this.marketJPanel);
        }
        this.marketJPanel = new MarketJPanel(this.jStockOptions.getCountry());
        this.jPanel2.add(this.marketJPanel);
        this.jPanel2.revalidate();
    }

    private void initPreloadDatabase(boolean overWrite) {
        Utils.extractZipFile("database" + File.separator + "database.zip", overWrite);
    }

    public Component getSelectedComponent() {
        return this.jTabbedPane1.getSelectedComponent();
    }

    private void initAlwaysOnTop() {
        boolean selected = this.jStockOptions.isAlwaysOnTop();
        this._setAlwaysOnTop(selected);
    }

    private void initExtraDatas() {
        Utils.extractZipFile("extra" + File.separator + "extra.zip", false);
    }

    private ActionListener getTimerActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JStock.this.jTabbedPane1.getIconAt(4) == JStock.this.smileIcon) {
                    JStock.this.jTabbedPane1.setIconAt(4, JStock.this.smileGrayIcon);
                } else {
                    JStock.this.jTabbedPane1.setIconAt(4, JStock.this.smileIcon);
                }
            }
        };
    }

    public void initDynamicChartVisibility() {
        this.jPanel10.setVisible(this.jStockOptions.isDynamicChartVisible());
    }

    private void initDynamicCharts() {
        this.dynamicCharts.clear();
    }

    private void initStatusBar() {
        String message = ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_ConnectingToStockServerToRetrieveStockInformation...");
        ImageIcon icon = this.getImageIcon("/images/16x16/network-connecting.png");
        String iconMessage = ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Connecting...");
        this.statusBar.setMainMessage(message).setImageIcon(icon, iconMessage).setCountryIcon(this.jStockOptions.getCountry().icon, this.jStockOptions.getCountry().humanString);
    }

    private MouseAdapter getDynamicChartMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    Stock stock = JStock.this.getSelectedStock();
                    if (stock == null) {
                        return;
                    }
                    DynamicChart dynamicChart = (DynamicChart)JStock.this.dynamicCharts.get(stock.code);
                    if (dynamicChart == null) {
                        return;
                    }
                    Symbol symbol = null;
                    StockInfoDatabase stock_info_database = JStock.this.stockInfoDatabase;
                    if (stock_info_database != null) {
                        symbol = stock_info_database.codeToSymbol(stock.code);
                    }
                    String template = GUIBundle.getString("MainFrame_IntradayMovementTemplate");
                    String message = MessageFormat.format(template, symbol == null ? stock.symbol : symbol);
                    dynamicChart.showNewJDialog(JStock.this, message);
                }
            }
        };
    }

    private void refreshExchangeRateMonitor() {
        this.portfolioManagementJPanel.refreshExchangeRateMonitor();
    }

    public void refreshAllRealTimeStockMonitors() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.refresh();
        }
        this.indicatorScannerJPanel.refreshRealTimeStockMonitor();
        this.portfolioManagementJPanel.refreshRealTimeStockMonitor();
    }

    public void refreshRealTimeIndexMonitor() {
        RealTimeIndexMonitor _realTimeIndexMonitor = this.realTimeIndexMonitor;
        if (_realTimeIndexMonitor != null) {
            _realTimeIndexMonitor.refresh();
        }
    }

    static /* synthetic */ StockInfoDatabase access$7200(JStock x0, Country x1) {
        return x0.loadStockInfoDatabaseFromCSV(x1);
    }

    static /* synthetic */ void access$7300(JStock x0, boolean x1) {
        x0.initPreloadDatabase(x1);
    }

    static /* synthetic */ StockNameDatabase access$7400(JStock x0, Country x1) {
        return x0.loadStockNameDatabaseFromCSV(x1);
    }

    static /* synthetic */ List access$7500(JStock x0, Country x1) {
        return x0.loadUserDefinedDatabaseFromCSV(x1);
    }

    static /* synthetic */ StockInfoDatabase access$502(JStock x0, StockInfoDatabase x1) {
        x0.stockInfoDatabase = x1;
        return x0.stockInfoDatabase;
    }

    static /* synthetic */ StockNameDatabase access$7602(JStock x0, StockNameDatabase x1) {
        x0.stockNameDatabase = x1;
        return x0.stockNameDatabase;
    }

    static /* synthetic */ JComboBox access$7700(JStock x0) {
        return x0.jComboBox1;
    }

    static /* synthetic */ IndicatorPanel access$7800(JStock x0) {
        return x0.indicatorPanel;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        log = LogFactory.getLog(JStock.class);
        EMPTY_DYNAMIC_CHART = new DynamicChart();
        FALL_BELOW_INDICATOR = Utils.getLastPriceFallBelowIndicator(0.0);
        RISE_ABOVE_INDICATOR = Utils.getLastPriceRiseAboveIndicator(0.0);
    }

    private class TableKeyEventListener
    extends KeyAdapter {
        private TableKeyEventListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JStock.this.jTable1.getSelectionModel().clearSelection();
        }
    }

    private class LatestNewsTask
    extends SwingWorker<Void, String> {
        private static final int SHORT_DELAY = 20000;
        private volatile CountDownLatch doneSignal;

        private LatestNewsTask() {
        }

        @Override
        protected void done() {
        }

        @Override
        protected void process(List<String> messages) {
            boolean show = false;
            for (String message : messages) {
                AutoUpdateNewsJDialog dialog = new AutoUpdateNewsJDialog((Frame)JStock.this, true);
                dialog.setNews(message);
                dialog.setVisible(true);
                show = true;
            }
            if (show) {
                this.doneSignal.countDown();
            }
        }

        @Override
        protected Void doInBackground() {
            while (!this.isCancelled()) {
                String location;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ex) {
                    log.info(null, (Throwable)ex);
                    break;
                }
                Map<String, String> map = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.NEWS_INFORMATION_TXT));
                String newsID = JStock.this.getJStockOptions().getNewsID();
                if (newsID.equals(map.get("news_id")) || (location = map.get("news_url")) == null) break;
                this.doneSignal = new CountDownLatch(1);
                String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
                if (respond == null || respond.indexOf(Utils.getJStockUUID()) < 0) break;
                this.publish(respond);
                try {
                    this.doneSignal.await();
                }
                catch (InterruptedException ex) {
                    log.info(null, (Throwable)ex);
                    break;
                }
                JStock.this.jStockOptions.setNewsID(map.get("news_id"));
            }
            return null;
        }
    }

    private static class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map<TableColumn, String> tips = new HashMap<TableColumn, String>();

        private ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TableColumn col = null;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText(this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    private class TableMouseAdapter
    extends MouseAdapter {
        private TableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int[] rows = JStock.this.jTable1.getSelectedRows();
            if (rows.length == 1) {
                int row = rows[0];
                StockTableModel tableModel = (StockTableModel)JStock.this.jTable1.getModel();
                int modelIndex = JStock.this.jTable1.convertRowIndexToModel(row);
                Stock stock = tableModel.getStock(modelIndex);
                JStock.this.updateDynamicChart(stock);
            } else {
                JStock.this.updateDynamicChart(null);
            }
            if (evt.getClickCount() == 2) {
                JStock.this.displayHistoryCharts();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (JStock.this.jTable1.getSelectedRowCount() <= 1) {
                    this.setFocusToRightClickLocation(e, JStock.this.jTable1);
                }
                if (JStock.this.jTable1.getSelectedRowCount() > 0) {
                    JStock.this.getMyJTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private void setFocusToRightClickLocation(MouseEvent e, JTable table) {
            Point p = e.getPoint();
            int rowNumber = table.rowAtPoint(p);
            if (rowNumber >= 0 && rowNumber < table.getRowCount()) {
                table.setRowSelectionInterval(rowNumber, rowNumber);
            } else {
                table.clearSelection();
            }
        }
    }

    private class DatabaseTask
    extends SwingWorker<Boolean, Void> {
        private boolean readFromDisk = true;

        public DatabaseTask(boolean readFromDisk) {
            this.readFromDisk = readFromDisk;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            boolean success = false;
            try {
                success = (Boolean)this.get();
            }
            catch (InterruptedException exp) {
                log.error(null, (Throwable)exp);
            }
            catch (ExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
            catch (CancellationException ex) {
                log.error(null, (Throwable)ex);
            }
            if (success) {
                JStock.this.setStatusBar(false, JStock.this.getBestStatusBarMessage());
                JStock.this.statusBar.setImageIcon(JStock.this.getImageIcon("/images/16x16/network-transmit-receive.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Connected"));
            } else {
                JStock.this.setStatusBar(false, GUIBundle.getString("MainFrame_NetworkError"));
                JStock.this.statusBar.setImageIcon(JStock.this.getImageIcon("/images/16x16/network-error.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_DoubleClickedToTryAgain"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public Boolean doInBackground() {
            country = JStock.access$400(JStock.this).getCountry();
            Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + (Object)country + File.separator + "database");
            if (this.readFromDisk) {
                tmp_stock_info_database = JStock.access$7200(JStock.this, country);
                if (tmp_stock_info_database == null) {
                    JStock.access$7300(JStock.this, true);
                    tmp_stock_info_database = JStock.access$7200(JStock.this, country);
                }
                tmp_name_database = org.yccheok.jstock.engine.Utils.isNameImmutable() != false ? JStock.access$7400(JStock.this, country) : null;
                if (this.isCancelled()) {
                    return false;
                }
                if (tmp_stock_info_database != null && !tmp_stock_info_database.isEmpty()) {
                    pairs = JStock.access$7500(JStock.this, country);
                    addUserDefinedStockInfoSuccessAtLeastOnce = false;
                    if (!pairs.isEmpty()) {
                        tmp_stock_info_database.removeAllUserDefinedStockInfos();
                        for (Pair pair : pairs) {
                            if (!tmp_stock_info_database.addUserDefinedStockInfo(StockInfo.newInstance((Code)pair.first, (Symbol)pair.second))) continue;
                            addUserDefinedStockInfoSuccessAtLeastOnce = true;
                        }
                    }
                    if (!addUserDefinedStockInfoSuccessAtLeastOnce) {
                        new File(Utils.getUserDataDirectory() + (Object)country + File.separator + "database" + File.separator + "user-defined-database.csv").delete();
                    }
                    var6_10 = JStock.access$6200(JStock.this);
                    // MONITORENTER : var6_10
                    if (this.isCancelled()) {
                        // MONITOREXIT : var6_10
                        return false;
                    }
                    JStock.access$502(JStock.this, tmp_stock_info_database);
                    JStock.access$7602(JStock.this, tmp_name_database);
                    ((AutoCompleteJComboBox)JStock.access$7700(JStock.this)).setStockInfoDatabase(JStock.access$500(JStock.this));
                    JStock.access$7800(JStock.this).setStockInfoDatabase(JStock.access$500(JStock.this));
                    // MONITOREXIT : var6_10
                    return true;
                }
            }
            if ((zipFile = Utils.downloadAsTempFile(location = org.yccheok.jstock.engine.Utils.getStocksCSVZipFileLocation(country))) == null) {
                return false;
            }
            tempZipDirectory = null;
            try {
                tempZipDirectory = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
                if (!Utils.extractZipFile(zipFile, tempZipDirectory.getAbsolutePath(), true)) {
                    addUserDefinedStockInfoSuccessAtLeastOnce = false;
                    return addUserDefinedStockInfoSuccessAtLeastOnce;
                }
                file = new File(tempZipDirectory, "stocks.csv");
                stocks = org.yccheok.jstock.engine.Utils.getStocksFromCSVFile(file);
                if (false != stocks.isEmpty()) return false;
                stockDatabase = org.yccheok.jstock.engine.Utils.toStockDatabase(stocks, country);
                if (this.isCancelled()) {
                    var8_14 = false;
                    return var8_14;
                }
                JStock.access$7900(country, (StockInfoDatabase)stockDatabase.first);
                if (stockDatabase.second != null) {
                    JStock.access$8000(country, (StockNameDatabase)stockDatabase.second);
                }
                if (!(pairs = JStock.access$7500(JStock.this, country)).isEmpty()) {
                    for (Pair pair : pairs) {
                        ((StockInfoDatabase)stockDatabase.first).addUserDefinedStockInfo(StockInfo.newInstance((Code)pair.first, (Symbol)pair.second));
                    }
                }
                var9_16 = JStock.access$6200(JStock.this);
                // MONITORENTER : var9_16
                if (this.isCancelled()) {
                    var10_17 = false;
                    // MONITOREXIT : var9_16
                    return var10_17;
                }
                ** try [egrp 5[TRYBLOCK] [9 : 674->752)] { 
            }
lbl82:
            // 2 sources

            catch (IOException ex) {
                JStock.access$4800().error(null, (Throwable)ex);
                return false;
            }
            finally {
                if (tempZipDirectory != null) {
                    Utils.deleteDir(tempZipDirectory, true);
                }
            }
lbl-1000:
            // 1 sources

            {
                JStock.access$502(JStock.this, (StockInfoDatabase)stockDatabase.first);
                JStock.access$7602(JStock.this, (StockNameDatabase)stockDatabase.second);
                ((AutoCompleteJComboBox)JStock.access$7700(JStock.this)).setStockInfoDatabase(JStock.access$500(JStock.this));
                JStock.access$7800(JStock.this).setStockInfoDatabase(JStock.access$500(JStock.this));
                var10_17 = true;
                // MONITOREXIT : var9_16
                if (tempZipDirectory == null) return var10_17;
            }
            Utils.deleteDir(tempZipDirectory, true);
            return var10_17;
        }
    }

    class ChangeLookAndFeelAction
    extends AbstractAction {
        JStock mainFrame;
        String lafClassName;

        protected ChangeLookAndFeelAction(JStock mainFrame, String lafClassName) {
            super("ChangeTheme");
            this.mainFrame = mainFrame;
            this.lafClassName = lafClassName;
        }

        public String getLafClassName() {
            return this.lafClassName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mainFrame.setLookAndFeel(this.lafClassName);
        }
    }

    private static class MainFrameHolder {
        private static final JStock INSTANCE = new JStock();

        private MainFrameHolder() {
        }
    }

    public static final class CSVWatchlist {
        public final TableModel tableModel;

        private CSVWatchlist(TableModel tableModel) {
            if (tableModel == null) {
                throw new IllegalArgumentException();
            }
            this.tableModel = tableModel;
        }

        public static CSVWatchlist newInstance(TableModel tableModel) {
            return new CSVWatchlist(tableModel);
        }
    }
}

