/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j.html;

import it.sauronsoftware.feed4j.bean.RawAttribute;
import it.sauronsoftware.feed4j.bean.RawElement;
import it.sauronsoftware.feed4j.bean.RawNode;
import it.sauronsoftware.feed4j.bean.RawText;
import it.sauronsoftware.feed4j.html.HTMLEntities;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.html.dom.HTMLDocumentImpl;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HTMLFragmentHelper {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

    public static String fromHTMLtoTextPlain(String str) {
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment = document.createDocumentFragment();
        try {
            parser.parse(new InputSource(new StringReader(str)), fragment);
        }
        catch (Exception e) {
            return null;
        }
        return HTMLFragmentHelper.nodeToText(fragment);
    }

    private static String nodeToText(Node node) {
        StringBuffer buffer = new StringBuffer();
        if (node instanceof Text) {
            Text text = (Text)node;
            buffer.append(text.getData());
            buffer.append(' ');
        } else {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                buffer.append(HTMLFragmentHelper.nodeToText(list.item(i)));
                buffer.append(' ');
                ++i;
            }
        }
        String ret = buffer.toString();
        return ret.replaceAll("\\s+", " ").trim();
    }

    public static String fromXHTMLtoTextPlain(RawElement element) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < element.getNodeCount()) {
            RawNode sub;
            RawNode node = element.getNode(i);
            if (node instanceof RawElement) {
                sub = (RawElement)node;
                buffer.append(HTMLFragmentHelper.fromXHTMLtoTextPlain((RawElement)sub));
            } else if (node instanceof RawText) {
                sub = (RawText)node;
                buffer.append(((RawText)sub).getText());
            }
            ++i;
        }
        String ret = buffer.toString();
        return ret.replaceAll("\\s+", " ").trim();
    }

    public static String fromTextPlainToHTML(String str) {
        return HTMLEntities.encode(str);
    }

    public static String fromXHTMLtoHTML(RawElement element) {
        return HTMLFragmentHelper.fromXHTMLtoHTML(element, null);
    }

    private static String fromXHTMLtoHTML(RawElement element, URL base) {
        String aux = element.getAttributeValue(XML_NAMESPACE, "base");
        if (aux != null) {
            try {
                base = new URL(aux);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < element.getNodeCount()) {
            RawElement rawElement;
            RawNode node = element.getNode(i);
            if (node instanceof RawText) {
                RawText rawText = (RawText)node;
                buffer.append(rawText.getText());
            } else if (node instanceof RawElement && (rawElement = (RawElement)node).getNamespaceURI().equals(XHTML_NAMESPACE)) {
                buffer.append('<');
                buffer.append(rawElement.getName());
                int j = 0;
                while (j < rawElement.getAttributeCount()) {
                    RawAttribute rawAttribute = rawElement.getAttribute(j);
                    if (rawAttribute.getNamespaceURI().equals(XHTML_NAMESPACE)) {
                        String attrname = rawAttribute.getName();
                        String attrvalue = rawAttribute.getValue();
                        attrvalue = HTMLFragmentHelper.applBase(attrname, attrvalue, base);
                        buffer.append(' ');
                        buffer.append(attrname);
                        buffer.append('=');
                        buffer.append('\"');
                        buffer.append(HTMLEntities.encode(attrvalue));
                        buffer.append('\"');
                    }
                    ++j;
                }
                String value = rawElement.getValue();
                if (value != null) {
                    buffer.append('>');
                    buffer.append(HTMLEntities.encode(value));
                    buffer.append('<');
                    buffer.append('/');
                    buffer.append(rawElement.getName());
                    buffer.append('>');
                } else if (rawElement.getNodeCount() > 0) {
                    buffer.append('>');
                    buffer.append(HTMLFragmentHelper.fromXHTMLtoHTML(rawElement, base));
                    buffer.append('<');
                    buffer.append('/');
                    buffer.append(rawElement.getName());
                    buffer.append('>');
                } else {
                    buffer.append(' ');
                    buffer.append('/');
                    buffer.append('>');
                }
            }
            ++i;
        }
        String ret = buffer.toString();
        return ret.replaceAll("\\s+", " ").trim();
    }

    private static String applBase(String name, String value, URL base) {
        if (base != null && (name.equals("href") || name.equals("src")) && value.indexOf(58) == -1) {
            try {
                URL aux = new URL(base, value);
                value = aux.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return value;
    }
}

