/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.PackageManager;

public abstract class CachedJarsPackageManager
extends PackageManager {
    private boolean indexModified;
    private Hashtable jarfiles;
    private File cachedir;

    protected void message(String string2) {
    }

    protected void warning(String string2) {
    }

    protected void comment(String string2) {
    }

    protected void debug(String string2) {
    }

    protected boolean filterByName(String string2, boolean bl) {
        return string2.indexOf(36) != -1;
    }

    protected boolean filterByAccess(String string2, int n) {
        return (n & 1) != 1;
    }

    private static String vectorToString(Vector vector) {
        int n = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)vector.elementAt(i));
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void addZipEntry(Hashtable hashtable, ZipEntry zipEntry, ZipInputStream zipInputStream) throws IOException {
        int n;
        String string2 = zipEntry.getName();
        if (!string2.endsWith(".class")) {
            return;
        }
        char c = '/';
        int n2 = string2.lastIndexOf(c);
        if (n2 == -1) {
            n2 = string2.lastIndexOf(92);
            c = '\\';
        }
        String string3 = n2 == -1 ? "" : string2.substring(0, n2).replace(c, '.');
        String string4 = string2.substring(n2 + 1, string2.length() - 6);
        if (this.filterByName(string4, false)) {
            return;
        }
        Vector[] vectorArray = (Vector[])hashtable.get(string3);
        if (vectorArray == null) {
            vectorArray = new Vector[]{new Vector(), new Vector()};
            hashtable.put(string3, vectorArray);
        }
        if ((n = CachedJarsPackageManager.checkAccess(zipInputStream)) != -1 && !this.filterByAccess(string2, n)) {
            vectorArray[0].addElement(string4);
        } else {
            vectorArray[1].addElement(string4);
        }
    }

    private Hashtable getZipPackages(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        Hashtable hashtable = new Hashtable();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.addZipEntry(hashtable, zipEntry, zipInputStream);
            zipInputStream.closeEntry();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Vector[] vectorArray = (Vector[])hashtable.get(k);
            String string2 = CachedJarsPackageManager.vectorToString(vectorArray[0]);
            if (vectorArray[1].size() > 0) {
                string2 = string2 + '@' + CachedJarsPackageManager.vectorToString(vectorArray[1]);
            }
            hashtable.put(k, string2);
        }
        return hashtable;
    }

    public void addJarToPackages(URL uRL) {
        this.addJarToPackages(uRL, null, false);
    }

    public void addJarToPackages(URL uRL, boolean bl) {
        this.addJarToPackages(uRL, null, bl);
    }

    public void addJarToPackages(File file) {
        this.addJarToPackages(null, file, false);
    }

    public void addJarToPackages(File file, boolean bl) {
        this.addJarToPackages(null, file, bl);
    }

    private void addJarToPackages(URL uRL, File file, boolean bl) {
        try {
            Object object;
            Object object2;
            boolean bl2 = this.jarfiles != null;
            URLConnection uRLConnection = null;
            boolean bl3 = true;
            if (file == null) {
                uRLConnection = uRL.openConnection();
                if (uRLConnection.getURL().getProtocol().equals("file")) {
                    object2 = uRL.getFile();
                    object2 = ((String)object2).replace('/', File.separatorChar);
                    file = new File((String)object2);
                } else {
                    bl3 = false;
                }
            }
            if (bl3 && !file.exists()) {
                return;
            }
            object2 = null;
            long l = 0L;
            String string2 = null;
            JarXEntry jarXEntry = null;
            boolean bl4 = false;
            if (bl2) {
                if (bl3) {
                    l = file.lastModified();
                    string2 = file.getCanonicalPath();
                } else {
                    l = uRLConnection.getLastModified();
                    string2 = uRL.toString();
                }
                jarXEntry = (JarXEntry)this.jarfiles.get(string2);
                if ((jarXEntry == null || !new File(jarXEntry.cachefile).exists()) && bl) {
                    this.message("processing new jar, '" + string2 + "'");
                    if (bl3) {
                        object = file.getName();
                    } else {
                        object = uRL.getFile();
                        int n = ((String)object).lastIndexOf(47);
                        if (n != -1) {
                            object = ((String)object).substring(n + 1);
                        }
                    }
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                    jarXEntry = new JarXEntry((String)object);
                    this.jarfiles.put(string2, jarXEntry);
                    bl4 = true;
                }
                if (l != 0L && jarXEntry != null && jarXEntry.mtime == l) {
                    object2 = this.readCacheFile(jarXEntry, string2);
                }
            }
            if (object2 == null) {
                boolean bl5 = bl2 = bl2 && bl;
                if (bl2) {
                    this.indexModified = true;
                    if (jarXEntry.mtime != 0L) {
                        this.message("processing modified jar, '" + string2 + "'");
                    }
                    jarXEntry.mtime = l;
                }
                object = uRLConnection == null ? new BufferedInputStream(new FileInputStream(file)) : uRLConnection.getInputStream();
                object2 = this.getZipPackages((InputStream)object);
                if (bl2) {
                    this.writeCacheFile(jarXEntry, string2, (Hashtable)object2, bl4);
                }
            }
            this.addPackages((Hashtable)object2, string2);
        }
        catch (IOException iOException) {
            this.warning("skipping bad jar, '" + (file != null ? file.toString() : uRL.toString()) + "'");
        }
    }

    private void addPackages(Hashtable hashtable, String string2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)hashtable.get(string3);
            int n = string4.indexOf(64);
            if (n >= 0 && Options.respectJavaAccessibility) {
                string4 = string4.substring(0, n);
            }
            this.makeJavaPackage(string3, string4, string2);
        }
    }

    private Hashtable readCacheFile(JarXEntry jarXEntry, String string2) {
        String string3 = jarXEntry.cachefile;
        long l = jarXEntry.mtime;
        this.debug("reading cache, '" + string2 + "'");
        try {
            DataInputStream dataInputStream = this.inOpenCacheFile(string3);
            String string4 = dataInputStream.readUTF();
            long l2 = dataInputStream.readLong();
            if (!string4.equals(string2) || l2 != l) {
                this.comment("invalid cache file: " + string3 + ", " + string2 + ":" + string4 + ", " + l + ":" + l2);
                this.deleteCacheFile(string3);
                return null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                while (true) {
                    String string5 = dataInputStream.readUTF();
                    String string6 = dataInputStream.readUTF();
                    hashtable.put(string5, string6);
                }
            }
            catch (EOFException eOFException) {
                dataInputStream.close();
                return hashtable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeCacheFile(JarXEntry jarXEntry, String string2, Hashtable hashtable, boolean bl) {
        try {
            DataOutputStream dataOutputStream = this.outCreateCacheFile(jarXEntry, bl);
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeLong(jarXEntry.mtime);
            this.comment("rewriting cachefile for '" + string2 + "'");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)hashtable.get(string3);
                dataOutputStream.writeUTF(string3);
                dataOutputStream.writeUTF(string4);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write cache file for '" + string2 + "'");
        }
    }

    protected void initCache() {
        this.indexModified = false;
        this.jarfiles = new Hashtable();
        try {
            DataInputStream dataInputStream = this.inOpenIndex();
            if (dataInputStream == null) {
                return;
            }
            try {
                while (true) {
                    String string2 = dataInputStream.readUTF();
                    String string3 = dataInputStream.readUTF();
                    long l = dataInputStream.readLong();
                    this.jarfiles.put(string2, new JarXEntry(string3, l));
                }
            }
            catch (EOFException eOFException) {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.warning("invalid index file");
        }
    }

    public void saveCache() {
        if (this.jarfiles == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file");
        try {
            DataOutputStream dataOutputStream = this.outOpenIndex();
            Enumeration enumeration = this.jarfiles.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                JarXEntry jarXEntry = (JarXEntry)this.jarfiles.get(string2);
                dataOutputStream.writeUTF(string2);
                dataOutputStream.writeUTF(jarXEntry.cachefile);
                dataOutputStream.writeLong(jarXEntry.mtime);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write index file");
        }
    }

    protected DataInputStream inOpenIndex() throws IOException {
        File file = new File(this.cachedir, "packages.idx");
        if (!file.exists()) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        return dataInputStream;
    }

    protected DataOutputStream outOpenIndex() throws IOException {
        File file = new File(this.cachedir, "packages.idx");
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected DataInputStream inOpenCacheFile(String string2) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(string2)));
    }

    protected void deleteCacheFile(String string2) {
        new File(string2).delete();
    }

    protected DataOutputStream outCreateCacheFile(JarXEntry jarXEntry, boolean bl) throws IOException {
        File file = null;
        if (bl) {
            int n = 1;
            String string2 = "";
            String string3 = jarXEntry.cachefile;
            while ((file = new File(this.cachedir, string3 + string2 + ".pkc")).exists()) {
                string2 = "$" + n;
                ++n;
            }
            jarXEntry.cachefile = file.getCanonicalPath();
        } else {
            file = new File(jarXEntry.cachefile);
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected boolean useCacheDir(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (!file.isDirectory() && !file.mkdirs()) {
                this.warning("can't create package cache dir, '" + file + "'");
                return false;
            }
        }
        catch (AccessControlException accessControlException) {
            this.warning("The java security manager isn't allowing access to the package cache dir, '" + file + "'");
            return false;
        }
        this.cachedir = file;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String string2) {
            this.cachefile = string2;
        }

        public JarXEntry(String string2, long l) {
            this.cachefile = string2;
            this.mtime = l;
        }
    }
}

