/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.connection;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.rest.connection.APIConnection;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.directory.DirectoryResource;
import org.apache.guacamole.rest.directory.DirectoryResourceFactory;
import org.apache.guacamole.rest.directory.DirectoryView;
import org.apache.guacamole.rest.history.APIConnectionRecord;
import org.apache.guacamole.rest.sharingprofile.APISharingProfile;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectionResource
extends DirectoryObjectResource<Connection, APIConnection> {
    private final UserContext userContext;
    private final Connection connection;
    @Inject
    private DirectoryResourceFactory<SharingProfile, APISharingProfile> sharingProfileDirectoryResourceFactory;

    @AssistedInject
    public ConnectionResource(@Assisted UserContext userContext, @Assisted Directory<Connection> directory, @Assisted Connection connection, DirectoryObjectTranslator<Connection, APIConnection> translator) {
        super(userContext, directory, (Identifiable)connection, translator);
        this.userContext = userContext;
        this.connection = connection;
    }

    @GET
    @Path(value="parameters")
    public Map<String, String> getConnectionParameters() throws GuacamoleException {
        Permissions effective = this.userContext.self().getEffectivePermissions();
        SystemPermissionSet systemPermissions = effective.getSystemPermissions();
        ObjectPermissionSet connectionPermissions = effective.getConnectionPermissions();
        String identifier = this.connection.getIdentifier();
        if (!systemPermissions.hasPermission(SystemPermission.Type.ADMINISTER) && !connectionPermissions.hasPermission(ObjectPermission.Type.UPDATE, identifier)) {
            throw new GuacamoleSecurityException("Permission to read connection parameters denied.");
        }
        GuacamoleConfiguration config = this.connection.getConfiguration();
        return config.getParameters();
    }

    @GET
    @Path(value="history")
    public List<APIConnectionRecord> getConnectionHistory() throws GuacamoleException {
        ArrayList<APIConnectionRecord> apiRecords = new ArrayList<APIConnectionRecord>();
        for (ConnectionRecord record : this.connection.getHistory()) {
            apiRecords.add(new APIConnectionRecord(record));
        }
        return apiRecords;
    }

    @Path(value="sharingProfiles")
    public DirectoryResource<SharingProfile, APISharingProfile> getSharingProfileDirectoryResource() throws GuacamoleException {
        DirectoryView sharingProfiles = new DirectoryView(this.userContext.getSharingProfileDirectory(), this.connection.getSharingProfileIdentifiers());
        return this.sharingProfileDirectoryResourceFactory.create(this.userContext, (Directory)sharingProfiles);
    }
}

