/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.connection;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.rest.sharingprofile.APISharingProfile;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class APIConnection {
    private String name;
    private String identifier;
    private String parentIdentifier;
    private String protocol;
    private Map<String, String> parameters;
    private Map<String, String> attributes;
    private Collection<APISharingProfile> sharingProfiles;
    private int activeConnections;
    private Date lastActive;

    public APIConnection() {
    }

    public APIConnection(Connection connection) throws GuacamoleException {
        this.name = connection.getName();
        this.identifier = connection.getIdentifier();
        this.parentIdentifier = connection.getParentIdentifier();
        this.activeConnections = connection.getActiveConnections();
        this.lastActive = connection.getLastActive();
        GuacamoleConfiguration configuration = connection.getConfiguration();
        this.protocol = configuration.getProtocol();
        this.attributes = connection.getAttributes();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public void setParentIdentifier(String parentIdentifier) {
        this.parentIdentifier = parentIdentifier;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getActiveConnections() {
        return this.activeConnections;
    }

    public void setActiveUsers(int activeConnections) {
        this.activeConnections = activeConnections;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Collection<APISharingProfile> getSharingProfiles() {
        return this.sharingProfiles;
    }

    public void setSharingProfiles(Collection<APISharingProfile> sharingProfiles) {
        this.sharingProfiles = sharingProfiles;
    }

    public Date getLastActive() {
        return this.lastActive;
    }

    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }
}

