/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.crawl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

class Element {
    QName qname;
    QName attribute;
    String extension;
    Element parent;
    List<Element> children;

    Element(QName qname) {
        this.qname = qname;
    }

    public Element findChild(String namespaceURI, String localName) {
        if (this.children != null) {
            for (Element child : this.children) {
                QName qname = child.qname;
                if (!qname.getNamespaceURI().equals(namespaceURI) || !qname.getLocalPart().equals(localName)) continue;
                return child;
            }
        }
        return null;
    }

    public Element child(QName element) {
        Element child = this.findChild(element.getNamespaceURI(), element.getLocalPart());
        if (child == null) {
            if (this.children == null) {
                this.children = new ArrayList<Element>();
            }
            child = new Element(element);
            this.children.add(child);
            child.parent = this;
        }
        return child;
    }

    public Element descendant(QName ... path) {
        Element child = this;
        for (QName elem : path) {
            child = child.child(elem);
        }
        return child;
    }
}

