/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl;

import java.io.CharArrayWriter;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import jlibs.core.lang.StringUtil;
import jlibs.xml.NamespaceMap;
import jlibs.xml.QNameFake;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.sax.binding.SAXContext;
import jlibs.xml.sax.binding.impl.BindingRelation;
import jlibs.xml.sax.binding.impl.Registry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Handler
extends DefaultHandler {
    public final Registry docRegistry;
    private boolean populateNamespaces = false;
    private Object rootObject;
    private CharArrayWriter content = new CharArrayWriter();
    private NamespaceMap.Handler nsHandler = new NamespaceMap.Handler();
    private Locator locator;
    private QNameFake qnameFake = new QNameFake();
    private BindingContext context;
    private BindingContext cache;

    public Handler(Registry docRegistry) {
        this.docRegistry = docRegistry;
    }

    public boolean isPopulateNamespaces() {
        return this.populateNamespaces;
    }

    public void setPopulateNamespaces(boolean populateNamespaces) {
        this.populateNamespaces = populateNamespaces;
    }

    public Object parse(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        SAXUtil.newSAXParser(true, false, false).parse(is, (DefaultHandler)this);
        return this.reset();
    }

    private Object reset() {
        Object obj = this.rootObject;
        this.context = null;
        this.rootObject = null;
        this.content.reset();
        this.nsHandler.namespaceMap = null;
        return obj;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.populateNamespaces) {
            this.nsHandler.startDocument();
        }
        this.reset();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.populateNamespaces) {
            this.nsHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.populateNamespaces) {
            this.nsHandler.startElement();
        }
        if (this.context != null) {
            this.context.onText();
        }
        this.context = this.newContext(uri, localName, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.write(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.populateNamespaces) {
            this.nsHandler.endElement();
        }
        this.context.onText();
        this.context = this.context.pop();
    }

    public Object getObject() {
        return this.rootObject;
    }

    protected void onUnresolvedElement(SAXContext context) throws SAXException {
    }

    public BindingContext newContext(String namespaceURI, String localPart, Attributes attributes) throws SAXException {
        if (this.cache == null) {
            return new BindingContext(namespaceURI, localPart, this.context, attributes);
        }
        BindingContext reusingContext = this.cache;
        this.cache = this.cache.parent;
        reusingContext.init(namespaceURI, localPart, this.context, attributes);
        return reusingContext;
    }

    private class BindingContext
    extends SAXContext {
        private BindingRelation bindingRelation;
        private BindingContext parent;

        public BindingContext(String namespaceURI, String localPart, BindingContext parent, Attributes attributes) throws SAXException {
            this.init(namespaceURI, localPart, parent, attributes);
        }

        private void init(String namespaceURI, String localPart, BindingContext parent, Attributes attributes) throws SAXException {
            boolean unresolvedElement;
            this.qnameFake = Handler.this.qnameFake;
            this.namespaceMap = ((Handler)Handler.this).nsHandler.namespaceMap;
            this.parent = parent;
            this.bindingRelation = (parent != null ? parent.bindingRelation.binding.registry : Handler.this.docRegistry).get(this.qnameFake.set(namespaceURI, localPart));
            boolean bl = unresolvedElement = this.bindingRelation == null;
            if (unresolvedElement) {
                this.bindingRelation = BindingRelation.DO_NOTHING;
            }
            this.element = this.bindingRelation.qname;
            if (this.element.getNamespaceURI().equals("*") || this.element.getLocalPart().equals("*")) {
                this.element = new QName(namespaceURI, localPart);
            }
            if (parent != null) {
                this.object = parent.object;
            }
            if (unresolvedElement) {
                Handler.this.onUnresolvedElement(this);
            }
            this.bindingRelation.binding.startElement(this.bindingRelation.bindingState, this, attributes);
            if (parent != null) {
                this.bindingRelation.relation.startRelation(this.bindingRelation.relationState, parent, this);
            }
        }

        public void onText() throws SAXException {
            this.bindingRelation.binding.text(this.bindingRelation.bindingState, this, Handler.this.content.toString());
            Handler.this.content.reset();
        }

        public BindingContext pop() throws SAXException {
            this.bindingRelation.binding.endElement(this.bindingRelation.bindingState, this);
            if (this.parent != null) {
                this.bindingRelation.relation.endRelation(this.bindingRelation.relationState, this.parent, this);
            }
            if (this.parent == null) {
                Handler.this.rootObject = this.object;
            }
            BindingContext _parent = this.parent;
            this.namespaceMap = null;
            this.element = null;
            this.object = null;
            this.qnameFake = null;
            if (this.temp != null) {
                this.temp.clear();
            }
            this.bindingRelation = null;
            this.parent = Handler.this.cache;
            Handler.this.cache = this;
            return _parent;
        }

        @Override
        public String xpath() {
            StringBuilder buff = new StringBuilder("/");
            BindingContext context = this;
            while (context != null) {
                String prefix;
                if (buff.length() > 1) {
                    buff.insert(1, '/');
                }
                String qname = this.namespaceMap == null ? context.element.toString() : (StringUtil.isEmpty((CharSequence)(prefix = this.namespaceMap.getPrefix(context.element.getNamespaceURI()))) ? context.element.getLocalPart() : prefix + ":" + context.element.getLocalPart());
                buff.insert(1, qname);
                context = context.parent;
            }
            return buff.toString();
        }

        @Override
        public Locator locator() {
            return Handler.this.locator;
        }
    }
}

