/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BaseBorders {
    private static Border focusFrameBorder = null;
    private static Border textFieldBorder = null;
    private static Border spinnerBorder = null;
    private static Border comboBoxBorder = null;
    private static Border progressBarBorder = null;
    private static Border tableHeaderBorder = null;
    private static Border popupMenuBorder = null;
    private static Border menuItemBorder = null;
    private static Border toolBarBorder = null;
    private static Border toolButtonBorder = null;
    private static Border paletteBorder = null;
    private static Border scrollPaneBorder = null;
    private static Border tableScrollPaneBorder = null;
    private static Border tabbedPaneBorder = null;
    private static Border desktopIconBorder = null;

    public static void initDefaults() {
        textFieldBorder = null;
        spinnerBorder = null;
        comboBoxBorder = null;
        progressBarBorder = null;
        tableHeaderBorder = null;
        popupMenuBorder = null;
        menuItemBorder = null;
        toolBarBorder = null;
        toolButtonBorder = null;
        paletteBorder = null;
        scrollPaneBorder = null;
        tableScrollPaneBorder = null;
        tabbedPaneBorder = null;
        desktopIconBorder = null;
    }

    public static Border getFocusFrameBorder() {
        if (focusFrameBorder == null) {
            focusFrameBorder = new FocusFrameBorder();
        }
        return focusFrameBorder;
    }

    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new SpinnerBorder();
        }
        return spinnerBorder;
    }

    public static Border getTextFieldBorder() {
        return BaseBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getProgressBarBorder() {
        if (progressBarBorder == null) {
            progressBarBorder = BorderFactory.createLineBorder(ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 30.0));
        }
        return progressBarBorder;
    }

    public static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = AbstractLookAndFeel.getTheme().isMenuOpaque() ? new PopupMenuBorder() : new PopupMenuShadowBorder();
        }
        return popupMenuBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new ToolBarBorder();
        }
        return toolBarBorder;
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getMenuBarBorder() {
        return BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public static Border getPaletteBorder() {
        if (paletteBorder == null) {
            paletteBorder = new PaletteBorder();
        }
        return paletteBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder(false);
        }
        return scrollPaneBorder;
    }

    public static Border getTableScrollPaneBorder() {
        if (tableScrollPaneBorder == null) {
            tableScrollPaneBorder = new ScrollPaneBorder(true);
        }
        return tableScrollPaneBorder;
    }

    public static Border getTabbedPaneBorder() {
        if (tabbedPaneBorder == null) {
            tabbedPaneBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        return tabbedPaneBorder;
    }

    public static Border getDesktopIconBorder() {
        if (desktopIconBorder == null) {
            desktopIconBorder = new BorderUIResource.CompoundBorderUIResource(new LineBorder(AbstractLookAndFeel.getWindowBorderColor(), 1), new MatteBorder(2, 2, 1, 2, AbstractLookAndFeel.getWindowBorderColor()));
        }
        return desktopIconBorder;
    }

    public static class Down3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getBackgroundColor();
            JTattooUtilities.draw3DBorder(graphics, ColorHelper.darker(colorUIResource, 20.0), ColorHelper.brighter(colorUIResource, 80.0), n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(Down3DBorder.insets.top, Down3DBorder.insets.left, Down3DBorder.insets.bottom, Down3DBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = Down3DBorder.insets.left;
            insets.top = Down3DBorder.insets.top;
            insets.right = Down3DBorder.insets.right;
            insets.bottom = Down3DBorder.insets.bottom;
            return insets;
        }
    }

    public static class BaseInternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        protected final int dw = 5;
        protected final int trackWidth = 22;
        protected final Insets insets = new Insets(5, 5, 5, 5);
        protected final Insets paletteInsets = new Insets(3, 3, 3, 3);

        public BaseInternalFrameBorder() {
            this.insets.top = 5;
        }

        public boolean isResizable(Component component) {
            boolean bl = true;
            if (component instanceof JDialog) {
                JDialog jDialog = (JDialog)component;
                bl = jDialog.isResizable();
            } else if (component instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)component;
                bl = jInternalFrame.isResizable();
            } else if (component instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)component;
                if (jRootPane.getParent() instanceof JFrame) {
                    JFrame jFrame = (JFrame)component.getParent();
                    bl = jFrame.isResizable();
                } else if (jRootPane.getParent() instanceof JDialog) {
                    JDialog jDialog = (JDialog)component.getParent();
                    bl = jDialog.isResizable();
                }
            }
            return bl;
        }

        public boolean isActive(Component component) {
            JRootPane jRootPane;
            boolean bl = true;
            if (component instanceof JDialog) {
                JDialog jDialog = (JDialog)component;
                if (jDialog.getParent() instanceof JComponent) {
                    return JTattooUtilities.isActive((JComponent)jDialog.getParent());
                }
            } else if (component instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)component;
                bl = jInternalFrame.isSelected();
                if (bl) {
                    return JTattooUtilities.isActive(jInternalFrame);
                }
            } else if (component instanceof JRootPane && (jRootPane = (JRootPane)component).getTopLevelAncestor() instanceof Window) {
                Window window = (Window)jRootPane.getTopLevelAncestor();
                return JTattooUtilities.isWindowActive(window);
            }
            return bl;
        }

        public int getTitleHeight(Component component) {
            int n = 21;
            int n2 = this.getBorderInsets((Component)component).top + this.getBorderInsets((Component)component).bottom;
            if (component instanceof JDialog) {
                JDialog jDialog = (JDialog)component;
                n = jDialog.getSize().height - jDialog.getContentPane().getSize().height - n2 - 1;
                if (jDialog.getJMenuBar() != null) {
                    n -= jDialog.getJMenuBar().getSize().height;
                }
            } else if (component instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)component;
                n = jInternalFrame.getSize().height - jInternalFrame.getRootPane().getSize().height - n2 - 1;
                if (jInternalFrame.getJMenuBar() != null) {
                    n -= jInternalFrame.getJMenuBar().getSize().height;
                }
            } else if (component instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)component;
                if (jRootPane.getParent() instanceof JFrame) {
                    JFrame jFrame = (JFrame)component.getParent();
                    n = jFrame.getSize().height - jFrame.getContentPane().getSize().height - n2 - 1;
                    if (jFrame.getJMenuBar() != null) {
                        n -= jFrame.getJMenuBar().getSize().height;
                    }
                } else if (jRootPane.getParent() instanceof JDialog) {
                    JDialog jDialog = (JDialog)component.getParent();
                    n = jDialog.getSize().height - jDialog.getContentPane().getSize().height - n2 - 1;
                    if (jDialog.getJMenuBar() != null) {
                        n -= jDialog.getJMenuBar().getSize().height;
                    }
                }
            }
            return n;
        }

        public Insets getBorderInsets(Component component) {
            if (this.isResizable(component)) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            return new Insets(this.paletteInsets.top, this.paletteInsets.left, this.paletteInsets.bottom, this.paletteInsets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            insets.left = insets2.left;
            insets.top = insets2.top;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom;
            return insets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (JTattooUtilities.isFrameActive((JComponent)component)) {
                graphics.setColor(AbstractLookAndFeel.getWindowBorderColor());
            } else {
                graphics.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
            }
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(PaletteBorder.insets.top, PaletteBorder.insets.left, PaletteBorder.insets.bottom, PaletteBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = PaletteBorder.insets.left;
            insets.top = PaletteBorder.insets.top;
            insets.right = PaletteBorder.insets.right;
            insets.bottom = PaletteBorder.insets.bottom;
            return insets;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
            Color color = ColorHelper.brighter(colorUIResource, 10.0);
            Color color2 = ColorHelper.darker(colorUIResource, 30.0);
            JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
            if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                JTattooUtilities.draw3DBorder(graphics, color2, color, n, n2, n3, n4);
            } else {
                JTattooUtilities.draw3DBorder(graphics, color2, color, n, n2, n3, n4);
                JTattooUtilities.draw3DBorder(graphics, color, color2, n + 1, n2 + 1, n3 - 2, n4 - 2);
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ToolButtonBorder.insets.top, ToolButtonBorder.insets.left, ToolButtonBorder.insets.bottom, ToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ToolButtonBorder.insets.left;
            insets.top = ToolButtonBorder.insets.top;
            insets.right = ToolButtonBorder.insets.right;
            insets.bottom = ToolButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private static final Color shadow = new Color(160, 160, 160);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((JToolBar)component).isFloatable()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
                graphics2D.setComposite(alphaComposite);
                if (((JToolBar)component).getOrientation() == 0) {
                    if (!JTattooUtilities.isLeftToRight(component)) {
                        n += n3 - 15;
                    }
                    graphics.setColor(Color.white);
                    graphics.drawLine(n + 3, n2 + 4, n + 3, n4 - 5);
                    graphics.drawLine(n + 6, n2 + 3, n + 6, n4 - 4);
                    graphics.drawLine(n + 9, n2 + 4, n + 9, n4 - 5);
                    graphics.setColor(shadow);
                    graphics.drawLine(n + 4, n2 + 4, n + 4, n4 - 5);
                    graphics.drawLine(n + 7, n2 + 3, n + 7, n4 - 4);
                    graphics.drawLine(n + 10, n2 + 4, n + 10, n4 - 5);
                } else {
                    graphics.setColor(Color.white);
                    graphics.drawLine(n + 3, n2 + 3, n3 - 4, n2 + 3);
                    graphics.drawLine(n + 3, n2 + 6, n3 - 4, n2 + 6);
                    graphics.drawLine(n + 3, n2 + 9, n3 - 4, n2 + 9);
                    graphics.setColor(shadow);
                    graphics.drawLine(n + 3, n2 + 4, n3 - 4, n2 + 4);
                    graphics.drawLine(n + 3, n2 + 7, n3 - 4, n2 + 7);
                    graphics.drawLine(n + 3, n2 + 10, n3 - 4, n2 + 10);
                }
                graphics2D.setComposite(composite);
            }
        }

        public Insets getBorderInsets(Component component) {
            Insets insets;
            Insets insets2 = new Insets(2, 2, 2, 2);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (JTattooUtilities.isLeftToRight(component)) {
                        insets2.left = 15;
                    } else {
                        insets2.right = 15;
                    }
                } else {
                    insets2.top = 15;
                }
            }
            if ((insets = ((JToolBar)component).getMargin()) != null) {
                insets2.left += insets.left;
                insets2.top += insets.top;
                insets2.right += insets.right;
                insets2.bottom += insets.bottom;
            }
            return insets2;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            insets.left = insets2.left;
            insets.top = insets2.top;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom;
            return insets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            ColorUIResource colorUIResource = AbstractLookAndFeel.getFrameColor();
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 50.0);
            if (component.getParent() instanceof JMenuBar) {
                if (buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(colorUIResource);
                    graphics.drawLine(n, n2, n + n3 - 1, n2);
                    graphics.drawLine(n, n2, n, n2 + n4 - 1);
                    graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.setColor(color);
                    graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
                }
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(colorUIResource);
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.setColor(color);
                graphics.drawLine(n, n2 + 1, n + n3 - 2, n2 + 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(MenuItemBorder.insets.top, MenuItemBorder.insets.left, MenuItemBorder.insets.bottom, MenuItemBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = MenuItemBorder.insets.left;
            insets.top = MenuItemBorder.insets.top;
            insets.right = MenuItemBorder.insets.right;
            insets.bottom = MenuItemBorder.insets.bottom;
            return insets;
        }
    }

    public static class PopupMenuShadowBorder
    extends PopupMenuBorder {
        private static final int shadowSize = 3;

        public PopupMenuShadowBorder() {
            this.logoInsets = new Insets(2, 18, 4, 4);
            this.insets = new Insets(2, 1, 4, 4);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            int n5 = this.getBorderInsets((Component)component).left;
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getFrameColor();
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 50.0);
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2, n5 - 1, n4 - 1 - 3);
            if (this.hasLogo()) {
                this.paintLogo(graphics2D, n5, n4 - 3);
            }
            alphaComposite = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            graphics2D.setComposite(alphaComposite);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2 + 1, n + n5, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n + n5, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n + n5 - 1, n2 + 1, n + n5 - 1, n2 + n4 - 3 - 1);
            graphics.drawRect(n, n2, n3 - 3 - 1, n4 - 3 - 1);
            graphics2D.setColor(Color.black);
            float f = 0.6f;
            for (int i = 0; i < 3; ++i) {
                alphaComposite = AlphaComposite.getInstance(3, f);
                graphics2D.setComposite(alphaComposite);
                graphics.drawLine(n + n3 - 3 + i, n2 + 3, n + n3 - 3 + i, n2 + n4 - 3 - 1 + i);
                graphics.drawLine(n + 3, n2 + n4 - 3 + i, n + n3 - 3 + i, n2 + n4 - 3 + i);
                f -= f / 2.0f;
            }
            graphics2D.setComposite(composite);
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Font logoFont = new Font("Dialog", 1, 12);
        protected Insets logoInsets = new Insets(2, 18, 1, 1);
        protected Insets insets = new Insets(2, 1, 1, 1);

        public boolean hasLogo() {
            return AbstractLookAndFeel.getTheme().getLogoString() != null && AbstractLookAndFeel.getTheme().getLogoString().length() > 0;
        }

        public void paintLogo(Graphics2D graphics2D, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            graphics2D2.setColor(colorUIResource);
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.setFont(logoFont);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(4.71238898038469);
            graphics2D2.setTransform(affineTransform);
            int n3 = -n2 + 4;
            int n4 = fontMetrics.getAscent() + 2;
            graphics2D2.setColor(ColorHelper.darker(colorUIResource, 20.0));
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3 - 1, n4 + 1);
            graphics2D2.setColor(Color.white);
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3, n4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            TexturePaint texturePaint = new TexturePaint(bufferedImage, double_);
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, 0, n, n2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = this.getBorderInsets((Component)component).left;
            ColorUIResource colorUIResource = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getMenuBackgroundColor();
            ColorUIResource colorUIResource3 = AbstractLookAndFeel.getFrameColor();
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 50.0);
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2, n5 - 1, n4 - 1);
            if (this.hasLogo()) {
                this.paintLogo((Graphics2D)graphics, n5, n4);
            }
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2 + 1, n + n5, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
            graphics.setColor(ColorHelper.brighter(colorUIResource2, 50.0));
            graphics.drawLine(n + n5, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n + n5 - 1, n2 + 1, n + n5 - 1, n2 + n4 - 1);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            if (this.hasLogo()) {
                return new Insets(this.logoInsets.top, this.logoInsets.left, this.logoInsets.bottom, this.logoInsets.right);
            }
            return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            insets.left = insets2.left;
            insets.top = insets2.top;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom;
            return insets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);
        private static final Insets tableInsets = new Insets(1, 1, 1, 1);
        private boolean tableBorder = false;

        public ScrollPaneBorder(boolean bl) {
            this.tableBorder = bl;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 50.0));
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        }

        public Insets getBorderInsets(Component component) {
            if (this.tableBorder) {
                return new Insets(ScrollPaneBorder.tableInsets.top, ScrollPaneBorder.tableInsets.left, ScrollPaneBorder.tableInsets.bottom, ScrollPaneBorder.tableInsets.right);
            }
            return new Insets(ScrollPaneBorder.insets.top, ScrollPaneBorder.insets.left, ScrollPaneBorder.insets.bottom, ScrollPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            insets.left = insets2.left;
            insets.top = insets2.top;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom;
            return insets;
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 0);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getControlHighlight();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlShadow();
            JTattooUtilities.draw3DBorder(graphics, colorUIResource, colorUIResource2, n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(TableHeaderBorder.insets.top, TableHeaderBorder.insets.left, TableHeaderBorder.insets.bottom, TableHeaderBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = TableHeaderBorder.insets.left;
            insets.top = TableHeaderBorder.insets.top;
            insets.right = TableHeaderBorder.insets.right;
            insets.bottom = TableHeaderBorder.insets.bottom;
            return insets;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ComboBoxBorder.insets.top, ComboBoxBorder.insets.left, ComboBoxBorder.insets.bottom, ComboBoxBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ComboBoxBorder.insets.left;
            insets.top = ComboBoxBorder.insets.top;
            insets.right = ComboBoxBorder.insets.right;
            insets.bottom = ComboBoxBorder.insets.bottom;
            return insets;
        }
    }

    public static class SpinnerBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(SpinnerBorder.insets.top, SpinnerBorder.insets.left, SpinnerBorder.insets.bottom, SpinnerBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = SpinnerBorder.insets.left;
            insets.top = SpinnerBorder.insets.top;
            insets.right = SpinnerBorder.insets.right;
            insets.bottom = SpinnerBorder.insets.bottom;
            return insets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(TextFieldBorder.insets.top, TextFieldBorder.insets.left, TextFieldBorder.insets.bottom, TextFieldBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = TextFieldBorder.insets.left;
            insets.top = TextFieldBorder.insets.top;
            insets.right = TextFieldBorder.insets.right;
            insets.bottom = TextFieldBorder.insets.bottom;
            return insets;
        }
    }

    public static class FocusFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 60.0);
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getFocusFrameColor();
            graphics.setColor(colorUIResource);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(color);
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(FocusFrameBorder.insets.top, FocusFrameBorder.insets.left, FocusFrameBorder.insets.bottom, FocusFrameBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = FocusFrameBorder.insets.left;
            insets.top = FocusFrameBorder.insets.top;
            insets.right = FocusFrameBorder.insets.right;
            insets.bottom = FocusFrameBorder.insets.bottom;
            return insets;
        }
    }
}

