/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JTabbedPane;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.TabbedPaneState;

public class TabbedPaneProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JTabbedPane)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component c) {
        this.checkComponent(c);
        JTabbedPane p = (JTabbedPane)c;
        return new TabbedPaneState(p.getSelectedIndex(), p.getTabCount());
    }

    @Override
    public void setSessionState(Component c, Object state) {
        this.checkComponent(c);
        if (state == null) {
            return;
        }
        if (state instanceof TabbedPaneState) {
            JTabbedPane p = (JTabbedPane)c;
            TabbedPaneState tps = (TabbedPaneState)state;
            if (p.getTabCount() == tps.getTabCount()) {
                p.setSelectedIndex(tps.getSelectedIndex());
            }
        } else {
            throw new IllegalArgumentException("invalid state");
        }
    }
}

