/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabbedPaneMouseMotionListener _tabbedBarMouseMotionListener;
    private TabbedPaneMouseListener _tabbedBarMouseListener;
    private int _mouseOverTab = -1;

    public static ComponentUI createUI(JComponent component) {
        return new SquarenessTabbedPaneUI();
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        this._tabbedBarMouseListener = new TabbedPaneMouseListener();
        this._tabbedBarMouseMotionListener = new TabbedPaneMouseMotionListener();
        this.tabPane.addMouseListener(this._tabbedBarMouseListener);
        this.tabPane.addMouseMotionListener(this._tabbedBarMouseMotionListener);
    }

    public void uninstallUI(JComponent component) {
        this.tabPane.removeMouseListener(this._tabbedBarMouseListener);
        this.tabPane.removeMouseMotionListener(this._tabbedBarMouseMotionListener);
        super.uninstallUI(component);
    }

    protected void paintTabBackground(Graphics graphics, int tabPlacement, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        Color oldColor = graphics.getColor();
        ColorUIResource background = !isSelected && this._mouseOverTab == tabIndex ? SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor();
        graphics.setColor(background);
        graphics.fillRect(x, y, width, height);
        graphics.setColor(oldColor);
    }

    protected void paintTabBorder(Graphics graphics, int tabPlacement, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        Color oldColor = graphics.getColor();
        Color borderColor = !isSelected && this._mouseOverTab == tabIndex ? SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor().darker() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(borderColor);
        graphics.translate(x, y);
        if (isSelected || this._mouseOverTab == tabIndex) {
            switch (tabPlacement) {
                case 1: {
                    this.paintHorizontalTabBorder(graphics, height, width, true);
                    break;
                }
                case 3: {
                    this.paintHorizontalTabBorder(graphics, height, width, false);
                    break;
                }
                case 2: {
                    this.paintVerticalTabBorder(graphics, height, width, true);
                    break;
                }
                case 4: {
                    this.paintVerticalTabBorder(graphics, height, width, false);
                }
            }
        } else {
            int tabCount = this.tabPane.getTabCount();
            if (this.lastTabInRun(tabCount, this.getRunForTab(tabCount, tabIndex)) != tabIndex && this.tabPane.getSelectedIndex() - tabIndex != 1) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        graphics.drawLine(width - 1, 3, width - 1, height - 1 - 3);
                        break;
                    }
                    case 2: 
                    case 4: {
                        graphics.drawLine(4, height - 1, width - 1 - 4, height - 1);
                    }
                }
            }
        }
        graphics.translate(-x, -y);
        graphics.setColor(oldColor);
    }

    private void paintVerticalTabBorder(Graphics graphics, int height, int width, boolean isPlacedLeft) {
        graphics.drawLine(0, 0, width - 1, 0);
        if (isPlacedLeft) {
            graphics.drawLine(0, 0, 0, height - 1);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
        } else {
            graphics.drawLine(width - 1, 0, width - 1, height - 1);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
        }
    }

    private void paintHorizontalTabBorder(Graphics graphics, int height, int width, boolean isPlacedTop) {
        graphics.drawLine(0, 0, 0, height - 1);
        graphics.drawLine(width - 1, 0, width - 1, height - 1);
        if (isPlacedTop) {
            graphics.drawLine(0, 0, width - 1, 0);
        } else {
            graphics.drawLine(0, height - 1, width - 1, height - 1);
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
        Rectangle selRect;
        Color oldColor = graphics.getColor();
        ColorUIResource borderColor = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(borderColor);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + width) {
            graphics.drawLine(x, y, x + width - 1, y);
        } else {
            graphics.drawLine(x, y, selRect.x, y);
            if (selRect.x + selRect.width < x + width - 1) {
                graphics.drawLine(selRect.x + selRect.width - 1, y, x + width - 1, y);
            }
        }
        graphics.setColor(oldColor);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
        Rectangle selRect;
        Color oldColor = graphics.getColor();
        ColorUIResource borderColor = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(borderColor);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > width || selRect.y < y || selRect.y > y + height) {
            graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        } else {
            graphics.drawLine(x + width - 1, y, x + width - 1, selRect.y);
            if (selRect.y + selRect.height < y + height - 1) {
                graphics.drawLine(x + width - 1, selRect.y + selRect.height - 1, x + width - 1, y + height - 1);
            }
        }
        graphics.setColor(oldColor);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
        Rectangle selRect;
        Color oldColor = graphics.getColor();
        ColorUIResource borderColor = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(borderColor);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + height) {
            graphics.drawLine(x, y, x, y + height - 1);
        } else {
            graphics.drawLine(x, y, x, selRect.y);
            if (selRect.y + selRect.height < y + height - 1) {
                graphics.drawLine(x, selRect.y + selRect.height - 1, x, y + height - 1);
            }
        }
        graphics.setColor(oldColor);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
        Rectangle selRect;
        Color oldColor = graphics.getColor();
        ColorUIResource borderColor = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(borderColor);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > height || selRect.x < x || selRect.x > x + width) {
            graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        } else {
            graphics.drawLine(x, y + height - 1, selRect.x, y + height - 1);
            if (selRect.x + selRect.width < x + width - 1) {
                graphics.drawLine(selRect.x + selRect.width - 1, y + height - 1, x + width - 1, y + height - 1);
            }
        }
        graphics.setColor(oldColor);
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        private TabbedPaneMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SquarenessTabbedPaneUI.this._mouseOverTab >= 0) {
                SquarenessTabbedPaneUI.this._mouseOverTab = -1;
                SquarenessTabbedPaneUI.this.tabPane.repaint();
            }
        }
    }

    private class TabbedPaneMouseMotionListener
    extends MouseMotionAdapter {
        private TabbedPaneMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean found = false;
            for (int i = 0; !found && i < SquarenessTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                if (!SquarenessTabbedPaneUI.this.getTabBounds(SquarenessTabbedPaneUI.this.tabPane, i).contains(mouseEvent.getPoint())) continue;
                found = true;
                if (SquarenessTabbedPaneUI.this._mouseOverTab == i) continue;
                SquarenessTabbedPaneUI.this._mouseOverTab = i;
                SquarenessTabbedPaneUI.this.tabPane.repaint();
            }
            if (!found && SquarenessTabbedPaneUI.this._mouseOverTab >= 0) {
                SquarenessTabbedPaneUI.this._mouseOverTab = -1;
                SquarenessTabbedPaneUI.this.tabPane.repaint();
            }
        }
    }
}

