/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.io.IOException;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.MyReader;

public class IconEntry {
    private final boolean DEBUG = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.debug", Boolean.toString(false)));
    private int width;
    private int height;
    private int colorCount;
    private int reserved;
    private int planes;
    private int bitCount;
    private int bytesInResource;
    private int imageOffset;
    private byte[] imageData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IconEntry(MyReader reader) throws IOException {
        this.width = reader.readBYTE();
        this.height = reader.readBYTE();
        this.colorCount = reader.readBYTE();
        this.reserved = reader.readBYTE();
        this.planes = reader.readWORD();
        this.bitCount = reader.readWORD();
        this.bytesInResource = reader.readDWORD();
        this.imageOffset = reader.readDWORD();
        reader.mark();
        try {
            int offset = reader.getOffset();
            int skip = this.imageOffset - offset;
            if (skip < 0) {
                System.err.println("Error.... unable to figure out how much bytes to skip to get to offset: " + this.imageOffset + "  current offset: " + offset);
                return;
            }
            reader.skip(skip);
            this.imageData = reader.readBytes(this.bytesInResource);
        }
        finally {
            reader.reset();
        }
        if (this.bitCount == 0 && this.imageOffset > 0) {
            int newbpp;
            if (this.DEBUG) {
                System.out.println("bitCount field is missing (bits per pixel): trying to fetch it from the imagedata");
            }
            this.bitCount = newbpp = Bitmap.readBitCountFromData(this.imageData);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("IconEntry [");
        sb.append("w=").append(this.width);
        sb.append(", h=").append(this.height);
        sb.append(", bitCount(bpp)=").append(this.bitCount);
        sb.append(", colorCount=").append(this.colorCount);
        sb.append(", reserved=").append(this.reserved);
        sb.append(", planes=").append(this.planes);
        sb.append(", bytesInResource=").append(this.bytesInResource);
        sb.append(", imageOffset=").append(this.imageOffset);
        sb.append(", imageData=").append(this.imageData);
        sb.append(" ]");
        return sb.toString();
    }

    public Bitmap getImageIoBitmap() throws IOException {
        return Bitmap.getImageIoBitmap(this);
    }

    public Bitmap getBitmap() throws IOException {
        return Bitmap.getBitmap(this);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getBytesInResource() {
        return this.bytesInResource;
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public int getImageOffset() {
        return this.imageOffset;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getReserved() {
        return this.reserved;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public void setPlanes(int planes) {
        this.planes = planes;
    }

    public void setImageOffset(int imageOffset) {
        this.imageOffset = imageOffset;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setColorCount(int colorCount) {
        this.colorCount = colorCount;
    }

    public void setBytesInResource(int bytesInResource) {
        this.bytesInResource = bytesInResource;
    }

    public void setBitCount(int bitCount) {
        this.bitCount = bitCount;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }
}

