/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.write;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.util.MapBackedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteException
extends IOException {
    private final List<WriteRequest> requests;

    public WriteException(WriteRequest writeRequest) {
        this.requests = WriteException.asRequestList(writeRequest);
    }

    public WriteException(Collection<WriteRequest> collection) {
        this.requests = WriteException.asRequestList(collection);
    }

    private static List<WriteRequest> asRequestList(Collection<WriteRequest> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("requests");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("requests is empty.");
        }
        MapBackedSet mapBackedSet = new MapBackedSet(new LinkedHashMap());
        for (WriteRequest writeRequest : collection) {
            mapBackedSet.add(writeRequest.getOriginalRequest());
        }
        return Collections.unmodifiableList(new ArrayList(mapBackedSet));
    }

    private static List<WriteRequest> asRequestList(WriteRequest writeRequest) {
        if (writeRequest == null) {
            throw new IllegalArgumentException("request");
        }
        ArrayList<WriteRequest> arrayList = new ArrayList<WriteRequest>(1);
        arrayList.add(writeRequest.getOriginalRequest());
        return Collections.unmodifiableList(arrayList);
    }
}

