/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.UpdateManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.PopdownButton;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Task;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;

public class UpdateDialog
extends AppDialog
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(UpdateDialog.class.getName());
    private final ManagerDirector managerDirector;
    private static final int COLUMN_SELECTED = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_VERSION = 2;
    private static final int COLUMN_SERVICES = 3;
    private static final int COLUMN_AUTHOR = 4;
    private static final int COLUMN_PROGRESS = 5;
    private static final int COLUMN_STATUS = 6;
    private ArrayListModel<WrappedPluginData> listModel = new ArrayListModel();
    private PopdownButton popmenuButton;
    private JXTable table;
    private JLabel labelServer;
    private JLabel labelUpdatesCount;
    private JButton btnOK;
    private JButton btnCancel;

    public UpdateDialog(Frame owner, ManagerDirector managerDirector) throws HeadlessException {
        super(owner, true);
        this.managerDirector = managerDirector;
        this.setName("UpdateDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.btnOK, "okBtnAction");
        this.setAction(this.btnCancel, "btnCancelAction");
    }

    @Action
    public void okBtnAction() {
        this.getActionMap().get("okBtnAction").setEnabled(false);
        this.table.setEditable(false);
        Swinger.inputFocus(this.btnCancel);
        UpdateManager updateManager = this.managerDirector.getUpdateManager();
        Task task = updateManager.getDownloadPluginsTask(new LinkedList<WrappedPluginData>(this.listModel), false);
        if (task == null) {
            return;
        }
        updateManager.executeUpdateTask(task);
    }

    @Action
    public void btnCancelAction() {
        this.doClose();
    }

    @Action
    public void btnCloseAction() {
        this.doClose();
    }

    private void buildGUI() {
        this.initTable();
        this.labelServer.setText(AppPrefs.getProperty("pluginCheckUrlSelected", "http://wordrider.net/freerapid/pluginsCheck.php"));
        Swinger.inputFocus(this.table);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadFile downloadFile = (DownloadFile)evt.getSource();
                UpdateDialog.this.listModel.fireContentsChanged(UpdateDialog.this.getIndex(downloadFile));
            }
        });
    }

    private int getIndex(DownloadFile downloadFile) {
        int index = 0;
        for (WrappedPluginData data : this.listModel) {
            if (data.getHttpFile().equals(downloadFile)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void initTable() {
        this.buildPopmenuButton(this.popmenuButton.getPopupMenu());
        this.table.setName("updatePluginsTable");
        this.table.setModel(new CustomTableModel(this.listModel, this.getList("columns", 7)));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(true);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(true);
        this.table.setRolloverEnabled(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.createDefaultColumnsFromModel();
        this.table.setSelectionMode(0);
        Swinger.updateColumn(this.table, "Selected", 0, 25, 40, null).setMaxWidth(75);
        Swinger.updateColumn(this.table, "Name", 1, -1, 70, null);
        Swinger.updateColumn(this.table, "Version", 2, -1, 50, null);
        Swinger.updateColumn(this.table, "Services", 3, -1, 50, null);
        Swinger.updateColumn(this.table, "Author", 4, -1, 50, null);
        Swinger.updateColumn(this.table, "Progress", 5, -1, 70, new ProgressBarCellRenderer());
        Swinger.updateColumn(this.table, "Status", 6, -1, 80, null);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!UpdateDialog.this.table.hasFocus()) {
                    Swinger.inputFocus(UpdateDialog.this.table);
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    SwingUtils.showPopMenu(UpdateDialog.this.popmenuButton.getPopupMenu(), e, UpdateDialog.this.table, UpdateDialog.this);
                }
            }
        });
        InputMap tableInputMap = this.table.getInputMap();
        ActionMap tableActionMap = this.table.getActionMap();
        ActionMap actionMap = this.getActionMap();
        tableInputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        tableActionMap.put("copy", actionMap.get("copyContent"));
        KeyStroke ctrlF = SwingUtils.getCtrlKeyStroke(70);
        tableInputMap.remove(ctrlF);
        this.table.getParent().setPreferredSize(new Dimension(450, 250));
        tableInputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        tableInputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
    }

    public void initData(List<WrappedPluginData> list) {
        this.cleanup();
        this.labelUpdatesCount.setText(this.getResourceMap().getString("labelUpdatesCount", list.size()));
        this.listModel.clear();
        for (WrappedPluginData wrappedPluginData : list) {
            wrappedPluginData.getHttpFile().addPropertyChangeListener(this);
            this.listModel.add(wrappedPluginData);
        }
    }

    @Override
    public void doClose() {
        super.doClose();
        this.cleanup();
    }

    private void cleanup() {
        for (WrappedPluginData data : this.listModel) {
            data.getHttpFile().removePropertyChangeListener(this);
        }
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.table = new JXTable();
        JPanel topPanel = new JPanel();
        JLabel labelUpdateServer = new JLabel();
        this.labelServer = new JLabel();
        this.labelUpdatesCount = new JLabel();
        this.popmenuButton = ComponentFactory.getPopdownButton();
        this.popmenuButton.setName("popmenuButton");
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout(4, 4));
        scrollPane1.setViewportView(this.table);
        contentPanel.add((Component)scrollPane1, "Center");
        labelUpdateServer.setName("labelUpdateServer");
        this.labelServer.setName("server");
        this.labelUpdatesCount.setName("labelUpdatesCount");
        PanelBuilder topPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("default")), topPanel);
        topPanelBuilder.add((Component)labelUpdateServer, cc.xy(1, 1));
        topPanelBuilder.add((Component)this.labelServer, cc.xy(3, 1));
        topPanelBuilder.add((Component)this.labelUpdatesCount, cc.xy(7, 1));
        contentPanel.add((Component)topPanel, "North");
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        buttonBar.setCyclic(true);
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.GLUE_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.PREF_COLSPEC}, RowSpec.decodeSpecs("pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{2, 4, 6}});
        buttonBarBuilder.add((Component)this.popmenuButton, cc.xy(2, 1));
        buttonBarBuilder.add((Component)this.btnOK, cc.xy(4, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(6, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    @Action
    public void deSelectAll() {
        this.checkOrUncheckPlugin(Boolean.FALSE, 0);
    }

    @Action
    public void selectAll() {
        this.checkOrUncheckPlugin(Boolean.TRUE, 0);
    }

    private void buildPopmenuButton(JPopupMenu popupMenu) {
        JMenuItem menuItem1 = new JMenuItem();
        menuItem1.setAction(this.getActionMap().get("selectAll"));
        popupMenu.add(menuItem1);
        JMenuItem menuItem2 = new JMenuItem();
        menuItem2.setAction(this.getActionMap().get("deSelectAll"));
        popupMenu.add(menuItem2);
    }

    private void checkOrUncheckPlugin(Object value, int columnIndex) {
        CustomTableModel tableModel = (CustomTableModel)this.table.getModel();
        int count = tableModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            tableModel.setValueAt(value, i, columnIndex);
        }
    }

    private static class ProgressBarCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        public ProgressBarCellRenderer() {
            super(0, 100);
            int h = this.getPreferredSize().height;
            this.setPreferredSize(new Dimension(70, h));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DownloadFile downloadFile = (DownloadFile)value;
            this.setToolTipText(null);
            int progress = ContentPanel.getProgress(downloadFile);
            this.setStringPainted(true);
            this.setString(progress + "%");
            this.setValue(progress);
            return this;
        }
    }

    private class CustomTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private final ArrayListModel<WrappedPluginData> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<WrappedPluginData> model, String[] columns) {
            this.model = model;
            this.columns = columns;
            model.addListDataListener(this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((WrappedPluginData)this.model.get(rowIndex)).setSelected((Boolean)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WrappedPluginData item = (WrappedPluginData)this.model.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item.isSelected();
                }
                case 1: {
                    return item.getID();
                }
                case 2: {
                    return item.getVersion();
                }
                case 3: {
                    return item.getServices();
                }
                case 4: {
                    return item.getAuthor();
                }
                case 5: {
                    return item.getHttpFile();
                }
                case 6: {
                    return this.getStatus(item);
                }
            }
            assert (false);
            return item;
        }

        private Object getStatus(WrappedPluginData item) {
            DownloadState state = item.getHttpFile().getState();
            if (state == DownloadState.PAUSED || state == DownloadState.QUEUED) {
                if (item.isToBeDeleted()) {
                    return UpdateDialog.this.getResourceMap().getString("stateOldPlugin", new Object[0]);
                }
                if (item.isNew()) {
                    return UpdateDialog.this.getResourceMap().getString("stateNew", new Object[0]);
                }
                return UpdateDialog.this.getResourceMap().getString("stateNotActualized", new Object[0]);
            }
            if (state == DownloadState.CANCELLED) {
                return UpdateDialog.this.getResourceMap().getString("stateCancelled", new Object[0]);
            }
            if (state == DownloadState.ERROR) {
                return UpdateDialog.this.getResourceMap().getString("stateError", new Object[0]) + ":" + item.getHttpFile().getErrorMessage();
            }
            if (state == DownloadState.COMPLETED) {
                return UpdateDialog.this.getResourceMap().getString("stateActualized", new Object[0]);
            }
            return null;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
        }
    }
}

