/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugins.container.ContainerException;
import cz.vity.freerapid.plugins.container.ContainerPlugin;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.exceptions.ServiceConnectionProblemException;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ExportLinksTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(ExportLinksTask.class.getName());
    private final MainApp app;
    private final ContainerPlugin plugin;
    private final List<DownloadFile> fileList;
    private final File destination;

    public ExportLinksTask(MainApp app, ContainerPlugin plugin, List<DownloadFile> fileList, File destination) {
        super(app);
        this.app = app;
        this.plugin = plugin;
        this.fileList = fileList;
        this.destination = destination;
        this.setTaskToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        OutputStream stream = null;
        try {
            List<ConnectionSettings> settingsList = this.app.getManagerDirector().getClientManager().getAvailableConnections();
            this.plugin.setConnectionSettings(settingsList.isEmpty() ? null : settingsList.get(0));
            this.plugin.setDialogSupport(new StandardDialogSupportImpl(this.app.getContext()));
            this.message("exportingLinks", Utils.shortenFileName(this.destination));
            ArrayList<FileInfo> infoList = new ArrayList<FileInfo>(this.fileList.size());
            for (DownloadFile file : this.fileList) {
                infoList.add(file.toFileInfo());
            }
            stream = new FileOutputStream(this.destination);
            this.plugin.write(infoList, stream, this.destination.toString());
            Void void_ = null;
            return void_;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
    }

    @Override
    protected void failed(Throwable cause) {
        LogUtils.processException(logger, cause);
        if (cause instanceof ContainerException) {
            Swinger.showErrorMessage(this.getResourceMap(), cause.getMessage(), new Object[0]);
        } else if (cause instanceof ServiceConnectionProblemException) {
            if ("noAvailableConnection".equals(cause.getMessage())) {
                Swinger.showErrorMessage(this.getResourceMap(), "noAvailableConnection", new Object[0]);
            } else {
                Swinger.showErrorMessage(this.getResourceMap(), "connectionProblem", Utils.getThrowableDescription(cause));
            }
        } else if (cause instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "otherProblem", Utils.getThrowableDescription(cause));
        }
    }

    @Override
    protected void succeeded(Void result) {
        Swinger.showInformationDialog(this.getResourceMap().getString("successfullyExported", Utils.shortenFileName(this.destination, 60)));
    }
}

