/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.ArgumentImpl;
import org.apache.commons.cli2.resource.ResourceHelper;

public class SourceDestArgument
extends ArgumentImpl {
    private final Argument source;
    private final Argument dest;

    public SourceDestArgument(Argument source, Argument dest) {
        this(source, dest, '\u0000', '\u0000', "--", null);
    }

    public SourceDestArgument(Argument source, Argument dest, char initialSeparator, char subsequentSeparator, String consumeRemaining, List defaultValues) {
        super("SourceDestArgument", null, SourceDestArgument.sum(source.getMinimum(), dest.getMinimum()), SourceDestArgument.sum(source.getMaximum(), dest.getMaximum()), initialSeparator, subsequentSeparator, null, consumeRemaining, defaultValues, 0);
        this.source = source;
        this.dest = dest;
        if (dest.getMinimum() != dest.getMaximum()) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("SourceDest.must.enforce.values"));
        }
    }

    private static int sum(int a, int b) {
        return Math.max(a, Math.max(b, a + b));
    }

    @Override
    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        int length = buffer.length();
        this.source.appendUsage(buffer, helpSettings, comp);
        if (buffer.length() != length) {
            buffer.append(' ');
        }
        this.dest.appendUsage(buffer, helpSettings, comp);
    }

    @Override
    public List helpLines(int depth, Set helpSettings, Comparator comp) {
        ArrayList helpLines = new ArrayList();
        helpLines.addAll(this.source.helpLines(depth, helpSettings, comp));
        helpLines.addAll(this.dest.helpLines(depth, helpSettings, comp));
        return helpLines;
    }

    @Override
    public void validate(WriteableCommandLine commandLine, Option option) throws OptionException {
        List values = commandLine.getValues(option);
        int limit = values.size() - this.dest.getMinimum();
        int count = 0;
        Iterator i = values.iterator();
        while (count++ < limit) {
            commandLine.addValue(this.source, i.next());
        }
        while (i.hasNext()) {
            commandLine.addValue(this.dest, i.next());
        }
        this.source.validate(commandLine, this.source);
        this.dest.validate(commandLine, this.dest);
    }

    @Override
    public boolean canProcess(WriteableCommandLine commandLine, String arg) {
        return this.source.canProcess(commandLine, arg) || this.dest.canProcess(commandLine, arg);
    }
}

