/*
 * Decompiled with CFR 0.152.
 */
package davmail.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public final class IOUtil {
    private IOUtil() {
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        byte[] bytes = new byte[8192];
        while ((length = inputStream.read(bytes)) > 0) {
            outputStream.write(bytes, 0, length);
        }
    }

    public static byte[] decodeBase64(String encoded) {
        return Base64.decodeBase64(encoded.getBytes(StandardCharsets.US_ASCII));
    }

    public static String decodeBase64AsString(String encoded) {
        return new String(IOUtil.decodeBase64(encoded), StandardCharsets.UTF_8);
    }

    public static String encodeBase64AsString(String value) {
        return new String(Base64.encodeBase64(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.US_ASCII);
    }

    public static String encodeBase64AsString(byte[] value) {
        return new String(Base64.encodeBase64(value), StandardCharsets.US_ASCII);
    }

    public static byte[] encodeBase64(String value) {
        return Base64.encodeBase64(value.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encodeBase64(byte[] value) {
        return Base64.encodeBase64(value);
    }

    public static byte[] resizeImage(byte[] inputBytes, int max) throws IOException {
        BufferedImage inputImage = ImageIO.read(new ByteArrayInputStream(inputBytes));
        if (inputImage == null) {
            throw new IOException("Unable to decode image data");
        }
        BufferedImage outputImage = IOUtil.resizeImage(inputImage, max);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)outputImage, "jpg", baos);
        return baos.toByteArray();
    }

    public static BufferedImage resizeImage(BufferedImage inputImage, int max) {
        int targetHeight;
        int targetWidth;
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        if (width <= max && height <= max) {
            return inputImage;
        }
        if (width > height) {
            targetWidth = max;
            targetHeight = targetWidth * height / width;
        } else {
            targetHeight = max;
            targetWidth = targetHeight * width / height;
        }
        Image scaledImage = inputImage.getScaledInstance(targetWidth, targetHeight, 4);
        BufferedImage targetImage = new BufferedImage(targetWidth, targetHeight, 1);
        targetImage.getGraphics().drawImage(scaledImage, 0, 0, null);
        return targetImage;
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.write(inputStream, baos);
        return baos.toByteArray();
    }
}

