/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Authenticator;
import davmail.exchange.auth.O365InteractiveAuthenticatorFrame;
import davmail.exchange.auth.O365ManualAuthenticatorDialog;
import davmail.exchange.auth.O365Token;
import davmail.exchange.ews.BaseShape;
import davmail.exchange.ews.DistinguishedFolderId;
import davmail.exchange.ews.GetFolderMethod;
import davmail.exchange.ews.GetUserConfigurationMethod;
import davmail.http.DavGatewayHttpClientFacade;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Logger;

public class O365InteractiveAuthenticator
implements ExchangeAuthenticator {
    private static final int MAX_COUNT = 300;
    private static final Logger LOGGER = Logger.getLogger(O365InteractiveAuthenticator.class);
    boolean isAuthenticated = false;
    String errorCode = null;
    String code = null;
    String resource = "https://outlook.office365.com";
    URI ewsUrl = URI.create(this.resource + "/EWS/Exchange.asmx");
    private O365InteractiveAuthenticatorFrame o365InteractiveAuthenticatorFrame;
    private String username;
    private String password;
    private O365Token token;

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return this.ewsUrl;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void authenticate() throws IOException {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        System.setProperty("jdk.http.ntlm.transparentAuth", "allHosts");
        String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
        String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", "https://login.microsoftonline.com/common/oauth2/nativeclient");
        String tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
        this.token = O365Token.load(tenantId, clientId, redirectUri, this.username, this.password);
        if (this.token != null) {
            this.isAuthenticated = true;
            return;
        }
        String initUrl = O365Authenticator.buildAuthorizeUrl(tenantId, clientId, redirectUri, this.username);
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String proxyUser = Settings.getProperty("davmail.proxyUser");
                    String proxyPassword = Settings.getProperty("davmail.proxyPassword");
                    if (proxyUser != null && proxyPassword != null) {
                        LOGGER.debug((Object)("Proxy authentication with user " + proxyUser));
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                    LOGGER.debug((Object)"Missing proxy credentials ");
                    return null;
                }
                LOGGER.debug((Object)("Password authentication with user " + O365InteractiveAuthenticator.this.username));
                return new PasswordAuthentication(O365InteractiveAuthenticator.this.username, O365InteractiveAuthenticator.this.password.toCharArray());
            }
        });
        SwingUtilities.invokeLater(() -> {
            block2: {
                try {
                    this.o365InteractiveAuthenticatorFrame = new O365InteractiveAuthenticatorFrame();
                    this.o365InteractiveAuthenticatorFrame.setO365InteractiveAuthenticator(this);
                    this.o365InteractiveAuthenticatorFrame.authenticate(initUrl, redirectUri);
                }
                catch (NoClassDefFoundError e) {
                    LOGGER.warn((Object)"Unable to load JavaFX (OpenJFX), switch to manual mode");
                    O365ManualAuthenticatorDialog o365ManualAuthenticatorDialog = new O365ManualAuthenticatorDialog(initUrl);
                    this.code = o365ManualAuthenticatorDialog.getCode();
                    boolean bl = this.isAuthenticated = this.code != null;
                    if (this.isAuthenticated) break block2;
                    this.errorCode = "User did not provide authentication code";
                }
            }
        });
        int count = 0;
        while (!this.isAuthenticated && this.errorCode == null && count++ < 300) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (count > 300) {
            this.errorCode = "Timed out waiting for interactive authentication";
        }
        if (this.o365InteractiveAuthenticatorFrame != null && this.o365InteractiveAuthenticatorFrame.isVisible()) {
            this.o365InteractiveAuthenticatorFrame.close();
        }
        if (this.isAuthenticated) {
            this.token = O365Token.build(tenantId, clientId, redirectUri, this.code, this.password);
            LOGGER.debug((Object)("Authenticated username: " + this.token.getUsername()));
            if (this.username != null && !this.username.isEmpty() && !this.username.equalsIgnoreCase(this.token.getUsername())) {
                throw new DavMailAuthenticationException("Authenticated username " + this.token.getUsername() + " does not match " + this.username);
            }
        } else {
            LOGGER.error((Object)("Authentication failed " + this.errorCode));
            throw new DavMailException("EXCEPTION_AUTHENTICATION_FAILED_REASON", this.errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            Settings.setDefaultSettings();
            O365InteractiveAuthenticator authenticator = new O365InteractiveAuthenticator();
            authenticator.setUsername("");
            authenticator.authenticate();
            HttpClient httpClient = DavGatewayHttpClientFacade.getInstance(authenticator.ewsUrl.toString());
            GetFolderMethod checkMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
            checkMethod.setRequestHeader("Authorization", "Bearer " + authenticator.getToken().getAccessToken());
            try {
                httpClient.executeMethod((HttpMethod)checkMethod);
                checkMethod.checkSuccess();
            }
            finally {
                checkMethod.releaseConnection();
            }
            System.out.println("Retrieved folder id " + (String)checkMethod.getResponseItem().get("FolderId"));
            int i = 0;
            while (i++ < 1440) {
                GetUserConfigurationMethod getUserConfigurationMethod = new GetUserConfigurationMethod();
                getUserConfigurationMethod.setRequestHeader("Authorization", "Bearer " + authenticator.getToken().getAccessToken());
                httpClient.executeMethod((HttpMethod)getUserConfigurationMethod);
                System.out.println(getUserConfigurationMethod.getResponseItem());
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(e + " " + e.getMessage()), (Throwable)e);
        }
        System.exit(0);
    }
}

