/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import net.sf.portecle.FPortecle;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.KeyStoreType;
import net.sf.portecle.crypto.X509CertUtil;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public final class KeyStoreUtil {
    public static final char[] DUMMY_PASSWORD = "password".toCharArray();
    private static final HashMap<KeyStoreType, Boolean> AVAILABLE_TYPES = new HashMap();

    private KeyStoreUtil() {
    }

    private static KeyStore getKeyStoreImpl(KeyStoreType keyStoreType) throws KeyStoreException {
        KeyStore keyStore = null;
        if (keyStoreType == KeyStoreType.PKCS12) {
            try {
                keyStore = KeyStore.getInstance(keyStoreType.getTypeName(), "BC");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                // empty catch block
            }
        }
        if (keyStore == null) {
            try {
                keyStore = KeyStore.getInstance(keyStoreType.getTypeName());
            }
            catch (KeyStoreException keyStoreException) {
                AVAILABLE_TYPES.put(keyStoreType, Boolean.FALSE);
                throw keyStoreException;
            }
        }
        AVAILABLE_TYPES.put(keyStoreType, Boolean.TRUE);
        return keyStore;
    }

    public static KeyStore createKeyStore(KeyStoreType keyStoreType) throws CryptoException, IOException {
        KeyStore keyStore;
        try {
            keyStore = KeyStoreUtil.getKeyStoreImpl(keyStoreType);
            keyStore.load(null, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoCreateKeystore.exception.message"), new Object[]{keyStoreType}), generalSecurityException);
        }
        return keyStore;
    }

    public static KeyStore loadEntries(PEMParser pEMParser, PasswordFinder passwordFinder) throws CertificateException, CryptoException, IOException {
        Object object;
        Object object2;
        Object object3;
        LinkedHashSet<KeyPair> linkedHashSet = new LinkedHashSet<KeyPair>();
        LinkedHashSet<Certificate> linkedHashSet2 = new LinkedHashSet<Certificate>();
        KeyStore keyStore = KeyStoreUtil.createKeyStore(KeyStoreType.PKCS12);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        while ((object3 = pEMParser.readObject()) != null) {
            Object object4;
            if (object3 instanceof PEMEncryptedKeyPair) {
                object4 = new JcePEMDecryptorProviderBuilder().build(passwordFinder.getPassword());
                object3 = ((PEMEncryptedKeyPair)object3).decryptKeyPair((PEMDecryptorProvider)object4);
            }
            if (object3 instanceof PEMKeyPair) {
                linkedHashSet.add(jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object3));
                continue;
            }
            if (!(object3 instanceof X509CertificateHolder)) continue;
            object4 = new ByteArrayInputStream(((X509CertificateHolder)object3).getEncoded());
            linkedHashSet2.add(certificateFactory.generateCertificate((InputStream)object4));
        }
        for (KeyPair serializable : linkedHashSet) {
            Object object4;
            object2 = null;
            object = linkedHashSet2.iterator();
            while (object.hasNext()) {
                object4 = (Certificate)object.next();
                if (!((Certificate)object4).getPublicKey().equals(serializable.getPublic())) continue;
                object2 = object4;
                object.remove();
                break;
            }
            if (object2 == null) continue;
            object = "keypair";
            if (object2 instanceof X509Certificate) {
                object = X509CertUtil.getCertificateAlias((X509Certificate)object2);
            }
            object4 = new KeyStore.PrivateKeyEntry(serializable.getPrivate(), new Certificate[]{object2});
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(DUMMY_PASSWORD);
            try {
                object = KeyStoreUtil.findUnusedAlias(keyStore, (String)object);
                keyStore.setEntry((String)object, (KeyStore.Entry)object4, passwordProtection);
            }
            catch (KeyStoreException keyStoreException) {
                throw new CryptoException(keyStoreException);
            }
        }
        for (Certificate certificate : linkedHashSet2) {
            object2 = "certificate";
            if (certificate instanceof X509Certificate) {
                object2 = X509CertUtil.getCertificateAlias((X509Certificate)certificate);
            }
            object = new KeyStore.TrustedCertificateEntry(certificate);
            try {
                keyStore.setEntry((String)object2, (KeyStore.Entry)object, null);
            }
            catch (KeyStoreException keyStoreException) {
                throw new CryptoException(keyStoreException);
            }
        }
        return keyStore;
    }

    public static boolean isAvailable(KeyStoreType keyStoreType) {
        Boolean bl = AVAILABLE_TYPES.get((Object)keyStoreType);
        if (bl != null) {
            return bl;
        }
        try {
            KeyStoreUtil.getKeyStoreImpl(keyStoreType);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return AVAILABLE_TYPES.get((Object)keyStoreType);
    }

    public static KeyStoreType[] getAvailableTypes() {
        KeyStoreType[] keyStoreTypeArray = KeyStoreType.values();
        ArrayList<KeyStoreType> arrayList = new ArrayList<KeyStoreType>();
        for (KeyStoreType keyStoreType : keyStoreTypeArray) {
            if (!KeyStoreUtil.isAvailable(keyStoreType)) continue;
            arrayList.add(keyStoreType);
        }
        return arrayList.toArray(new KeyStoreType[arrayList.size()]);
    }

    public static KeyStore loadKeyStore(File file, char[] cArray, KeyStoreType keyStoreType) throws CryptoException, FileNotFoundException {
        KeyStore keyStore;
        try {
            keyStore = KeyStoreUtil.getKeyStoreImpl(keyStoreType);
        }
        catch (KeyStoreException keyStoreException) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoCreateKeystore.exception.message"), new Object[]{keyStoreType}), keyStoreException);
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore.load(fileInputStream, cArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException | ClassCastException | IllegalArgumentException | GeneralSecurityException exception) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoLoadKeystore.exception.message"), new Object[]{keyStoreType}), exception);
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(String string, char[] cArray) throws CryptoException {
        KeyStore keyStore;
        try {
            if (Security.getProvider(string) == null) {
                throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoSuchProvider.exception.message"), string));
            }
            keyStore = KeyStore.getInstance(KeyStoreType.PKCS11.name(), string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoCreateKeystore.exception.message"), new Object[]{KeyStoreType.PKCS11}), generalSecurityException);
        }
        try {
            keyStore.load(null, cArray);
        }
        catch (Exception exception) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoLoadKeystore.exception.message"), new Object[]{KeyStoreType.PKCS11}), exception);
        }
        return keyStore;
    }

    public static KeyStore saveKeyStore(KeyStore keyStore, File file, char[] cArray) throws CryptoException, IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            keyStore.store(fileOutputStream, cArray);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new CryptoException(FPortecle.RB.getString("NoSaveKeystore.exception.message"), exception);
        }
        if (KeyStoreType.valueOfType(keyStore.getType()) == KeyStoreType.GKR) {
            keyStore = KeyStoreUtil.loadKeyStore(file, cArray, KeyStoreType.GKR);
        }
        return keyStore;
    }

    private static String findUnusedAlias(KeyStore keyStore, String string) throws KeyStoreException {
        block1: {
            String string2;
            if (!keyStore.containsAlias(string)) break block1;
            int n = 1;
            while (keyStore.containsAlias(string2 = string + " (" + n + ")")) {
            }
            string = string2;
        }
        return string;
    }
}

