/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NoteReader {
    private final InputSource inputSource;
    private List<Note> parsedNotes;

    public NoteReader(InputStream inputStream) {
        this.inputSource = new InputSource(inputStream);
    }

    public NoteReader(String string) {
        this.inputSource = new InputSource(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
    }

    public List<Note> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            Utils.parseSafeSAX(this.inputSource, parser);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Main.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
        return this.parsedNotes;
    }

    private class Parser
    extends DefaultHandler {
        private NoteParseMode parseMode;
        private final StringBuilder buffer = new StringBuilder();
        private Note thisNote;
        private long commentUid;
        private String commentUsername;
        private NoteComment.Action noteAction;
        private Date commentCreateDate;
        private boolean commentIsNew;
        private List<Note> notes;
        private String commentText;

        private Parser() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.buffer.setLength(0);
            switch (string3) {
                case "osm": {
                    this.parseMode = NoteParseMode.API;
                    this.notes = new ArrayList<Note>(100);
                    return;
                }
                case "osm-notes": {
                    this.parseMode = NoteParseMode.DUMP;
                    this.notes = new ArrayList<Note>(10000);
                    return;
                }
            }
            if (this.parseMode == NoteParseMode.API) {
                if ("note".equals(string3)) {
                    double d = Double.parseDouble(attributes.getValue("lat"));
                    double d2 = Double.parseDouble(attributes.getValue("lon"));
                    LatLon latLon = new LatLon(d, d2);
                    this.thisNote = new Note(latLon);
                }
                return;
            }
            switch (string3) {
                case "note": {
                    double d = Double.parseDouble(attributes.getValue("lat"));
                    double d3 = Double.parseDouble(attributes.getValue("lon"));
                    LatLon latLon = new LatLon(d, d3);
                    this.thisNote = new Note(latLon);
                    this.thisNote.setId(Long.parseLong(attributes.getValue("id")));
                    String string4 = attributes.getValue("closed_at");
                    if (string4 == null) {
                        this.thisNote.setState(Note.State.OPEN);
                    } else {
                        this.thisNote.setState(Note.State.CLOSED);
                        this.thisNote.setClosedAt(DateUtils.fromString(string4));
                    }
                    this.thisNote.setCreatedAt(DateUtils.fromString(attributes.getValue("created_at")));
                    break;
                }
                case "comment": {
                    this.commentUid = Long.parseLong(Optional.ofNullable(attributes.getValue("uid")).orElse("0"));
                    this.commentUsername = attributes.getValue("user");
                    this.noteAction = NoteComment.Action.valueOf(attributes.getValue("action").toUpperCase(Locale.ENGLISH));
                    this.commentCreateDate = DateUtils.fromString(attributes.getValue("timestamp"));
                    this.commentIsNew = Boolean.parseBoolean(Optional.ofNullable(attributes.getValue("is_new")).orElse("false"));
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (this.notes != null && "note".equals(string3)) {
                this.notes.add(this.thisNote);
            }
            if ("comment".equals(string3)) {
                Object object = User.createOsmUser(this.commentUid, this.commentUsername);
                if (this.commentUid == 0L) {
                    object = User.getAnonymous();
                }
                if (this.parseMode == NoteParseMode.API) {
                    this.commentIsNew = false;
                }
                if (this.parseMode == NoteParseMode.DUMP) {
                    this.commentText = this.buffer.toString();
                }
                this.thisNote.addComment(new NoteComment(this.commentCreateDate, (User)object, this.commentText, this.noteAction, this.commentIsNew));
                this.commentUid = 0L;
                this.commentUsername = null;
                this.commentCreateDate = null;
                this.commentIsNew = false;
                this.commentText = null;
            }
            if (this.parseMode == NoteParseMode.DUMP) {
                return;
            }
            switch (string3) {
                case "id": {
                    this.thisNote.setId(Long.parseLong(this.buffer.toString()));
                    break;
                }
                case "status": {
                    this.thisNote.setState(Note.State.valueOf(this.buffer.toString().toUpperCase(Locale.ENGLISH)));
                    break;
                }
                case "date_created": {
                    this.thisNote.setCreatedAt(DateUtils.fromString(this.buffer.toString()));
                    break;
                }
                case "date_closed": {
                    this.thisNote.setClosedAt(DateUtils.fromString(this.buffer.toString()));
                    break;
                }
                case "date": {
                    this.commentCreateDate = DateUtils.fromString(this.buffer.toString());
                    break;
                }
                case "user": {
                    this.commentUsername = this.buffer.toString();
                    break;
                }
                case "uid": {
                    this.commentUid = Long.parseLong(this.buffer.toString());
                    break;
                }
                case "text": {
                    this.commentText = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                case "action": {
                    this.noteAction = NoteComment.Action.valueOf(this.buffer.toString().toUpperCase(Locale.ENGLISH));
                    break;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            NoteReader.this.parsedNotes = this.notes;
        }
    }

    private static enum NoteParseMode {
        API,
        DUMP;

    }
}

