/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AlignImageryPanel
extends JPanel {
    public AlignImageryPanel(boolean bl, BooleanProperty booleanProperty, ImageryInfo imageryInfo) {
        Font font = this.getFont().deriveFont(0, 14.0f);
        JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("Aerial imagery \"{0}\" might be misaligned. Please check its offset using GPS tracks!", imageryInfo.getName()));
        UrlLabel urlLabel = new UrlLabel(I18n.tr("http://wiki.openstreetmap.org/wiki/Using_Imagery", new Object[0]), I18n.tr("Details...", new Object[0]));
        jMultilineLabel.setFont(font);
        jMultilineLabel.setForeground(Color.BLACK);
        urlLabel.setFont(font);
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Do not show this message again", new Object[0]));
        jCheckBox.setOpaque(false);
        jCheckBox.setForeground(Color.BLACK);
        JButton jButton = new JButton(ImageProvider.get("misc", "black_x"));
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        jButton.setBorderPainted(false);
        jButton.setToolTipText(I18n.tr("Hide this message and never show it again", new Object[0]));
        jButton.addActionListener(actionEvent -> {
            if (Main.isDisplayingMapView()) {
                Main.map.removeTopPanel(AlignImageryPanel.class);
                if (jCheckBox.isSelected()) {
                    booleanProperty.put(Boolean.FALSE);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        if (!bl) {
            this.add((Component)jMultilineLabel, GBC.std(1, 1).fill());
            this.add((Component)urlLabel, GBC.std(1, 2).fill());
            this.add((Component)jCheckBox, GBC.std(1, 3).fill());
            this.add((Component)jButton, GBC.std(2, 1).span(1, 2).anchor(13));
        } else {
            this.add((Component)jMultilineLabel, GBC.std(1, 1).fill());
            this.add((Component)urlLabel, GBC.std(2, 1).fill());
            this.add((Component)jCheckBox, GBC.std(1, 2).fill());
            this.add((Component)jButton, GBC.std(3, 1).anchor(13));
        }
        this.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(12, 12, 12, 12)));
        this.setBackground(new Color(224, 236, 249));
    }

    public static void addNagPanelIfNeeded(ImageryInfo imageryInfo) {
        BooleanProperty booleanProperty = new BooleanProperty("message.imagery.nagPanel." + imageryInfo.getUrl(), true);
        if (Main.isDisplayingMapView() && booleanProperty.get().booleanValue() && !imageryInfo.isGeoreferenceValid() && Main.map.getTopPanel(AlignImageryPanel.class) == null) {
            double d = GuiHelper.getScreenSize().getWidth();
            Main.map.addTopPanel(new AlignImageryPanel(d > 1300.0, booleanProperty, imageryInfo));
        }
    }
}

