/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;

public class MinimapDialog
extends ToggleDialog
implements NavigatableComponent.ZoomChangeListener,
PropertyChangeListener {
    private SlippyMapBBoxChooser slippyMap;
    private boolean skipEvents;

    public MinimapDialog() {
        super(I18n.tr("Mini map", new Object[0]), "minimap", I18n.tr("Displays a small map of the current edit location", new Object[0]), null, 150);
    }

    private synchronized void initialize() {
        if (this.slippyMap != null) {
            return;
        }
        this.slippyMap = new SlippyMapBBoxChooser();
        this.createLayout(this.slippyMap, false, Collections.emptyList());
        this.slippyMap.setSizeButtonVisible(false);
        this.slippyMap.addPropertyChangeListener(BBoxChooser.BBOX_PROP, this);
    }

    @Override
    public void showDialog() {
        this.initialize();
        NavigatableComponent.addZoomChangeListener(this);
        super.showDialog();
    }

    @Override
    public void hideDialog() {
        NavigatableComponent.removeZoomChangeListener(this);
        super.hideDialog();
    }

    @Override
    public void zoomChanged() {
        if (!this.skipEvents && Main.isDisplayingMapView()) {
            MapView mapView = Main.map.mapView;
            Bounds bounds = new Bounds(mapView.getLatLon(0, mapView.getHeight()), mapView.getLatLon(mapView.getWidth(), 0));
            this.skipEvents = true;
            this.slippyMap.setBoundingBox(bounds);
            this.slippyMap.zoomOut();
            this.skipEvents = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.skipEvents) {
            this.skipEvents = true;
            Main.map.mapView.zoomTo(this.slippyMap.getBoundingBox());
            this.skipEvents = false;
        }
    }
}

