/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class AbstractStackTransferHandler
extends TransferHandler {
    protected abstract Collection<AbstractOsmDataPaster> getSupportedPasters();

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        for (AbstractOsmDataPaster abstractOsmDataPaster : this.getSupportedPasters()) {
            if (!abstractOsmDataPaster.supports(transferSupport)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        return this.importData(transferSupport, Main.getLayerManager().getEditLayer(), null);
    }

    protected boolean importData(TransferHandler.TransferSupport transferSupport, OsmDataLayer osmDataLayer, EastNorth eastNorth) {
        for (AbstractOsmDataPaster abstractOsmDataPaster : this.getSupportedPasters()) {
            if (!abstractOsmDataPaster.supports(transferSupport)) continue;
            try {
                if (Main.isDebugEnabled()) {
                    Main.debug("{0} pasting {1} at {2}", abstractOsmDataPaster.getClass().getSimpleName(), Arrays.toString(transferSupport.getDataFlavors()), eastNorth);
                }
                if (!abstractOsmDataPaster.importData(transferSupport, osmDataLayer, eastNorth)) continue;
                return true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Main.warn(exception);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                BugReport.intercept(runtimeException).put("paster", abstractOsmDataPaster).put("flavors", transferSupport::getDataFlavors).warn();
            }
        }
        return super.importData(transferSupport);
    }
}

