/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCParser;
import org.javacc.parser.LexGen;
import org.javacc.parser.Main;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.Options;
import org.javacc.parser.Semanticize;
import org.javacc.parser.TokenizerData;

public class JavaCCInterpreter {
    public static void main(String[] args) throws Exception {
        Main.reInitAll();
        Object parser = null;
        for (int arg = 0; arg < args.length - 2; ++arg) {
            if (!Options.isOption(args[arg])) {
                System.out.println("Argument \"" + args[arg] + "\" must be an option setting.");
                System.exit(1);
            }
            Options.setCmdLineOption(args[arg]);
        }
        String input = "";
        String grammar = "";
        try {
            File fp = new File(args[args.length - 2]);
            byte[] buf = new byte[(int)fp.length()];
            new DataInputStream(new BufferedInputStream(new FileInputStream(fp))).readFully(buf);
            grammar = new String(buf);
            File inputFile = new File(args[args.length - 1]);
            buf = new byte[(int)inputFile.length()];
            new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile))).readFully(buf);
            input = new String(buf);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            System.exit(1);
        }
        long l = System.currentTimeMillis();
        new JavaCCInterpreter().runTokenizer(grammar, input);
        System.err.println("Tokenized in: " + (System.currentTimeMillis() - l));
    }

    public void runTokenizer(String grammar, String input) {
        try {
            JavaCCParser parser = new JavaCCParser(new StringReader(grammar));
            parser.javacc_input();
            Semanticize.start();
            LexGen lg = new LexGen();
            LexGen.generateDataOnly = true;
            lg.start();
            TokenizerData td = LexGen.tokenizerData;
            if (JavaCCErrors.get_error_count() == 0) {
                JavaCCInterpreter.tokenize(td, input);
            }
        }
        catch (MetaParseException e) {
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            System.exit(1);
        }
    }

    public static void tokenize(TokenizerData td, String input) {
        int input_size = input.length();
        int curPos = 0;
        int curLexState = td.defaultLexState;
        HashSet<Integer> curStates = new HashSet<Integer>();
        HashSet<Integer> newStates = new HashSet<Integer>();
        while (curPos < input_size) {
            int key;
            List<String> literals;
            int beg;
            int matchedPos = beg = curPos;
            int matchedKind = Integer.MAX_VALUE;
            int nfaStartState = td.initialStates.get(curLexState);
            char c = input.charAt(curPos);
            if (Options.getIgnoreCase()) {
                c = Character.toLowerCase(c);
            }
            if ((literals = td.literalSequence.get(key = curLexState << 16 | c)) != null) {
                int litIndex = 0;
                for (String s : literals) {
                    int index;
                    for (index = 1; index < s.length() && curPos + index < input_size; ++index) {
                        c = input.charAt(curPos + index);
                        if (Options.getIgnoreCase()) {
                            c = Character.toLowerCase(c);
                        }
                        if (c != s.charAt(index)) break;
                    }
                    if (index == s.length()) {
                        matchedKind = td.literalKinds.get(key).get(litIndex);
                        matchedPos = curPos + index - 1;
                        nfaStartState = td.kindToNfaStartState.get(matchedKind);
                        curPos += index;
                        break;
                    }
                    ++litIndex;
                }
            }
            if (nfaStartState != -1) {
                int kind = Integer.MAX_VALUE;
                curStates.add(nfaStartState);
                curStates.addAll(td.nfa.get((Object)Integer.valueOf((int)nfaStartState)).compositeStates);
                do {
                    c = input.charAt(curPos);
                    if (Options.getIgnoreCase()) {
                        c = Character.toLowerCase(c);
                    }
                    Iterator<String> iterator = curStates.iterator();
                    while (iterator.hasNext()) {
                        int state = (Integer)((Object)iterator.next());
                        TokenizerData.NfaState nfaState = td.nfa.get(state);
                        if (!nfaState.characters.contains(Character.valueOf(c))) continue;
                        if (kind > nfaState.kind) {
                            kind = nfaState.kind;
                        }
                        newStates.addAll(nfaState.nextStates);
                    }
                    HashSet<Integer> tmp = newStates;
                    newStates = curStates;
                    curStates = tmp;
                    newStates.clear();
                    if (kind == Integer.MAX_VALUE) continue;
                    matchedKind = kind;
                    matchedPos = curPos;
                    kind = Integer.MAX_VALUE;
                } while (!curStates.isEmpty() && ++curPos < input_size);
            }
            if (matchedPos == beg && matchedKind > td.wildcardKind.get(curLexState)) {
                matchedKind = td.wildcardKind.get(curLexState);
            }
            if (matchedKind != Integer.MAX_VALUE) {
                TokenizerData.MatchInfo matchInfo = td.allMatches.get(matchedKind);
                if (matchInfo.action != null) {
                    System.err.println("Actions not implemented (yet) in intererpreted mode");
                }
                if (matchInfo.matchType == TokenizerData.MatchType.TOKEN) {
                    System.err.println("Token: " + matchedKind + "; image: \"" + input.substring(beg, matchedPos + 1) + "\"");
                }
                if (matchInfo.newLexState != -1) {
                    curLexState = matchInfo.newLexState;
                }
                curPos = matchedPos + 1;
                continue;
            }
            System.err.println("Encountered token error at char: " + input.charAt(curPos));
            System.exit(1);
        }
        System.err.println("Matched EOF");
    }
}

