/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;

public class FCMPlayer {
    public static int TICKSPQ = 50;
    public static int TEMPOPM = 120;
    public static int TEMPOPS = TEMPOPM / 60;
    public static int MILLISPERTICK = 1000 / (TICKSPQ * TEMPOPS);
    public boolean midiAvailable;
    int channel;
    Synthesizer synthR = null;
    MidiChannel[] channels;
    Instrument[] instr;
    Soundbank sb;
    FileDialog fd = null;
    private String outPath = "*.mid";
    CellSymphony cSymph;

    public FCMPlayer(CellSymphony cSymph) {
        this.cSymph = cSymph;
        try {
            this.synthR = MidiSystem.getSynthesizer();
            this.synthR.open();
            this.midiAvailable = true;
        }
        catch (MidiUnavailableException ex) {
            this.midiAvailable = false;
        }
    }

    public int[] getPrograms() {
        MidiChannel[] mcA = this.synthR.getChannels();
        if (mcA == null || mcA.length <= 0) {
            return null;
        }
        int[] programs = new int[mcA.length];
        int i = 0;
        while (i < mcA.length) {
            programs[i] = mcA[i].getProgram();
            ++i;
        }
        return programs;
    }

    public String[] getInstruments() {
        this.sb = this.synthR.getDefaultSoundbank();
        if (this.sb == null) {
            return null;
        }
        System.out.println("soundbank. Vendor: " + this.sb.getVendor() + " Name: " + this.sb.getName());
        this.instr = this.sb.getInstruments();
        if (this.instr != null) {
            String[] names = new String[this.instr.length];
            int i = 0;
            while (i < this.instr.length) {
                names[i] = this.instr[i] != null ? this.instr[i].getName() : "null";
                ++i;
            }
            return names;
        }
        return null;
    }

    public void testPlay(int ch1, int prog) {
        boolean ok = true;
        try {
            this.synthR.open();
        }
        catch (MidiUnavailableException ex) {
            ex.printStackTrace();
            return;
        }
        this.channels = this.synthR.getChannels();
        if (this.channels == null) {
            ok = false;
        }
        if (ok) {
            MidiChannel mChannel = this.channels[ch1];
            mChannel.programChange(prog);
            mChannel.noteOn(60, 126);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mChannel.noteOff(60);
        }
    }

    public boolean play(FileSpec fs, int[] pitchPar, int[] prog, int volumePar, int every, int total, int duration, boolean isRecording) {
        if (prog == null || pitchPar == null) {
            return false;
        }
        int numInst = pitchPar.length;
        int mfTime = 0;
        int mfDuration = (duration + MILLISPERTICK / 2) / MILLISPERTICK;
        if (mfDuration <= 0) {
            mfDuration = 1;
        }
        boolean lastN = false;
        if (prog.length < numInst) {
            return false;
        }
        Note[] n = new Note[numInst];
        boolean ok = true;
        Sequence sequence = null;
        Track track = null;
        try {
            this.synthR.open();
        }
        catch (MidiUnavailableException ex) {
            ex.printStackTrace();
            return false;
        }
        this.channels = this.synthR.getChannels();
        if (this.channels == null) {
            ok = false;
        }
        if (isRecording) {
            try {
                sequence = new Sequence(0.0f, TICKSPQ);
                track = sequence.createTrack();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int j = 0;
        while (j < numInst) {
            if (prog[j] >= 0) {
                if (isRecording) {
                    this.addChangeProgram(track, j, prog[j]);
                }
                this.channels[j].programChange(prog[j]);
                this.channels[j].noteOn(60, 126);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.channels[j].noteOff(60);
            }
            ++j;
        }
        if (!fs.prelude()) {
            ok = false;
        }
        int i = 0;
        while (ok && i < total && i < fs.total) {
            int j22 = 0;
            while (j22 < numInst) {
                boolean bl = lastN = j22 == numInst - 1;
                if (prog[j22] >= 0) {
                    n[j22] = fs.getNextNote(every, pitchPar[j22], volumePar, lastN);
                    if (n[j22] != null && n[j22].pitch > 0 && n[j22].volume > 0) {
                        if (isRecording) {
                            this.addNoteOn(track, j22, mfTime, n[j22].pitch, n[j22].volume);
                        }
                        this.channels[j22].noteOn(n[j22].pitch, n[j22].volume);
                    }
                } else {
                    fs.getNextNote(every, -1, volumePar, lastN);
                }
                ++j22;
            }
            mfTime += mfDuration;
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException j22) {
                // empty catch block
            }
            int j3 = 0;
            while (j3 < numInst) {
                if (prog[j3] >= 0) {
                    this.channels[j3].noteOff(n[j3].pitch);
                    if (isRecording) {
                        this.addNoteOff(track, j3, mfTime, n[j3].pitch, n[j3].volume);
                    }
                }
                ++j3;
            }
            ++i;
        }
        if (isRecording) {
            int[] allowedTypes = MidiSystem.getMidiFileTypes(sequence);
            if (allowedTypes.length == 0) {
                System.out.println("No supported MIDI file types.");
            } else {
                String filename = this.getFilename();
                if (filename != null) {
                    try {
                        MidiSystem.write(sequence, allowedTypes[0], new File(filename));
                    }
                    catch (Exception e) {
                        System.out.println("Error writing file.");
                    }
                }
            }
        }
        return true;
    }

    private void addNoteOn(Track track, int chan, int startTick, int key, int velocity) {
        ShortMessage on = new ShortMessage();
        try {
            on.setMessage(144, chan, key, velocity);
            track.add(new MidiEvent(on, startTick));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addNoteOff(Track track, int chan, int stopTick, int key, int velocity) {
        ShortMessage off = new ShortMessage();
        try {
            off.setMessage(128, chan, key, velocity);
            track.add(new MidiEvent(off, stopTick));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addChangeProgram(Track track, int chan, int instr) {
        ShortMessage sm = new ShortMessage();
        try {
            sm.setMessage(192, chan, instr, 0);
            track.add(new MidiEvent(sm, 0L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getFilename() {
        if (this.fd == null) {
            this.fd = new FileDialog((Frame)this.cSymph, "MIDI output file", 1);
        }
        this.fd.setFile(this.outPath);
        this.fd.setVisible(true);
        String name = this.fd.getFile();
        if (name != null) {
            this.outPath = name;
            String dirName = this.fd.getDirectory();
            return String.valueOf(dirName) + name;
        }
        return null;
    }
}

