/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.util;

import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.util.Gpr;

public class FastaSample {
    String fastaFile;
    String chrName;
    int start;
    int end;
    String outFile = "/tmp/fastaSample.txt";

    public static void main(String[] args) {
        FastaSample fastaSample = new FastaSample();
        fastaSample.parseArgs(args);
        fastaSample.run();
    }

    void parseArgs(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: " + FastaSample.class.getSimpleName() + " fastaFile.fa chromosome start end");
            System.exit(1);
        }
        this.fastaFile = args[0];
        this.chrName = args[1];
        this.start = Gpr.parseIntSafe(args[2]) - 1;
        this.end = Gpr.parseIntSafe(args[3]);
        if (this.start > this.end) {
            System.err.println("Error: Start should be before end.");
            System.exit(1);
        }
    }

    public void run() {
        FastaFileIterator ffi = new FastaFileIterator(this.fastaFile);
        for (String seq2 : ffi) {
            System.err.println(ffi.getName());
            if (!ffi.getName().equalsIgnoreCase(this.chrName)) continue;
            String subSeq = seq2.substring(this.start, this.end);
            System.out.println(subSeq);
            if (this.outFile != null) {
                System.err.println("Saving sequence to file '" + this.outFile + "'");
                Gpr.toFile(this.outFile, subSeq);
            }
            ffi.close();
            break;
        }
    }
}

