/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang;

import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfInfoType;

public class Value {
    public static boolean debug = false;
    public static final Value FALSE = new Value(false);
    public static final Value TRUE = new Value(true);
    public static final Value NULL = new Value(null);
    final Object value;

    public Value(Object value2) {
        this.value = value2;
        this.sanityCheck();
    }

    public boolean asBool() {
        if (this.value == null) {
            return false;
        }
        if (this.isBool()) {
            return (Boolean)this.value;
        }
        if (this.isInt()) {
            return this.asInt() != 0L;
        }
        if (this.isFloat()) {
            return this.asFloat() != 0.0;
        }
        return !this.asString().isEmpty();
    }

    public double asFloat() {
        if (this.value == null) {
            return 0.0;
        }
        if (this.isBool()) {
            return this.asBool() ? 1.0 : 0.0;
        }
        if (this.isInt()) {
            return this.asInt();
        }
        if (this.isFloat()) {
            return (Double)this.value;
        }
        return Gpr.parseDoubleSafe(this.value.toString());
    }

    public long asInt() {
        if (this.value == null) {
            return 0L;
        }
        if (this.isBool()) {
            return this.asBool() ? 1L : 0L;
        }
        if (this.isInt()) {
            return (Long)this.value;
        }
        if (this.isFloat()) {
            return (long)this.asFloat();
        }
        return Gpr.parseIntSafe(this.value.toString());
    }

    public String asString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public boolean canBeFloat() {
        return this.isFloat() || this.isInt() || this.isBool();
    }

    public boolean canBeInt() {
        return this.isInt() || this.isBool();
    }

    public boolean canCompare(Value val) {
        return !this.isNull() && !val.isNull();
    }

    public int compareTo(Value val) {
        if (this.isNull() && val.isNull()) {
            return 0;
        }
        if (this.isNull() && !val.isNull()) {
            return -1;
        }
        if (!this.isNull() && val.isNull()) {
            return 1;
        }
        if (this.canBeFloat() || val.canBeFloat()) {
            return Double.valueOf(this.asFloat()).compareTo(val.asFloat());
        }
        if (this.canBeInt() || val.canBeInt()) {
            return Long.valueOf(this.asInt()).compareTo(val.asInt());
        }
        if (this.isBool() || val.isBool()) {
            return Boolean.valueOf(this.asBool()).compareTo(val.asBool());
        }
        return this.asString().compareTo(val.asString());
    }

    public boolean equals(Object o) {
        if (this.value == o) {
            return true;
        }
        Value val = (Value)o;
        if (this.isNull() && val.isNull()) {
            return true;
        }
        if (this.isNull() && !val.isNull()) {
            return false;
        }
        if (!this.isNull() && val.isNull()) {
            return false;
        }
        return this.value.equals(val.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public boolean isBool() {
        return this.value instanceof Boolean;
    }

    public boolean isFloat() {
        return this.value instanceof Double;
    }

    public boolean isInt() {
        return this.value instanceof Long || this.value instanceof Integer;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    void sanityCheck() {
        if (this.value == null || this.value instanceof Boolean || this.value instanceof Long || this.value instanceof Double || this.value instanceof String) {
            return;
        }
        throw new RuntimeException("Cannot assign value type '" + this.value.getClass().getSimpleName() + "'");
    }

    public String toString() {
        if (debug) {
            if (this.isNull()) {
                return "null";
            }
            return "(" + (Object)((Object)this.type()) + ")" + (this.isString() ? "'" + this.asString() + "'" : this.asString());
        }
        return this.asString();
    }

    public VcfInfoType type() {
        if (this.isBool()) {
            return VcfInfoType.Flag;
        }
        if (this.isInt()) {
            return VcfInfoType.Integer;
        }
        if (this.isFloat()) {
            return VcfInfoType.Float;
        }
        return VcfInfoType.String;
    }
}

