/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.stats.AlleleCountStats;
import org.snpeff.stats.HomHetStats;
import org.snpeff.stats.TsTvStats;
import org.snpeff.stats.VariantTypeStats;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;

public class SnpSiftCmdTsTv
extends SnpSift {
    public static final int SHOW_EVERY = 1;
    public static final int SHOW_EVERY_NL = 100;
    TsTvStats tsTvStats;
    HomHetStats homHetStats;
    AlleleCountStats alleleCountStats;
    VariantTypeStats variantTypeStats;
    String vcfFileName;

    public SnpSiftCmdTsTv() {
    }

    public SnpSiftCmdTsTv(String[] args) {
        super(args);
    }

    @Override
    public void error(Throwable e, String message) {
        e.printStackTrace();
        System.err.println(message);
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length < 1) {
            this.usage(null);
        }
        int argc = 0;
        this.vcfFileName = args[argc++];
    }

    @Override
    public boolean run() {
        Timer.showStdErr("Analysing '" + this.vcfFileName + "'");
        this.tsTvStats = new TsTvStats();
        this.homHetStats = new HomHetStats();
        this.alleleCountStats = new AlleleCountStats();
        this.variantTypeStats = new VariantTypeStats();
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            try {
                this.tsTvStats.sample(vcfEntry);
                this.homHetStats.sample(vcfEntry);
                this.alleleCountStats.sample(vcfEntry);
                this.variantTypeStats.sample(vcfEntry);
                Gpr.showMark(++entryNum, 1);
            }
            catch (Throwable t) {
                this.error(t, "Error while processing VCF entry (line " + vcfFile.getLineNum() + ") :\n\t" + vcfEntry + "\n" + t);
            }
        }
        System.out.println("\nTS/TV stats:");
        System.out.println(this.tsTvStats);
        System.out.println("\nHom/Het stats:");
        System.out.println(this.homHetStats);
        System.out.println("\nVariant type stats:");
        System.out.println(this.variantTypeStats);
        System.out.println("\nAllele count stats:");
        System.out.println(this.alleleCountStats);
        Timer.showStdErr("Done");
        return true;
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar tstv file1.vcf\nWARNING: Only SNPs are used for Ts/Tv calculations.");
        System.exit(1);
    }
}

