/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.SnpSift;
import org.snpsift.annotate.AnnotateVcfDb;
import org.snpsift.annotate.AnnotateVcfDbMem;
import org.snpsift.annotate.AnnotateVcfDbSorted;
import org.snpsift.annotate.AnnotateVcfDbTabix;

public class SnpSiftCmdAnnotate
extends SnpSift {
    public static final int SHOW = 100;
    protected boolean annotateEmpty;
    protected boolean useId;
    protected boolean useInfoField;
    protected boolean useRefAlt;
    protected AnnotationMethod method;
    protected int countBadRef = 0;
    protected int maxBlockSize;
    int countAnnotated = 0;
    int count = 0;
    protected String chrPrev = "";
    protected String prependInfoFieldName;
    protected String existsInfoField;
    protected ArrayList<String> infoFields;
    protected VcfFileIterator vcfFile;
    protected AnnotateVcfDb annotateDb;

    public SnpSiftCmdAnnotate() {
    }

    public SnpSiftCmdAnnotate(String[] args) {
        super(args);
    }

    ArrayList<VcfEntry> annotate(boolean createList) {
        ArrayList<VcfEntry> list2;
        ArrayList<VcfEntry> arrayList = list2 = createList ? new ArrayList<VcfEntry>() : null;
        if (this.verbose) {
            Timer.showStdErr("Annotating entries from: '" + this.vcfInputFile + "'");
        }
        this.vcfFile = this.openVcfInputFile();
        try {
            this.annotateInit(this.vcfFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int pos = -1;
        String chr = "";
        for (VcfEntry vcfEntry : this.vcfFile) {
            try {
                this.processVcfHeader(this.vcfFile);
                if (vcfEntry.getChromosomeName().equals(chr) && vcfEntry.getStart() < pos) {
                    System.err.println("WARNING: VCF input file is not sorted!\n\tPrevious entry " + chr + ":" + pos + "\n\tCurrent entry  " + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1));
                }
                this.annotate(vcfEntry);
                if (!this.suppressOutput) {
                    this.print(vcfEntry);
                }
                if (list2 != null) {
                    list2.add(vcfEntry);
                }
                chr = vcfEntry.getChromosomeName();
                pos = vcfEntry.getStart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.annotateFinish(this.vcfFile);
        if (this.verbose) {
            double perc = 100.0 * (double)this.countAnnotated / (double)this.count;
            Timer.showStdErr("Done.\n\tTotal annotated entries : " + this.countAnnotated + "\n\tTotal entries           : " + this.count + "\n\tPercent                 : " + String.format("%.2f%%", perc) + "\n\tErrors (bad references) : " + this.countBadRef);
        }
        return list2;
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        boolean annotated = false;
        if (vcfEntry.isVariant()) {
            try {
                annotated = this.annotateDb.annotate(vcfEntry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (annotated) {
            ++this.countAnnotated;
        }
        ++this.count;
        if (this.verbose) {
            Gpr.showMark(this.count, 100);
        }
        return annotated;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        this.vcfFile = vcfFile;
        this.dbFileName = this.databaseFind();
        this.method = this.guessAnnotationMethod();
        this.dbFileName = this.fixDbName();
        if (this.verbose) {
            Timer.showStdErr("Annotating:" + (this.vcfInputFile != null ? "\tInput file    : '" + this.vcfInputFile + "'" : "") + "\tDatabase file : '" + this.dbFileName + "'");
        }
        if (this.verbose) {
            Timer.showStdErr("Annotating method: " + (Object)((Object)this.method));
        }
        switch (this.method) {
            case MEMORY: {
                this.annotateDb = new AnnotateVcfDbMem(this.dbFileName);
                break;
            }
            case SORTED_VCF: {
                this.annotateDb = new AnnotateVcfDbSorted(this.dbFileName, this.maxBlockSize);
                break;
            }
            case TABIX: {
                this.annotateDb = new AnnotateVcfDbTabix(this.dbFileName);
                break;
            }
            default: {
                throw new RuntimeException("Unknwon method '" + (Object)((Object)this.method) + "'");
            }
        }
        this.annotateDb.setAnnotateEmpty(this.annotateEmpty);
        this.annotateDb.setUseId(this.useId);
        this.annotateDb.setUseRefAlt(this.useRefAlt);
        this.annotateDb.setInfoFields(this.useInfoField, this.infoFields);
        this.annotateDb.setExistsInfoField(this.existsInfoField);
        this.annotateDb.setPrependInfoFieldName(this.prependInfoFieldName);
        this.annotateDb.setDebug(this.debug);
        this.annotateDb.setVerbose(this.verbose);
        this.annotateDb.open();
        return false;
    }

    String fixDbName() {
        if (this.method == AnnotationMethod.TABIX && !this.dbFileName.endsWith(".gz") && Gpr.exists(this.dbFileName + ".gz")) {
            return this.dbFileName + ".gz";
        }
        return this.dbFileName;
    }

    AnnotationMethod guessAnnotationMethod() {
        if (this.method != null) {
            return this.method;
        }
        if (this.dbFileName.endsWith(".gz")) {
            if (Gpr.exists(this.dbFileName + ".tbi") || Gpr.exists(this.dbFileName + ".gz.tbi")) {
                return AnnotationMethod.TABIX;
            }
            throw new RuntimeException("Index not found for file '" + this.dbFileName + "'.\n\tERROR: Compressed VCF files require a tabix index.");
        }
        if (this.dbFileName.endsWith(".bgz")) {
            if (Gpr.exists(this.dbFileName + ".tbi") || Gpr.exists(this.dbFileName + ".bgz.tbi")) {
                return AnnotationMethod.TABIX;
            }
            throw new RuntimeException("Index not found for file '" + this.dbFileName + "'.\n\tERROR: Compressed VCF files require a tabix index.");
        }
        return AnnotationMethod.SORTED_VCF;
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> headerInfos = super.headers();
        if (this.useInfoField) {
            VcfFileIterator vcfDb = new VcfFileIterator(this.dbFileName);
            VcfHeader vcfDbHeader = vcfDb.readHeader();
            for (VcfHeaderInfo vcfHeaderDb : vcfDbHeader.getVcfHeaderInfo()) {
                String id = (this.prependInfoFieldName != null ? this.prependInfoFieldName : "") + vcfHeaderDb.getId();
                VcfHeaderInfo vcfHeaderFile = this.vcfFile.getVcfHeader().getVcfHeaderInfo(id);
                if (!this.isAnnotateInfo(vcfHeaderDb) || vcfHeaderDb.isImplicit() || vcfHeaderFile != null && !vcfHeaderFile.isImplicit()) continue;
                VcfHeaderInfo newHeader = new VcfHeaderInfo(vcfHeaderDb);
                if (this.prependInfoFieldName != null) {
                    newHeader.setId(id);
                }
                headerInfos.add(newHeader);
            }
        }
        if (this.existsInfoField != null) {
            VcfHeaderInfo existsHeader = new VcfHeaderInfo(this.existsInfoField, VcfInfoType.Flag, "1", "Variant exists in file '" + Gpr.baseName(this.dbFileName) + "'");
            headerInfos.add(existsHeader);
        }
        return headerInfos;
    }

    @Override
    public void init() {
        super.init();
        this.useInfoField = true;
        this.useId = true;
        this.useRefAlt = true;
        this.method = null;
        this.needsConfig = true;
        this.needsDb = true;
        this.dbTabix = true;
        this.maxBlockSize = 16384;
    }

    boolean isAnnotateInfo(VcfHeaderInfo vcfInfo) {
        if (this.infoFields == null) {
            return true;
        }
        for (String info : this.infoFields) {
            if (!vcfInfo.getId().equals(info)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        block32: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-a": {
                        this.annotateEmpty = true;
                        break;
                    }
                    case "-clinvar": {
                        this.dbType = "clinvar";
                        this.method = AnnotationMethod.TABIX;
                        break;
                    }
                    case "-dbsnp": {
                        this.dbType = "dbsnp";
                        this.method = AnnotationMethod.TABIX;
                        break;
                    }
                    case "-exists": {
                        if (args.length > i + 1) {
                            this.existsInfoField = args[++i];
                            break;
                        }
                        this.usage("Missing parameter -exists");
                        break;
                    }
                    case "-id": {
                        this.useId = true;
                        break;
                    }
                    case "-info": {
                        if (args.length <= i + 1) {
                            this.usage("Missing parameter -info");
                        }
                        this.useInfoField = true;
                        this.infoFields = new ArrayList();
                        for (String infoField : args[++i].split(",")) {
                            this.infoFields.add(infoField);
                        }
                        continue block32;
                    }
                    case "-maxblocksize": {
                        if (args.length > i + 1) {
                            this.maxBlockSize = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Missing parameter -maxBlockSize");
                        break;
                    }
                    case "-mem": {
                        this.method = AnnotationMethod.MEMORY;
                        break;
                    }
                    case "-name": {
                        if (args.length > i + 1) {
                            this.prependInfoFieldName = args[++i];
                            break;
                        }
                        this.usage("Missing parameter -name");
                        break;
                    }
                    case "-noalt": {
                        this.useRefAlt = false;
                        break;
                    }
                    case "-noid": {
                        this.useId = false;
                        break;
                    }
                    case "-noinfo": {
                        this.useInfoField = false;
                        break;
                    }
                    case "-sorted": {
                        this.method = AnnotationMethod.SORTED_VCF;
                        break;
                    }
                    case "-tabix": {
                        this.method = AnnotationMethod.TABIX;
                        break;
                    }
                    default: {
                        this.usage("Unknown command line option '" + arg + "'");
                    }
                }
                continue;
            }
            if (this.dbType == null && this.dbFileName == null) {
                this.dbFileName = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown extra parameter '" + arg + "'");
        }
        if (this.dbType == null && this.dbFileName == null) {
            this.usage("Missing database option or file: [-dbSnp | -clinVar | database.vcf ]");
        }
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.annotate(createList);
    }

    public void setAnnotateEmpty(boolean annotateEmpty) {
        this.annotateEmpty = annotateEmpty;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " [options] database.vcf file.vcf > newFile.vcf");
        System.err.println("\nDatabase options:");
        System.err.println("\tdatabase.vcf         : Use 'database.vcf' file as annotations database. Note: The VCF file can be bgzipped and tabix-indexed.");
        System.err.println("\t-dbsnp               : Use DbSnp database.");
        System.err.println("\t-clinvar             : Use ClinVar database.");
        System.err.println("\nCommand Options:");
        System.err.println("\t-a                   : Annotate fields, even if the database has an empty value (annotates using '.' for empty).");
        System.err.println("\t-exists <tag>        : Annotate whether the variant exists or not in the database (using 'tag' as an INFO field FLAG).");
        System.err.println("\t-id                  : Only annotate ID field (do not add INFO field). Default: " + this.useId);
        System.err.println("\t-info <list>         : Annotate using a list of info fields (list is a comma separated list of fields). Default: ALL.");
        System.err.println("\t-name str            : Prepend 'str' to all annotated INFO fields. Default: ''.");
        System.err.println("\t-maxBlockSize <int>  : Use 'max block size' when creating index ('-sorted' command line option). Default: " + this.maxBlockSize);
        System.err.println("\t-noAlt               : Do not use REF and ALT fields when comparing database.vcf entries to file.vcf entries. Default: " + !this.useRefAlt);
        System.err.println("\t-noId                : Do not annotate ID field. Default: " + !this.useId);
        System.err.println("\t-noInfo              : Do not annotate INFO fields. Default: " + !this.useInfoField);
        System.err.println("\t-sorted              : VCF database is sorted and uncompressed. Default: " + (this.method == AnnotationMethod.SORTED_VCF));
        System.err.println("\t-tabix               : VCF database is tabix-indexed. Default: " + (this.method == AnnotationMethod.TABIX));
        this.usageGenericAndDb();
        System.err.println("Note: According the the VCF's database format provided, SnpSift annotate uses different strategies");
        System.err.println("\t  i) plain VCF       : SnpSift indexes the VCF file (creating an index file *.sidx).");
        System.err.println("\t ii) bgzip+tabix     : SnpSift uses tabix's index.");
        System.exit(1);
    }

    static enum AnnotationMethod {
        SORTED_VCF,
        MEMORY,
        TABIX;

    }
}

