/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.List;

public class PedigreeEnrty {
    public String father;
    public String mother;
    public String child;
    public int fatherNum = -1;
    public int motherNum = -1;
    public int childNum = -1;

    public PedigreeEnrty(String original, String derived) {
        this.child = derived;
        this.father = original;
        this.mother = null;
    }

    public PedigreeEnrty(String father, String mother, String child) {
        this.child = child;
        this.father = father;
        this.mother = mother;
    }

    public String getDerived() {
        return this.child;
    }

    public int getDerivedNum() {
        return this.childNum;
    }

    public String getOriginal() {
        return this.father;
    }

    public int getOriginalNum() {
        return this.fatherNum;
    }

    public boolean isDerived() {
        return this.mother == null && this.father != null;
    }

    public void sampleNumbers(List<String> sampleNames) {
        int i = 0;
        for (String sn : sampleNames) {
            if (sn.equals(this.father)) {
                this.fatherNum = i;
            }
            if (sn.equals(this.child)) {
                this.childNum = i;
            }
            if (this.mother != null && sn.equals(this.mother)) {
                this.motherNum = i;
            }
            ++i;
        }
        if (this.fatherNum < 0) {
            throw new RuntimeException("Cannot find pedigree Father/Original sample name '" + this.father + "'");
        }
        if (this.childNum < 0) {
            throw new RuntimeException("Cannot find pedigree Child/Derived sample name '" + this.child + "'");
        }
    }

    public String toString() {
        if (this.mother == null) {
            return "Derived=" + this.getDerived() + ", Original=" + this.getOriginal();
        }
        return "Child=" + this.child + ", Mother=" + this.mother + ", Father=" + this.father;
    }
}

