/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesAnnParse {
    boolean verbose = false;

    @Test
    public void test_EffectType() {
        Gpr.debug("Test");
        for (EffectType eff : EffectType.values()) {
            if (this.verbose) {
                System.out.println("\t" + (Object)((Object)eff));
            }
            eff.effectImpact();
            eff.getGeneRegion();
            for (EffFormatVersion formatVersion : EffFormatVersion.values()) {
                eff.toSequenceOntology(formatVersion, null);
            }
        }
    }

    @Test
    public void test_old_SO() {
        Gpr.debug("Test");
        EffectType eff = EffectType.parse(EffFormatVersion.DEFAULT_FORMAT_VERSION, "non_coding_exon_variant");
        Assert.assertTrue("Effect type not found", eff != null);
        Assert.assertEquals("Effect type does not match", (Object)eff, (Object)EffectType.EXON);
    }

    @Test
    public void test_old_SO_vcf() {
        Gpr.debug("Test");
        String vcfFile = "tests/test_old_SO_01.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println(veff.getEffectsStrSo() + "\t" + (Object)((Object)veff.getEffectType()));
                }
                Assert.assertEquals("Effect type does not match", (Object)veff.getEffectType(), (Object)EffectType.EXON);
            }
        }
    }

    @Test
    public void testCase_tfbs_ablation() {
        Gpr.debug("Test");
        String vcfFile = "tests/tfbs_ablation.vcf";
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        boolean ok = false;
        for (VcfEntry ve : vcf) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t" + veff.getEffectsStrSo());
                }
                ok |= veff.getEffectsStrSo().indexOf("TFBS_ablation") >= 0;
            }
        }
        Assert.assertTrue("SO term 'TFBS_ablation' not found", ok);
    }
}

