/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffectFusion;

public class VariantEffectStructural
extends VariantEffect {
    List<Marker> featuresLeft = new LinkedList<Marker>();
    List<Marker> featuresRight = new LinkedList<Marker>();
    Set<Gene> genes = new HashSet<Gene>();
    int countWholeGenes = 0;
    int countPartialGenes = 0;

    public VariantEffectStructural(Variant variant) {
        this(variant, null);
    }

    public VariantEffectStructural(Variant variant, Markers intersects) {
        super(variant);
        if (intersects != null) {
            this.setGenes(intersects);
            this.setEffect(this.effect());
        }
    }

    protected int countGenes(List<Marker> features) {
        int count2 = 0;
        for (Marker m : features) {
            if (!(m instanceof Gene)) continue;
            ++count2;
        }
        return count2;
    }

    protected EffectType effect() {
        switch (this.variant.getVariantType()) {
            case INV: {
                return this.countWholeGenes > 0 ? EffectType.GENE_INVERSION : EffectType.NONE;
            }
            case DEL: {
                return this.countWholeGenes > 1 ? EffectType.GENE_DELETED : EffectType.NONE;
            }
            case DUP: {
                return this.countWholeGenes > 0 ? EffectType.GENE_DUPLICATION : EffectType.NONE;
            }
            case BND: {
                int countGenesLeft = this.countGenes(this.featuresLeft);
                int countGenesRight = this.countGenes(this.featuresRight);
                if (countGenesLeft > 0 && countGenesRight > 0) {
                    return EffectType.GENE_FUSION;
                }
                if (countGenesLeft > 0 || countGenesRight > 0) {
                    return EffectType.GENE_FUSION_HALF;
                }
                return EffectType.FEATURE_FUSION;
            }
        }
        throw new RuntimeException("Unknown effect for variant type " + (Object)((Object)this.variant.getVariantType()));
    }

    public List<VariantEffect> fusions() {
        if (this.featuresLeft.isEmpty() || this.featuresRight.isEmpty()) {
            return null;
        }
        LinkedList<VariantEffect> fusions = new LinkedList<VariantEffect>();
        for (Marker marker : this.featuresLeft) {
            for (Marker gRight : this.featuresRight) {
                Marker gIntersect;
                if (!this.variant.isBnd() && (!this.isGene(marker) || !this.isGene(gRight) || marker.getId().equals(gRight.getId()) || (gIntersect = marker.intersect(gRight)) != null && gIntersect.includes(this.variant))) continue;
                fusions.addAll(this.fusions(this.variant, marker, gRight));
            }
        }
        if (fusions.size() > 0) {
            int countGeneGeneFusion = 0;
            for (VariantEffect fusion : fusions) {
                if (!((VariantEffectFusion)fusion).isGeneGeneFusion()) continue;
                ++countGeneGeneFusion;
            }
            if (countGeneGeneFusion > 0 && fusions.size() > countGeneGeneFusion) {
                LinkedList<VariantEffect> linkedList = new LinkedList<VariantEffect>();
                for (VariantEffect fusion : fusions) {
                    if (!((VariantEffectFusion)fusion).isGeneGeneFusion()) continue;
                    linkedList.add(fusion);
                }
                fusions = linkedList;
            }
        }
        return fusions;
    }

    List<VariantEffect> fusions(Variant variant, Marker mLeft, Marker mRight) {
        LinkedList<VariantEffect> fusions = new LinkedList<VariantEffect>();
        Markers msLeft = new Markers();
        Markers msRight = new Markers();
        Gene gLeft = null;
        if (this.isGene(mLeft)) {
            gLeft = (Gene)mLeft;
            msLeft.addAll(gLeft.subIntervals());
        } else {
            msLeft.add(mLeft);
        }
        Gene gRight = null;
        if (this.isGene(mRight)) {
            gRight = (Gene)mRight;
            msRight.addAll(gRight.subIntervals());
        } else {
            msRight.add(mRight);
        }
        for (Marker ml : msLeft) {
            for (Marker mr : msRight) {
                if (this.isTranscript(ml) && this.isTranscript(mr) && gLeft.getId().equals(gRight.getId()) && ml.getId().compareTo(mr.getId()) > 0) continue;
                VariantEffectFusion fusion = new VariantEffectFusion(variant, ml, mr);
                fusions.add(fusion);
            }
        }
        return fusions;
    }

    @Override
    public Gene getGene() {
        for (Marker m : this.featuresLeft) {
            if (!this.isGene(m)) continue;
            return (Gene)m;
        }
        for (Marker m : this.featuresRight) {
            if (!this.isGene(m)) continue;
            return (Gene)m;
        }
        return null;
    }

    @Override
    public List<Gene> getGenes() {
        ArrayList<Gene> list2 = new ArrayList<Gene>();
        list2.addAll(this.genes);
        return list2;
    }

    @Override
    public Marker getMarker() {
        return this.getGene();
    }

    boolean intersectsLeft(Marker m) {
        return m.getChromosomeName().equals(this.variant.getChromosomeName()) && m.intersects(this.variant.getStart());
    }

    boolean intersectsRight(Marker m) {
        if (this.variant.isBnd()) {
            Marker endPoint = ((VariantBnd)this.variant).getEndPoint();
            return m.getChromosomeName().equals(endPoint.getChromosomeName()) && m.intersects(endPoint.getStart());
        }
        return m.getChromosomeName().equals(this.variant.getChromosomeName()) && m.intersects(this.variant.getEnd());
    }

    protected boolean isGene(Marker m) {
        return m instanceof Gene;
    }

    @Override
    public boolean isMultipleGenes() {
        return true;
    }

    protected boolean isTranscript(Marker m) {
        return m instanceof Transcript;
    }

    void setGenes(Markers intersects) {
        for (Marker m : intersects) {
            if (m instanceof Gene) {
                if (this.intersectsLeft(m)) {
                    this.featuresLeft.add(m);
                }
                if (this.intersectsRight(m)) {
                    this.featuresRight.add(m);
                }
                if (this.variant.includes(m)) {
                    ++this.countWholeGenes;
                } else {
                    ++this.countPartialGenes;
                }
                this.genes.add((Gene)m);
                continue;
            }
            if (m instanceof Chromosome) continue;
            if (this.intersectsLeft(m)) {
                this.featuresLeft.add(m);
            }
            if (!this.intersectsRight(m)) continue;
            this.featuresRight.add(m);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toStr());
        sb.append("\n\tGene left  : [");
        for (Marker m : this.featuresLeft) {
            sb.append(" " + m.getId());
        }
        sb.append("]");
        sb.append("\n\tGene right  : [");
        for (Marker m : this.featuresRight) {
            sb.append(" " + m.getId());
        }
        sb.append("]");
        sb.append("\n\tGenes all: [");
        for (Gene g : this.genes) {
            sb.append(g.getGeneName() + " ");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

